"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructMetadata = void 0;
/**
 * Metadata keys used by constructs.
 *
 * @stability stable
 */
class ConstructMetadata {
    constructor() { }
}
exports.ConstructMetadata = ConstructMetadata;
/**
 * If set in the construct's context, omits stack traces from metadata entries.
 *
 * @stability stable
 */
ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA = 'disable-stack-trace';
/**
 * Context type for info level messages.
 *
 * @stability stable
 */
ConstructMetadata.INFO_METADATA_KEY = 'info';
/**
 * Context type for warning level messages.
 *
 * @stability stable
 */
ConstructMetadata.WARNING_METADATA_KEY = 'warning';
/**
 * Context type for error level messages.
 *
 * @stability stable
 */
ConstructMetadata.ERROR_METADATA_KEY = 'error';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0YWRhdGEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvbWV0YWRhdGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUEwQkEsTUFBYSxpQkFBaUI7SUFxQjVCLGdCQUF3QixDQUFDOztBQXJCM0IsOENBc0JDOzs7Ozs7QUFsQndCLGlEQUErQixHQUFHLHFCQUFxQixDQUFDOzs7Ozs7QUFLeEQsbUNBQWlCLEdBQUcsTUFBTSxDQUFDOzs7Ozs7QUFLM0Isc0NBQW9CLEdBQUcsU0FBUyxDQUFDOzs7Ozs7QUFLakMsb0NBQWtCLEdBQUcsT0FBTyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBNZXRhZGF0YUVudHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGF0YTogYW55O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0cmFjZT86IHN0cmluZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENvbnN0cnVjdE1ldGFkYXRhIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERJU0FCTEVfU1RBQ0tfVFJBQ0VfSU5fTUVUQURBVEEgPSAnZGlzYWJsZS1zdGFjay10cmFjZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IElORk9fTUVUQURBVEFfS0VZID0gJ2luZm8nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBXQVJOSU5HX01FVEFEQVRBX0tFWSA9ICd3YXJuaW5nJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVSUk9SX01FVEFEQVRBX0tFWSA9ICdlcnJvcic7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHsgfVxufSJdfQ==