# How To Contribute

Hi! Thank you for taking a peek over here. That means that you're at least somewhat _curious_ as to how you could contribute to the project. Even if that's all you're doing, THANKS!

My hope is to make it easy enough to contribute to this project in any capacity! Spot a typo? Found a bug? Have an idea for a feature? If you're here, you're off to a great start!

There are many ways to contribute, some may not even have anything to do with this repository or code! Here are some of the things that would be greatly appreciated:

- Tell someone else about the project (this is a GREAT contribution!)
- Write a blog or social post about how to use this project
- Read through the documentation, such as the README, or even this document, and suggest fixes (typos, grammar, or clarification)
- Clean up code comments for clarity
- Submit a bug report through our issues
- Fork the project and create a pull request if you can fix the bug yourself
- Request a feature (nicely!)

Generally, if you're in doubt and are unsure if something is working the way it should be working, go ahead and file an issue.

## Ground Rules

- Be considerate. Any decision you take, however minor, will affect someone else.
- Each pull request should implement ONE feature or bugfix. If you want to work on multiple things, please submit more than one pull request.
- Do not commit changes to files that are irrelevant to your feature or bugfix (even if it's just a typo)
- Please don't add new dependencies
- Be willing to accept that not all your suggestions may be heeded
- Don't be a jerk

## Your First Contribution

If you've never created a pull request, it may be helpful to read some guides. Here is one from GitHub, but the workflow should be the same here.

- [Beginner’s guide to GitHub: Creating a pull request](https://github.blog/developer-skills/github/beginners-guide-to-github-creating-a-pull-request/)

Once you have identified something you want to change, you can follow the guide, but also, feel free to ask for help! Everyone is a beginner at first!

## Reporting A Bug

If you find a security vulnerability, do NOT open an issue. Email pythonbynight@gmail.com instead.

When filing an issue, please make sure to include:
- Version of Python
- Operating system
- What did you do?
- What did you expect to see?
- What did you see instead?

## Suggesting A Feature or Enhancement

If you find that there is a feature that is missing from League Manager, you're probably not the only one. Keep in mind that this is a small project, and not everything can be added, even if it seems like it is obviously missing.

To suggest a feature, open an issue and include:
- Description of feature you want to see
- Why do you need it?
- How should it work?

If you want to work on this feature yourself, please comment on the issue with your intent to work on it.

**Note: Your pull request will not be merged if you are not able to explain exactly what it is accomplishing**

As mentioned above, pull requests should **not** contain multiple issues. Exceptions are only in the case when a current issue references other issues, and those issues are required to be complete for the current issue to be addressed.

## Last Thing

This document may change slightly as the project matures. Please be respectful of changes that you may not have noticed before.
