# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class ServerGroup(pulumi.CustomResource):
    members: pulumi.Output[list]
    """
    The instances that are part of this server group.
    """
    name: pulumi.Output[str]
    """
    A unique name for the server group. Changing this creates
    a new server group.
    """
    policies: pulumi.Output[list]
    """
    The set of policies for the server group. All policies
    are mutually exclusive. See the Policies section for more information.
    Changing this creates a new server group.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Compute client.
    If omitted, the `region` argument of the provider is used. Changing
    this creates a new server group.
    """
    value_specs: pulumi.Output[dict]
    """
    Map of additional options.
    """
    def __init__(__self__, resource_name, opts=None, name=None, policies=None, region=None, value_specs=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V2 Server Group resource within OpenStack.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_openstack as openstack

        test_sg = openstack.compute.ServerGroup("test-sg", policies=["anti-affinity"])
        ```

        ## Policies

        * `affinity` - All instances/servers launched in this group will be hosted on
            the same compute node.

        * `anti-affinity` - All instances/servers launched in this group will be
            hosted on different compute nodes.

        * `soft-affinity` - All instances/servers launched in this group will be hosted
            on the same compute node if possible, but if not possible they
            still will be scheduled instead of failure. To use this policy your
            OpenStack environment should support Compute service API 2.15 or above.

        * `soft-anti-affinity` - All instances/servers launched in this group will be
            hosted on different compute nodes if possible, but if not possible they
            still will be scheduled instead of failure. To use this policy your
            OpenStack environment should support Compute service API 2.15 or above.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: A unique name for the server group. Changing this creates
               a new server group.
        :param pulumi.Input[list] policies: The set of policies for the server group. All policies
               are mutually exclusive. See the Policies section for more information.
               Changing this creates a new server group.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               If omitted, the `region` argument of the provider is used. Changing
               this creates a new server group.
        :param pulumi.Input[dict] value_specs: Map of additional options.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['name'] = name
            __props__['policies'] = policies
            __props__['region'] = region
            __props__['value_specs'] = value_specs
            __props__['members'] = None
        super(ServerGroup, __self__).__init__(
            'openstack:compute/serverGroup:ServerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, members=None, name=None, policies=None, region=None, value_specs=None):
        """
        Get an existing ServerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] members: The instances that are part of this server group.
        :param pulumi.Input[str] name: A unique name for the server group. Changing this creates
               a new server group.
        :param pulumi.Input[list] policies: The set of policies for the server group. All policies
               are mutually exclusive. See the Policies section for more information.
               Changing this creates a new server group.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               If omitted, the `region` argument of the provider is used. Changing
               this creates a new server group.
        :param pulumi.Input[dict] value_specs: Map of additional options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["members"] = members
        __props__["name"] = name
        __props__["policies"] = policies
        __props__["region"] = region
        __props__["value_specs"] = value_specs
        return ServerGroup(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

