# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class OrderV1(pulumi.CustomResource):
    container_ref: pulumi.Output[str]
    """
    The container reference / where to find the container.
    """
    created: pulumi.Output[str]
    """
    The date the order was created.
    """
    creator_id: pulumi.Output[str]
    """
    The creator of the order.
    """
    meta: pulumi.Output[dict]
    """
    Dictionary containing the order metadata used to generate the order. The structure is described below.

      * `algorithm` (`str`) - Algorithm to use for key generation.
      * `bit_length` (`float`) - - Bit lenght of key to be generated.
      * `expiration` (`str`) - This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
      * `mode` (`str`) - The mode to use for key generation.
      * `name` (`str`) - The name of the secret set by the user.
      * `payload_content_type` (`str`) - The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
    """
    order_ref: pulumi.Output[str]
    """
    The order reference / where to find the order.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V1 KeyManager client.
    A KeyManager client is needed to create a order. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    V1 order.
    """
    secret_ref: pulumi.Output[str]
    """
    The secret reference / where to find the secret.
    """
    status: pulumi.Output[str]
    """
    The status of the order.
    """
    sub_status: pulumi.Output[str]
    """
    The sub status of the order.
    """
    sub_status_message: pulumi.Output[str]
    """
    The sub status message of the order.
    """
    type: pulumi.Output[str]
    """
    The type of key to be generated. Must be one of `asymmetric`, `key`.
    """
    updated: pulumi.Output[str]
    """
    The date the order was last updated.
    """
    def __init__(__self__, resource_name, opts=None, meta=None, region=None, type=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V1 Barbican order resource within OpenStack.

        ## Example Usage

        ### Symmetric key order

        ```python
        import pulumi
        import pulumi_openstack as openstack

        order1 = openstack.keymanager.OrderV1("order1",
            meta={
                "algorithm": "aes",
                "bit_length": 256,
                "mode": "cbc",
                "name": "mysecret",
            },
            type="key")
        ```

        ### Asymmetric key pair order

        ```python
        import pulumi
        import pulumi_openstack as openstack

        order1 = openstack.keymanager.OrderV1("order1",
            meta={
                "algorithm": "rsa",
                "bit_length": 4096,
                "name": "mysecret",
            },
            type="asymmetric")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] meta: Dictionary containing the order metadata used to generate the order. The structure is described below.
        :param pulumi.Input[str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a order. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 order.
        :param pulumi.Input[str] type: The type of key to be generated. Must be one of `asymmetric`, `key`.

        The **meta** object supports the following:

          * `algorithm` (`pulumi.Input[str]`) - Algorithm to use for key generation.
          * `bit_length` (`pulumi.Input[float]`) - - Bit lenght of key to be generated.
          * `expiration` (`pulumi.Input[str]`) - This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
          * `mode` (`pulumi.Input[str]`) - The mode to use for key generation.
          * `name` (`pulumi.Input[str]`) - The name of the secret set by the user.
          * `payload_content_type` (`pulumi.Input[str]`) - The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if meta is None:
                raise TypeError("Missing required property 'meta'")
            __props__['meta'] = meta
            __props__['region'] = region
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['container_ref'] = None
            __props__['created'] = None
            __props__['creator_id'] = None
            __props__['order_ref'] = None
            __props__['secret_ref'] = None
            __props__['status'] = None
            __props__['sub_status'] = None
            __props__['sub_status_message'] = None
            __props__['updated'] = None
        super(OrderV1, __self__).__init__(
            'openstack:keymanager/orderV1:OrderV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, container_ref=None, created=None, creator_id=None, meta=None, order_ref=None, region=None, secret_ref=None, status=None, sub_status=None, sub_status_message=None, type=None, updated=None):
        """
        Get an existing OrderV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_ref: The container reference / where to find the container.
        :param pulumi.Input[str] created: The date the order was created.
        :param pulumi.Input[str] creator_id: The creator of the order.
        :param pulumi.Input[dict] meta: Dictionary containing the order metadata used to generate the order. The structure is described below.
        :param pulumi.Input[str] order_ref: The order reference / where to find the order.
        :param pulumi.Input[str] region: The region in which to obtain the V1 KeyManager client.
               A KeyManager client is needed to create a order. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               V1 order.
        :param pulumi.Input[str] secret_ref: The secret reference / where to find the secret.
        :param pulumi.Input[str] status: The status of the order.
        :param pulumi.Input[str] sub_status: The sub status of the order.
        :param pulumi.Input[str] sub_status_message: The sub status message of the order.
        :param pulumi.Input[str] type: The type of key to be generated. Must be one of `asymmetric`, `key`.
        :param pulumi.Input[str] updated: The date the order was last updated.

        The **meta** object supports the following:

          * `algorithm` (`pulumi.Input[str]`) - Algorithm to use for key generation.
          * `bit_length` (`pulumi.Input[float]`) - - Bit lenght of key to be generated.
          * `expiration` (`pulumi.Input[str]`) - This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
          * `mode` (`pulumi.Input[str]`) - The mode to use for key generation.
          * `name` (`pulumi.Input[str]`) - The name of the secret set by the user.
          * `payload_content_type` (`pulumi.Input[str]`) - The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["container_ref"] = container_ref
        __props__["created"] = created
        __props__["creator_id"] = creator_id
        __props__["meta"] = meta
        __props__["order_ref"] = order_ref
        __props__["region"] = region
        __props__["secret_ref"] = secret_ref
        __props__["status"] = status
        __props__["sub_status"] = sub_status
        __props__["sub_status_message"] = sub_status_message
        __props__["type"] = type
        __props__["updated"] = updated
        return OrderV1(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

