# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class StackV1(pulumi.CustomResource):
    capabilities: pulumi.Output[list]
    """
    List of stack capabilities for stack.
    """
    creation_time: pulumi.Output[str]
    """
    The date and time when the resource was created. The date
    and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
    For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
    is the time zone as an offset from UTC.
    """
    description: pulumi.Output[str]
    """
    The description of the stack resource.
    """
    disable_rollback: pulumi.Output[bool]
    """
    Enables or disables deletion of all stack
    resources when a stack creation fails. Default is true, meaning all
    resources are not deleted when stack creation fails.
    """
    environment_opts: pulumi.Output[dict]
    """
    Environment key/value pairs to associate with
    the stack which contains details for the environment of the stack.
    Allowed keys: Bin, URL, Files. Changing this updates the existing stack
    Environment Opts.
    """
    name: pulumi.Output[str]
    """
    A unique name for the stack. It must start with an
    alphabetic character. Changing this updates the stack's name.
    """
    notification_topics: pulumi.Output[list]
    """
    List of notification topics for stack.
    """
    outputs: pulumi.Output[list]
    """
    A list of stack outputs.

      * `description` (`str`) - The description of the stack resource.
      * `outputKey` (`str`)
      * `outputValue` (`str`)
    """
    parameters: pulumi.Output[dict]
    """
    User-defined key/value pairs as parameters to pass
    to the template. Changing this updates the existing stack parameters.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the stack. If
    omitted, the `region` argument of the provider is used. Changing this
    creates a new stack.
    """
    status: pulumi.Output[str]
    """
    The status of the stack.
    """
    status_reason: pulumi.Output[str]
    """
    The reason for the current status of the stack.
    """
    tags: pulumi.Output[list]
    """
    A list of tags to assosciate with the Stack
    """
    template_description: pulumi.Output[str]
    """
    The description of the stack template.
    """
    template_opts: pulumi.Output[dict]
    """
    Template key/value pairs to associate with the
    stack which contains either the template file or url.
    Allowed keys: Bin, URL, Files. Changing this updates the existing stack
    Template Opts.
    """
    timeout: pulumi.Output[float]
    """
    The timeout for stack action in minutes.
    """
    updated_time: pulumi.Output[str]
    """
    The date and time when the resource was updated. The date
    and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
    For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
    is the time zone as an offset from UTC.
    """
    def __init__(__self__, resource_name, opts=None, capabilities=None, creation_time=None, description=None, disable_rollback=None, environment_opts=None, name=None, notification_topics=None, outputs=None, parameters=None, region=None, status=None, status_reason=None, tags=None, template_description=None, template_opts=None, timeout=None, updated_time=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V1 stack resource within OpenStack.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_openstack as openstack

        stack1 = openstack.orchestration.StackV1("stack1",
            disable_rollback=True,
            environment_opts={
                "Bin": "\n\n",
            },
            parameters={
                "length": 4,
            },
            template_opts={
                "Bin": \"\"\"heat_template_version: 2013-05-23
        parameters:
          length:
            type: number
        resources:
          test_res:
            type: OS::Heat::TestResource
          random:
            type: OS::Heat::RandomString
            properties:
              length: {get_param: length}

        \"\"\",
            },
            timeout=30)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[str] description: The description of the stack resource.
        :param pulumi.Input[bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[dict] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[list] notification_topics: List of notification topics for stack.
        :param pulumi.Input[list] outputs: A list of stack outputs.
        :param pulumi.Input[dict] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[str] status: The status of the stack.
        :param pulumi.Input[str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[list] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[str] template_description: The description of the stack template.
        :param pulumi.Input[dict] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[float] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.

        The **outputs** object supports the following:

          * `description` (`pulumi.Input[str]`) - The description of the stack resource.
          * `outputKey` (`pulumi.Input[str]`)
          * `outputValue` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['capabilities'] = capabilities
            __props__['creation_time'] = creation_time
            __props__['description'] = description
            __props__['disable_rollback'] = disable_rollback
            __props__['environment_opts'] = environment_opts
            __props__['name'] = name
            __props__['notification_topics'] = notification_topics
            __props__['outputs'] = outputs
            __props__['parameters'] = parameters
            __props__['region'] = region
            __props__['status'] = status
            __props__['status_reason'] = status_reason
            __props__['tags'] = tags
            __props__['template_description'] = template_description
            if template_opts is None:
                raise TypeError("Missing required property 'template_opts'")
            __props__['template_opts'] = template_opts
            __props__['timeout'] = timeout
            __props__['updated_time'] = updated_time
        super(StackV1, __self__).__init__(
            'openstack:orchestration/stackV1:StackV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, capabilities=None, creation_time=None, description=None, disable_rollback=None, environment_opts=None, name=None, notification_topics=None, outputs=None, parameters=None, region=None, status=None, status_reason=None, tags=None, template_description=None, template_opts=None, timeout=None, updated_time=None):
        """
        Get an existing StackV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[str] description: The description of the stack resource.
        :param pulumi.Input[bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[dict] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[list] notification_topics: List of notification topics for stack.
        :param pulumi.Input[list] outputs: A list of stack outputs.
        :param pulumi.Input[dict] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[str] status: The status of the stack.
        :param pulumi.Input[str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[list] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[str] template_description: The description of the stack template.
        :param pulumi.Input[dict] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[float] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.

        The **outputs** object supports the following:

          * `description` (`pulumi.Input[str]`) - The description of the stack resource.
          * `outputKey` (`pulumi.Input[str]`)
          * `outputValue` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["capabilities"] = capabilities
        __props__["creation_time"] = creation_time
        __props__["description"] = description
        __props__["disable_rollback"] = disable_rollback
        __props__["environment_opts"] = environment_opts
        __props__["name"] = name
        __props__["notification_topics"] = notification_topics
        __props__["outputs"] = outputs
        __props__["parameters"] = parameters
        __props__["region"] = region
        __props__["status"] = status
        __props__["status_reason"] = status_reason
        __props__["tags"] = tags
        __props__["template_description"] = template_description
        __props__["template_opts"] = template_opts
        __props__["timeout"] = timeout
        __props__["updated_time"] = updated_time
        return StackV1(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

