# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QuotaArgs', 'Quota']

@pulumi.input_type
class QuotaArgs:
    def __init__(__self__, *,
                 entity_type: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Quota resource.
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity (client-id, user, ip)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: A map of string k/v properties.
        :param pulumi.Input[_builtins.str] entity_name: The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        """
        pulumi.set(__self__, "entity_type", entity_type)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the entity (client-id, user, ip)
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string k/v properties.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_name", value)


@pulumi.input_type
class _QuotaState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Quota resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: A map of string k/v properties.
        :param pulumi.Input[_builtins.str] entity_name: The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity (client-id, user, ip)
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if entity_name is not None:
            pulumi.set(__self__, "entity_name", entity_name)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string k/v properties.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        """
        return pulumi.get(self, "entity_name")

    @entity_name.setter
    def entity_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_name", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the entity (client-id, user, ip)
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)


@pulumi.type_token("kafka:index/quota:Quota")
class Quota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `Quota` resource manages Kafka quotas, which are used to limit resource usage and prevent any single client from monopolizing broker resources. Quotas can be applied to clients, users, or IP addresses to control bandwidth and request rates.

        ## Example Usage

        ### Client ID Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Limit a specific client's bandwidth
        mobile_app = kafka.Quota("mobile_app",
            entity_name="mobile-app-v1",
            entity_type="client-id",
            config={
                "consumer_byte_rate": "5000000",
                "producer_byte_rate": "2500000",
                "request_percentage": "200",
            })
        ```

        ### User Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Set quotas for a specific user
        service_account = kafka.Quota("service_account",
            entity_name="payment-service",
            entity_type="user",
            config={
                "consumer_byte_rate": "10000000",
                "producer_byte_rate": "10000000",
                "request_percentage": "400",
            })
        ```

        ### Default User Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Set default quotas for all users (when entity_name is omitted)
        default_user = kafka.Quota("default_user",
            entity_type="user",
            config={
                "consumer_byte_rate": "2000000",
                "producer_byte_rate": "1000000",
                "request_percentage": "100",
            })
        ```

        ### IP Address Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Rate limit connections from a specific IP
        external_ip = kafka.Quota("external_ip",
            entity_name="203.0.113.0",
            entity_type="ip",
            config={
                "connection_creation_rate": "10",
            })
        ```

        ## Quota Configuration Options

        ### Bandwidth Quotas
        - `producer_byte_rate` - The maximum bytes per second that can be produced by the entity
        - `consumer_byte_rate` - The maximum bytes per second that can be consumed by the entity

        ### Request Rate Quotas
        - `request_percentage` - The percentage of CPU time on each broker that the entity can use for requests. Values > 100% indicate multiple CPUs (e.g., 200% = 2 CPUs)

        ### Connection Quotas (IP-based only)
        - `connection_creation_rate` - The maximum rate of new connections per second from the IP address

        ## Quota Precedence

        When multiple quotas apply to a request, Kafka uses the most specific quota:

        1. `/config/users/<user>/clients/<client-id>` (most specific)
        2. `/config/users/<user>/clients/<default>`
        3. `/config/users/<user>`
        4. `/config/users/<default>/clients/<client-id>`
        5. `/config/users/<default>/clients/<default>`
        6. `/config/users/<default>` (least specific)

        ## Best Practices

        1. **Start with Conservative Defaults**: Set reasonable default quotas for all users/clients and then create specific quotas for services that need higher limits.

        2. **Monitor Quota Usage**: Use Kafka metrics to monitor quota utilization and adjust as needed. Look for throttling metrics to identify when quotas are being hit.

        3. **Use Request Percentage Carefully**: The `request_percentage` quota affects CPU usage. Values over 100% mean the client can use more than one CPU core.

        4. **Plan for Growth**: Set quotas with some headroom to accommodate traffic growth, but not so high that a misbehaving client can impact the cluster.

        5. **Different Quotas for Different Environments**: Use stricter quotas in development/staging environments compared to production.

        > **Note:** Quotas are applied immediately but may take a few seconds to propagate across all brokers.

        ## Import

        Kafka quotas can be imported using the entity type and name:

        For named entities

        ```sh
        $ pulumi import kafka:index/quota:Quota example client-id:my-client
        ```

        For default quotas (no entity name)

        ```sh
        $ pulumi import kafka:index/quota:Quota default_user user:
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: A map of string k/v properties.
        :param pulumi.Input[_builtins.str] entity_name: The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity (client-id, user, ip)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Quota` resource manages Kafka quotas, which are used to limit resource usage and prevent any single client from monopolizing broker resources. Quotas can be applied to clients, users, or IP addresses to control bandwidth and request rates.

        ## Example Usage

        ### Client ID Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Limit a specific client's bandwidth
        mobile_app = kafka.Quota("mobile_app",
            entity_name="mobile-app-v1",
            entity_type="client-id",
            config={
                "consumer_byte_rate": "5000000",
                "producer_byte_rate": "2500000",
                "request_percentage": "200",
            })
        ```

        ### User Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Set quotas for a specific user
        service_account = kafka.Quota("service_account",
            entity_name="payment-service",
            entity_type="user",
            config={
                "consumer_byte_rate": "10000000",
                "producer_byte_rate": "10000000",
                "request_percentage": "400",
            })
        ```

        ### Default User Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Set default quotas for all users (when entity_name is omitted)
        default_user = kafka.Quota("default_user",
            entity_type="user",
            config={
                "consumer_byte_rate": "2000000",
                "producer_byte_rate": "1000000",
                "request_percentage": "100",
            })
        ```

        ### IP Address Quota

        ```python
        import pulumi
        import pulumi_kafka as kafka

        # Rate limit connections from a specific IP
        external_ip = kafka.Quota("external_ip",
            entity_name="203.0.113.0",
            entity_type="ip",
            config={
                "connection_creation_rate": "10",
            })
        ```

        ## Quota Configuration Options

        ### Bandwidth Quotas
        - `producer_byte_rate` - The maximum bytes per second that can be produced by the entity
        - `consumer_byte_rate` - The maximum bytes per second that can be consumed by the entity

        ### Request Rate Quotas
        - `request_percentage` - The percentage of CPU time on each broker that the entity can use for requests. Values > 100% indicate multiple CPUs (e.g., 200% = 2 CPUs)

        ### Connection Quotas (IP-based only)
        - `connection_creation_rate` - The maximum rate of new connections per second from the IP address

        ## Quota Precedence

        When multiple quotas apply to a request, Kafka uses the most specific quota:

        1. `/config/users/<user>/clients/<client-id>` (most specific)
        2. `/config/users/<user>/clients/<default>`
        3. `/config/users/<user>`
        4. `/config/users/<default>/clients/<client-id>`
        5. `/config/users/<default>/clients/<default>`
        6. `/config/users/<default>` (least specific)

        ## Best Practices

        1. **Start with Conservative Defaults**: Set reasonable default quotas for all users/clients and then create specific quotas for services that need higher limits.

        2. **Monitor Quota Usage**: Use Kafka metrics to monitor quota utilization and adjust as needed. Look for throttling metrics to identify when quotas are being hit.

        3. **Use Request Percentage Carefully**: The `request_percentage` quota affects CPU usage. Values over 100% mean the client can use more than one CPU core.

        4. **Plan for Growth**: Set quotas with some headroom to accommodate traffic growth, but not so high that a misbehaving client can impact the cluster.

        5. **Different Quotas for Different Environments**: Use stricter quotas in development/staging environments compared to production.

        > **Note:** Quotas are applied immediately but may take a few seconds to propagate across all brokers.

        ## Import

        Kafka quotas can be imported using the entity type and name:

        For named entities

        ```sh
        $ pulumi import kafka:index/quota:Quota example client-id:my-client
        ```

        For default quotas (no entity name)

        ```sh
        $ pulumi import kafka:index/quota:Quota default_user user:
        ```

        :param str resource_name: The name of the resource.
        :param QuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaArgs.__new__(QuotaArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["entity_name"] = entity_name
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
        super(Quota, __self__).__init__(
            'kafka:index/quota:Quota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            entity_name: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Quota':
        """
        Get an existing Quota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: A map of string k/v properties.
        :param pulumi.Input[_builtins.str] entity_name: The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        :param pulumi.Input[_builtins.str] entity_type: The type of the entity (client-id, user, ip)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaState.__new__(_QuotaState)

        __props__.__dict__["config"] = config
        __props__.__dict__["entity_name"] = entity_name
        __props__.__dict__["entity_type"] = entity_type
        return Quota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of string k/v properties.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the entity (if entity_name is not provided, it will create entity-default Kafka quota)
        """
        return pulumi.get(self, "entity_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the entity (client-id, user, ip)
        """
        return pulumi.get(self, "entity_type")

