"""Data types and operations from Discovery and Synchronization Service 1.0.0 OpenAPI"""

# This file is autogenerated; do not modify manually!

from __future__ import annotations

from enum import Enum

from implicitdict import ImplicitDict, StringBasedDateTime

from uas_standards.utils import Operation

API_VERSION = "1.0.0"
"""Version of Discovery and Synchronization Service OpenAPI specification from which the objects in this package were generated."""

URL = str
"""Valid http or https URL."""


SubscriptionNotificationIndex = int
"""Tracks the notifications sent for a subscription so the subscriber can detect missed notifications more easily."""


UUIDv4 = str
"""UUID v4."""


Version = str
"""A version string used to reference an object at a particular point in time. Any updates to an object must contain the corresponding version to maintain idempotent updates."""


EntityUUID = UUIDv4


SubscriptionUUID = UUIDv4


RIDFlightID = str
"""ID, unique to a remote ID service provider, which identifies a particular flight for which the remote ID service provider is providing remote ID services.

The following characters are not allowed: \\0 \\t \\r \\n # % / : ? @ [ \\ ]
"""


class RIDAuthData(ImplicitDict):
    """Additional authentication data."""

    format: str
    """Format of additional authentication data."""

    data: str
    """Authentication data in form specified by `format`."""


class HorizontalAccuracy(str, Enum):
    """This is the NACp enumeration from ADS-B, plus 1m for a more complete range for UAs.

    `HAUnknown`: Unknown horizontal accuracy

    `HA10NMPlus`: > 10NM (18.52km)

    `HA10NM`: < 10NM (18.52km)

    `HA4NM`: < 4NM (7.408km)

    `HA2NM`: < 2NM (3.704km)

    `HA1NM`: < 1NM (1852m)

    `HA05NM`: < 0.5NM (926m)

    `HA03NM`: < 0.3NM (555.6m)

    `HA01NM`: < 0.1NM (185.2m)

    `HA005NM`: < 0.05NM (92.6m)

    `HA30m`: < 30m

    `HA10m`: < 10m

    `HA3m`: < 3m

    `HA1m`: < 1m
    """

    HAUnknown = "HAUnknown"
    HA10NMPlus = "HA10NMPlus"
    HA10NM = "HA10NM"
    HA4NM = "HA4NM"
    HA2NM = "HA2NM"
    HA1NM = "HA1NM"
    HA05NM = "HA05NM"
    HA03NM = "HA03NM"
    HA01NM = "HA01NM"
    HA005NM = "HA005NM"
    HA30m = "HA30m"
    HA10m = "HA10m"
    HA3m = "HA3m"
    HA1m = "HA1m"


class VerticalAccuracy(str, Enum):
    """This is the GVA enumeration from ADS-B, plus some finer values for UAs.

    `VAUnknown`: Unknown vertical accuracy

    `VA150mPlus`: > 150m

    `VA150m`: < 150m

    `VA45m`: < 45m

    `VA25m`: < 25m

    `VA10m`: < 10m

    `VA3m`: < 3m

    `VA1m`: < 1m
    """

    VAUnknown = "VAUnknown"
    VA150mPlus = "VA150mPlus"
    VA150m = "VA150m"
    VA45m = "VA45m"
    VA25m = "VA25m"
    VA10m = "VA10m"
    VA3m = "VA3m"
    VA1m = "VA1m"


class ErrorResponse(ImplicitDict):
    """Data provided when an off-nominal condition was encountered."""

    message: str | None
    """Human-readable message indicating what error occurred and/or why."""


class SpeedAccuracy(str, Enum):
    """This is the same enumeration scale and values from ADS-B NACv.

    `SAUnknown`: Unknown speed accuracy

    `SA10mpsPlus`: > 10 m/s

    `SA10mps`: < 10 m/s

    `SA3mps`: < 3 m/s

    `SA1mps`: < 1 m/s

    `SA03mps`: < 0.3 m/s
    """

    SAUnknown = "SAUnknown"
    SA10mpsPlus = "SA10mpsPlus"
    SA10mps = "SA10mps"
    SA3mps = "SA3mps"
    SA1mps = "SA1mps"
    SA03mps = "SA03mps"


GeoPolygonString = str
"""Plain-string representation of a geographic polygon consisting of at least three geographic points describing a closed polygon on the earth.  Each point consists of latitude,longitude in degrees.  Points are also comma-delimited, so this parameter will look like `lat1,lng1,lat2,lng2,lat3,lng3,...`  Latitude values must fall in the range [-90, 90] and longitude values must fall in the range [-180, 180].

All of the requirements and clarifications for GeoPolygon apply to GeoPolygonString as well.
"""


class RIDHeightReference(str, Enum):
    """The reference datum above which the height is reported."""

    TakeoffLocation = "TakeoffLocation"
    GroundLevel = "GroundLevel"


class RIDHeight(ImplicitDict):
    """A relative altitude for the purposes of remote ID."""

    distance: float
    """Distance above reference datum.  This value is provided in meters and must have a minimum resolution of 1 meter."""

    reference: RIDHeightReference
    """The reference datum above which the height is reported."""


Latitude = float
"""Degrees of latitude north of the equator, with reference to the WGS84 ellipsoid."""


Longitude = float
"""Degrees of longitude east of the Prime Meridian, with reference to the WGS84 ellipsoid."""


class LatLngPoint(ImplicitDict):
    """Point on the earth's surface."""

    lng: Longitude

    lat: Latitude


Altitude = float
"""An altitude, in meters, above the WGS84 ellipsoid."""


class GeoPolygon(ImplicitDict):
    """An enclosed area on the earth.
    The bounding edges of this polygon shall be the shortest paths between connected vertices.  This means, for instance, that the edge between two points both defined at a particular latitude is not generally contained at that latitude.
    The winding order shall be interpreted as the order which produces the smaller area.
    The path between two vertices shall be the shortest possible path between those vertices.
    Edges may not cross.
    Vertices may not be duplicated.  In particular, the final polygon vertex shall not be identical to the first vertex.
    """

    vertices: list[LatLngPoint]


IdentificationServiceAreaURL = str
"""The URL at which notifications regarding Identification Service Areas may be delivered.  See the `/uss/identification_service_areas/{id}` path for specification of this endpoint."""


class SubscriptionCallbacks(ImplicitDict):
    """Endpoints that should be called when an applicable event occurs.  At least one field must be specified."""

    identification_service_area_url: IdentificationServiceAreaURL | None
    """If specified, other clients will be instructed by the DSS to call this endpoint when an Identification Service Area relevant to this Subscription is created, modified, or deleted.  Must implement PUT and DELETE according to the `/uss/identification_service_areas/{id}` path API."""


class RIDOperationalStatus(str, Enum):
    """Indicates operational status of associated aircraft."""

    Undeclared = "Undeclared"
    Ground = "Ground"
    Airborne = "Airborne"


class RIDFlightDetails(ImplicitDict):
    """Details about a flight reported by a remote ID service provider.  At least one of the registration or serial fields must be filled if required by CAA."""

    id: str
    """ID for this flight, matching argument in request."""

    operator_id: str | None
    """CAA-issued registration/license ID for the remote pilot or operator. """

    operator_location: LatLngPoint | None
    """Location of party controlling the aircraft."""

    operation_description: str | None
    """Free-text field that enables the operator to describe the purpose of a flight, if so desired."""

    auth_data: RIDAuthData | None

    serial_number: str | None
    """Can be specified when no registration ID exists and required by law in a region. This is expressed in the ANSI/CTA-2063-A Physical Serial Number format."""

    registration_number: str | None
    """If a CAA provides a method of registering UAS, this number is provided by the CAA or its authorized representative.  Required when required by law in a region."""


class Subscription(ImplicitDict):
    """Specification of a geographic area that a client is interested in on an ongoing basis (e.g., “planning area”).  Internal to the DSS."""

    id: SubscriptionUUID
    """Unique identifier for this subscription."""

    callbacks: SubscriptionCallbacks

    owner: str
    """Assigned by the DSS based on creating client’s ID (via access token).  Used for restricting mutation and deletion operations to owner."""

    notification_index: SubscriptionNotificationIndex

    time_end: StringBasedDateTime | None
    """If set, this subscription will be automatically removed after this time.  RFC 3339 format, per OpenAPI specification."""

    time_start: StringBasedDateTime | None
    """If set, this Subscription will not generate any notifications before this time.  RFC 3339 format, per OpenAPI specification."""

    version: Version


class RIDAircraftType(str, Enum):
    """Type of aircraft for the purposes of remote ID.

    `VTOL` is a fixed wing aircraft that can take off vertically.  `Helicopter` includes multirotor.
    """

    NotDeclared = "NotDeclared"
    Aeroplane = "Aeroplane"
    Helicopter = "Helicopter"
    Gyroplane = "Gyroplane"
    VTOL = "VTOL"
    Ornithopter = "Ornithopter"
    Glider = "Glider"
    Kite = "Kite"
    FreeBalloon = "FreeBalloon"
    CaptiveBalloon = "CaptiveBalloon"
    Airship = "Airship"
    FreeFallOrParachute = "FreeFallOrParachute"
    Rocket = "Rocket"
    TetheredPoweredAircraft = "TetheredPoweredAircraft"
    GroundObstacle = "GroundObstacle"
    Other = "Other"


RIDFlightsURL = str
"""The URL at which the remote ID flights and their details may be retrieved.  See `/flights` and `/flights/{id}/details` paths for specification of this endpoint.
This URL is the base flights resource.  If this URL is specified as https://example.com/flights then the flight details for a particular {id} may be obtained at the URL https://example.com/flights/{id}/details.  This URL may not have a trailing / character.
"""


class Volume3D(ImplicitDict):
    """A three-dimensional geographic volume consisting of a vertically-extruded polygon."""

    footprint: GeoPolygon
    """Projection of this volume onto the earth's surface."""

    altitude_lo: Altitude | None
    """Minimum bounding altitude of this volume."""

    altitude_hi: Altitude | None
    """Maximum bounding altitude of this volume."""


class Volume4D(ImplicitDict):
    """Contiguous block of geographic spacetime."""

    spatial_volume: Volume3D
    """Constant spatial extent of this volume."""

    time_start: StringBasedDateTime | None
    """Beginning time of this volume.  RFC 3339 format, per OpenAPI specification."""

    time_end: StringBasedDateTime | None
    """End time of this volume.  RFC 3339 format, per OpenAPI specification."""


class GetSubscriptionResponse(ImplicitDict):
    """Response to DSS request for the subscription with the given id."""

    subscription: Subscription


class SearchSubscriptionsResponse(ImplicitDict):
    """Response to DSS query for subscriptions in a particular area."""

    subscriptions: list[Subscription]
    """Subscriptions that overlap the specified area."""


class SubscriptionState(ImplicitDict):
    """State of AreaSubscription which is causing a notification to be sent."""

    subscription_id: SubscriptionUUID

    notification_index: SubscriptionNotificationIndex | None


class GetFlightDetailsResponse(ImplicitDict):
    """Response to remote ID provider query for details about a specific flight."""

    details: RIDFlightDetails


class DeleteSubscriptionResponse(ImplicitDict):
    """Response for a successful request to delete an Subscription."""

    subscription: Subscription
    """The Subscription which was deleted."""


class RIDAircraftPosition(ImplicitDict):
    """Position of an aircraft as reported for remote ID purposes."""

    lat: Latitude

    lng: Longitude

    alt: float
    """Geodetic altitude (NOT altitude above launch, altitude above ground, or EGM96): aircraft distance above the WGS84 ellipsoid as measured along a line that passes through the aircraft and is normal to the surface of the WGS84 ellipsoid.  This value is provided in meters and must have a minimum resolution of 1 meter."""

    accuracy_h: HorizontalAccuracy | None
    """Horizontal error that is likely to be present in this reported position.  Required when `extrapolated` field is true and always in the entry for the current state."""

    accuracy_v: VerticalAccuracy | None
    """Vertical error that is likely to be present in this reported position.  Required when `extrapolated` field is true and always in the entry for the current state."""

    extrapolated: bool | None
    """True if this position was generated primarily by computation rather than primarily from a direct instrument measurement.  Assumed false if not specified."""

    pressure_altitude: float | None
    """The uncorrected altitude (based on reference standard 29.92 inHg, 1013.25 mb) provides a reference for algorithms that utilize "altitude deltas" between aircraft.  This value is provided in meters and must have a minimum resolution of 1 meter."""


class SubscriberToNotify(ImplicitDict):
    """Subscriber to notify of a creation/change/deletion of a change in the airspace.  This is provided by the DSS to a client changing the airspace, and it is the responsibility of the client changing the airspace (they will receive a set of these notification requests) to send a notification to each specified `url`."""

    subscriptions: list[SubscriptionState]
    """Subscription(s) prompting this notification."""

    url: URL
    """The endpoint that the client mutating the airspace should provide the update to.  API depends on the DSS action taken that triggered this notification request."""


class RIDRecentAircraftPosition(ImplicitDict):
    time: StringBasedDateTime
    """Time at which this position applied.  RFC 3339 format, per OpenAPI specification."""

    position: RIDAircraftPosition


class CreateIdentificationServiceAreaParameters(ImplicitDict):
    """Parameters for a request to create an Identification Service Area in the DSS."""

    extents: Volume4D
    """The bounding spacetime extents of this Identification Service Area.  End time must be specified.  If start time is not specified, it will be set to the current time.  Start times in the past should be rejected by the DSS, except that it may adjust very recent start times to the current time.

    These extents should not reveal any sensitive information about the flight or flights within them.  This means, for instance, that extents should not tightly-wrap a flight path, nor should they generally be centered around the takeoff point of a single flight.
    """

    flights_url: RIDFlightsURL


class UpdateIdentificationServiceAreaParameters(ImplicitDict):
    """Parameters for a request to update an Identification Service Area in the DSS."""

    extents: Volume4D
    """The bounding spacetime extents of this Identification Service Area.  End time must be specified.  If start time is not specified, it will remain unchanged.  Start times in the past should be rejected by the DSS unless they are unchanged from the Identification Service Area's current start time.

    These extents should not reveal any sensitive information about the flight or flights within them.  This means, for instance, that extents should not tightly-wrap a flight path, nor should they generally be centered around the takeoff point of a single flight.
    """

    flights_url: RIDFlightsURL


class CreateSubscriptionParameters(ImplicitDict):
    """Parameters for a request to create a subscription in the DSS."""

    extents: Volume4D
    """The spacetime extents of the volume to subscribe to.

    This subscription will automatically be deleted after its end time if it has not been refreshed by then.  If end time is not specified, the value will be chosen automatically by the DSS.

    Note that some Entities triggering notifications may lie entirely outside the requested area.
    """

    callbacks: SubscriptionCallbacks


class UpdateSubscriptionParameters(ImplicitDict):
    """Parameters for a request to update a subscription in the DSS."""

    extents: Volume4D
    """The spacetime extents of the volume to subscribe to.

    This subscription will automatically be deleted after its end time if it has not been refreshed by then.  If end time is not specified, the value will be chosen automatically by the DSS.

    Note that some Entities triggering notifications may lie entirely outside the requested area.
    """

    callbacks: SubscriptionCallbacks


class IdentificationServiceArea(ImplicitDict):
    """An Identification Service Area (area in which remote ID services are being provided).  The DSS reports only these declarations and clients must exchange flight information peer-to-peer."""

    flights_url: RIDFlightsURL

    owner: str
    """Assigned by the DSS based on creating client’s ID (via access token).  Used for restricting mutation and deletion operations to owner."""

    time_start: StringBasedDateTime
    """Beginning time of service.  RFC 3339 format, per OpenAPI specification."""

    time_end: StringBasedDateTime
    """End time of service.  RFC 3339 format, per OpenAPI specification."""

    version: Version

    id: EntityUUID
    """Unique identifier for this Identification Service Area."""


class RIDAircraftState(ImplicitDict):
    """State of an aircraft for the purposes of remote ID."""

    timestamp: StringBasedDateTime
    """Time at which this state was valid.  This may be the time coming from the source, such as a GPS, or the time when the system computes the values using an algorithm such as an Extended Kalman Filter (EKF).  Timestamp must be expressed with a minimum resolution of 1/10th of a second.  RFC 3339 format, per OpenAPI specification."""

    timestamp_accuracy: float
    """Declaration of timestamp accuracy, which is the largest difference between Timestamp and true time of applicability for any of the following fields: Latitude, Longitude, Geodetic Altitude, Pressure Altitude of Position, Height. to determine time of applicability of the location data provided.  Expressed in seconds, precise to 1/10ths of seconds. The accuracy reflects the 95% uncertainty bound value for the timestamp."""

    operational_status: RIDOperationalStatus | None

    position: RIDAircraftPosition

    track: float
    """Direction of flight expressed as a "True North-based" ground track angle.  This value is provided in degrees East of North with a minimum resolution of 1 degree."""

    speed: float
    """Ground speed of flight in meters per second."""

    speed_accuracy: SpeedAccuracy
    """Accuracy of horizontal ground speed."""

    vertical_speed: float
    """Speed up (vertically) WGS84-HAE, m/s."""

    height: RIDHeight | None

    group_radius: float | None
    """Farthest horizontal distance from reported group location at which an aircraft in the group may be located (meters).  This value contains the "Operating Area Radius" data from the common data dictionary when group operation area is specified by point-radius."""

    group_ceiling: float | None
    """Maximum altitude (meters WGS84-HAE) of Group Operation.  This value contains the "Operating Area Ceiling" data from the common data dictionary when group operation area is specified by point-radius."""

    group_floor: float | None
    """Minimum altitude (meters WGS84-HAE) of Group Operation.  If not specified, ground level shall be assumed.  This value contains the "Operating Area Floor" data from the common data dictionary when group operation area is specified by point-radius."""

    group_count: int | None
    """When operating a group (or formation or swarm), number of aircraft in group.  This value contains the "Operating Area Count" data from the common data dictionary when group operation area is specified by point-radius."""

    group_time_start: StringBasedDateTime | None
    """Time at which a group operation starts.  This value contains the "Operation Area Start" data from the common data dictionary when group operation area is specified by point-radius."""

    group_time_end: StringBasedDateTime | None
    """Time at which a group operation starts.  This value contains the "Operation Area End" data from the common data dictionary when group operation area is specified by point-radius."""


class RIDFlight(ImplicitDict):
    """Description of a remote ID flight."""

    id: RIDFlightID

    aircraft_type: RIDAircraftType
    """Generic type of aircraft."""

    current_state: RIDAircraftState | None
    """The most up-to-date state of the aircraft.  Required when the aircraft is currently in the requested area unless `volumes` is specified.

    If current data is not being received from the UAS by the Service Provider, the lack of change in this field is sufficient to indicate that current data is not being received.
    """

    volumes: list[Volume4D] | None
    """The set of spacetime volumes the aircraft is within.  Required if `current_state` is not specified.  The fields `time_start` and `time_end` are required if `current_state` is not specified."""

    simulated: bool | None
    """If specified as true, this flight is not a physical aircraft; it is just a simulation to test the system."""

    recent_positions: list[RIDRecentAircraftPosition] | None
    """A short collection of recent aircraft movement, specified only when `include_recent_positions` is true.  If `volumes` is not specified and `include_recent_positions` is true, then this field is required.

    Recent positions provided in this field must conform to requirements in the standard which generally prohibit including positions outside the requested area except transitionally when the aircraft enters or exits the requested area, and which prohibit including positions that not sufficiently recent.

    Note that a UI should not draw a connective line between two consecutive position reports that both lie outside the requested area.
    """


class PutIdentificationServiceAreaResponse(ImplicitDict):
    """Response to a request to create or update a reference to an Identification Service Area in the DSS."""

    subscribers: list[SubscriberToNotify]
    """DSS subscribers that this client now has the obligation to notify of the Identification Service Area changes just made.  This client must call POST for each provided URL according to the `/uss/identification_service_areas/{id}` path API."""

    service_area: IdentificationServiceArea
    """Resulting service area stored in DSS."""


class SearchIdentificationServiceAreasResponse(ImplicitDict):
    """Response to DSS query for Identification Service Areas in an area of interest."""

    service_areas: list[IdentificationServiceArea]
    """Identification Service Areas in the area of interest."""


class PutIdentificationServiceAreaNotificationParameters(ImplicitDict):
    """Parameters of a message informing of new full information for an Identification Service Area.  Pushed (by a client, not the DSS) directly to clients with subscriptions when another client makes a change to airspace within a cell with a subscription."""

    service_area: IdentificationServiceArea | None
    """Identification Service Area that the notifying client changed or created.

    If this field is populated, the Identification Service Area was created or updated.  If this field is not populated, the Identification Service Area was deleted.
    """

    subscriptions: list[SubscriptionState]
    """Subscription(s) prompting this notification."""

    extents: Volume4D | None
    """The new or updated extents of the Identification Service Area.

    Omitted if Identification Service Area was deleted.
    """


class DeleteIdentificationServiceAreaResponse(ImplicitDict):
    """Response for a request to delete an Identification Service Area."""

    service_area: IdentificationServiceArea
    """Indentification Service Area that was just deleted."""

    subscribers: list[SubscriberToNotify]
    """DSS subscribers that this client now has the obligation to notify of the Identification Service Area just deleted.  This client must call POST for each provided URL according to the `/uss/identification_service_areas` path API."""


class PutSubscriptionResponse(ImplicitDict):
    """Response for a request to create or update a subscription."""

    service_areas: list[IdentificationServiceArea] | None
    """Identification Service Areas in or near the subscription area at the time of creation/update, if `identification_service_area_url` callback was specified."""

    subscription: Subscription
    """Result of the operation on the subscription."""


class GetIdentificationServiceAreaResponse(ImplicitDict):
    """Response to DSS request for the identification service area with the given id."""

    service_area: IdentificationServiceArea


class GetFlightsResponse(ImplicitDict):
    """Response to remote ID provider query for flight information in an area of interest."""

    timestamp: StringBasedDateTime
    """The remote ID service provider's timestamp for when this information was current.  RFC 3339 format, per OpenAPI specification."""

    flights: list[RIDFlight]
    """A list of all flights that have been within the requested area within the remote ID retention period.  This includes flights that are not currently within the requested area, but were within the requested area within the remote ID retention period."""


class OperationID(str, Enum):
    SearchIdentificationServiceAreas = "searchIdentificationServiceAreas"
    GetIdentificationServiceArea = "getIdentificationServiceArea"
    CreateIdentificationServiceArea = "createIdentificationServiceArea"
    UpdateIdentificationServiceArea = "updateIdentificationServiceArea"
    DeleteIdentificationServiceArea = "deleteIdentificationServiceArea"
    SearchFlights = "searchFlights"
    GetFlightDetails = "getFlightDetails"
    SearchSubscriptions = "searchSubscriptions"
    GetSubscription = "getSubscription"
    CreateSubscription = "createSubscription"
    UpdateSubscription = "updateSubscription"
    DeleteSubscription = "deleteSubscription"
    PostIdentificationServiceArea = "postIdentificationServiceArea"


OPERATIONS: dict[OperationID, Operation] = {
    OperationID.SearchIdentificationServiceAreas: Operation(
        id="searchIdentificationServiceAreas",
        path="/v1/dss/identification_service_areas",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: SearchIdentificationServiceAreasResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetIdentificationServiceArea: Operation(
        id="getIdentificationServiceArea",
        path="/v1/dss/identification_service_areas/{id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.CreateIdentificationServiceArea: Operation(
        id="createIdentificationServiceArea",
        path="/v1/dss/identification_service_areas/{id}",
        verb="PUT",
        request_body_type=CreateIdentificationServiceAreaParameters,
        response_body_type={
            200: PutIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.UpdateIdentificationServiceArea: Operation(
        id="updateIdentificationServiceArea",
        path="/v1/dss/identification_service_areas/{id}/{version}",
        verb="PUT",
        request_body_type=UpdateIdentificationServiceAreaParameters,
        response_body_type={
            200: PutIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.DeleteIdentificationServiceArea: Operation(
        id="deleteIdentificationServiceArea",
        path="/v1/dss/identification_service_areas/{id}/{version}",
        verb="DELETE",
        request_body_type=None,
        response_body_type={
            200: DeleteIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
            409: ErrorResponse,
        },
    ),
    OperationID.SearchFlights: Operation(
        id="searchFlights",
        path="/v1/uss/flights",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetFlightsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetFlightDetails: Operation(
        id="getFlightDetails",
        path="/v1/uss/flights/{id}/details",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetFlightDetailsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.SearchSubscriptions: Operation(
        id="searchSubscriptions",
        path="/v1/dss/subscriptions",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: SearchSubscriptionsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetSubscription: Operation(
        id="getSubscription",
        path="/v1/dss/subscriptions/{id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.CreateSubscription: Operation(
        id="createSubscription",
        path="/v1/dss/subscriptions/{id}",
        verb="PUT",
        request_body_type=CreateSubscriptionParameters,
        response_body_type={
            200: PutSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            429: ErrorResponse,
        },
    ),
    OperationID.UpdateSubscription: Operation(
        id="updateSubscription",
        path="/v1/dss/subscriptions/{id}/{version}",
        verb="PUT",
        request_body_type=UpdateSubscriptionParameters,
        response_body_type={
            200: PutSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            429: ErrorResponse,
        },
    ),
    OperationID.DeleteSubscription: Operation(
        id="deleteSubscription",
        path="/v1/dss/subscriptions/{id}/{version}",
        verb="DELETE",
        request_body_type=None,
        response_body_type={
            200: DeleteSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
            409: ErrorResponse,
        },
    ),
    OperationID.PostIdentificationServiceArea: Operation(
        id="postIdentificationServiceArea",
        path="/v1/uss/identification_service_areas/{id}",
        verb="POST",
        request_body_type=PutIdentificationServiceAreaNotificationParameters,
        response_body_type={
            204: None,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
        },
    ),
}
