"""Data types and operations from Standard Remote ID API Interfaces 2.1.0 OpenAPI"""

# This file is autogenerated; do not modify manually!

from __future__ import annotations

from enum import Enum

from implicitdict import ImplicitDict, StringBasedDateTime

from uas_standards.utils import Operation

API_VERSION = "2.1.0"
"""Version of Standard Remote ID API Interfaces OpenAPI specification from which the objects in this package were generated."""


class TimeFormat(str, Enum):
    RFC3339 = "RFC3339"


class Time(ImplicitDict):
    value: StringBasedDateTime
    """RFC3339-formatted time/date string.  The time zone must be 'Z'."""

    format: TimeFormat = TimeFormat.RFC3339


class RadiusUnits(str, Enum):
    """FIXM-compatible units.  Only meters ("M") are acceptable for UTM."""

    M = "M"


class Radius(ImplicitDict):
    value: float
    """Distance from the centerpoint of a circular area, along the WGS84 ellipsoid."""

    units: RadiusUnits = RadiusUnits.M
    """FIXM-compatible units.  Only meters ("M") are acceptable for UTM."""


URL = str
"""Valid http or https URL."""


SubscriptionNotificationIndex = int
"""Tracks the notifications sent for a subscription so the subscriber can detect missed notifications more easily."""


UUIDv4 = str
"""UUID v4."""


Version = str
"""A version string used to reference an object at a particular point in time. Any updates to an object must contain the corresponding version to maintain idempotent updates."""


EntityUUID = UUIDv4


SubscriptionUUID = UUIDv4


RIDFlightID = str
"""ID, unique to a remote ID service provider, which identifies a particular flight for which the remote ID service provider is providing remote ID services.

The following characters are not allowed: \\0 \\t \\r \\n # % / : ? @ [ \\ ]
"""


class RIDAuthData(ImplicitDict):
    """Additional authentication data."""

    format: int | None = 0
    """Format of additional authentication data.

    0: None
    1: UAS ID Signature
    2: Operator ID Signature
    3: Message Set Signature
    4: Authentication Provided by Network Remote ID
    5: Specific Method
    6-9: Reserved for Spec
    10-15: Available for Private Use
    """

    data: str | None = ""
    """Authentication data in form specified by `format`."""


class HorizontalAccuracy(str, Enum):
    """This is based on ADS-B NACp (plus the one extra increment).

    `HAUnknown`: Unknown horizontal accuracy

    `HA10NMPlus`: > 10NM (18.52km)

    `HA10NM`: < 10NM (18.52km)

    `HA4NM`: < 4NM (7.408km)

    `HA2NM`: < 2NM (3.704km)

    `HA1NM`: < 1NM (1852m)

    `HA05NM`: < 0.5NM (926m)

    `HA03NM`: < 0.3NM (555.6m)

    `HA01NM`: < 0.1NM (185.2m)

    `HA005NM`: < 0.05NM (92.6m)

    `HA30m`: < 30m

    `HA10m`: < 10m

    `HA3m`: < 3m

    `HA1m`: < 1m
    """

    HAUnknown = "HAUnknown"
    HA10NMPlus = "HA10NMPlus"
    HA10NM = "HA10NM"
    HA4NM = "HA4NM"
    HA2NM = "HA2NM"
    HA1NM = "HA1NM"
    HA05NM = "HA05NM"
    HA03NM = "HA03NM"
    HA01NM = "HA01NM"
    HA005NM = "HA005NM"
    HA30m = "HA30m"
    HA10m = "HA10m"
    HA3m = "HA3m"
    HA1m = "HA1m"


class VerticalAccuracy(str, Enum):
    """This is based on ADS-B Geodetic Vertical Accuracy (GVA) (plus the three extra increments)

    `VAUnknown`: Unknown vertical accuracy

    `VA150mPlus`: > 150m

    `VA150m`: < 150m

    `VA45m`: < 45m

    `VA25m`: < 25m

    `VA10m`: < 10m

    `VA3m`: < 3m

    `VA1m`: < 1m
    """

    VAUnknown = "VAUnknown"
    VA150mPlus = "VA150mPlus"
    VA150m = "VA150m"
    VA45m = "VA45m"
    VA25m = "VA25m"
    VA10m = "VA10m"
    VA3m = "VA3m"
    VA1m = "VA1m"


class ErrorResponse(ImplicitDict):
    """Data provided when an off-nominal condition was encountered."""

    message: str | None = ""
    """Human-readable message indicating what error occurred and/or why."""


class SpeedAccuracy(str, Enum):
    """Provides quality/containment on horizontal ground speed.

    `SAUnknown`: Unknown speed accuracy

    `SA10mpsPlus`: > 10 m/s

    `SA10mps`: < 10 m/s

    `SA3mps`: < 3 m/s

    `SA1mps`: < 1 m/s

    `SA03mps`: < 0.3 m/s
    """

    SAUnknown = "SAUnknown"
    SA10mpsPlus = "SA10mpsPlus"
    SA10mps = "SA10mps"
    SA3mps = "SA3mps"
    SA1mps = "SA1mps"
    SA03mps = "SA03mps"


GeoPolygonString = str
"""Plain-string representation of a geographic polygon consisting of at least three geographic
points describing a closed polygon on the earth.  Each point consists of latitude,longitude
in degrees.  Points are also comma-delimited, so this parameter will look like
`lat1,lng1,lat2,lng2,lat3,lng3,...`  Latitude values must fall in the range [-90, 90] and
longitude values must fall in the range [-180, 180].

All of the requirements and clarifications for Polygon apply to GeoPolygonString as well.
"""


class RIDHeightReference(str, Enum):
    """The reference datum above which the height is reported."""

    TakeoffLocation = "TakeoffLocation"
    GroundLevel = "GroundLevel"


class RIDHeight(ImplicitDict):
    """A relative altitude for the purposes of remote ID."""

    distance: float | None = 0
    """Distance above reference datum.  This value is provided in meters and must have a minimum resolution of 1 meter.  Invalid, No Value or Unknown is -1000 m."""

    reference: RIDHeightReference
    """The reference datum above which the height is reported."""


Latitude = float
"""Degrees of latitude north of the equator, with reference to the WGS84 ellipsoid.  Invalid, No Value, or Unknown is 0 degrees (both Lat/Lon)."""


Longitude = float
"""Degrees of longitude east of the Prime Meridian, with reference to the WGS84 ellipsoid.  Invalid, No Value, or Unknown is 0 degrees (both Lat/Lon)."""


class LatLngPoint(ImplicitDict):
    """Point on the earth's surface."""

    lng: Longitude

    lat: Latitude


class AltitudeReference(str, Enum):
    """A code indicating the reference for a vertical distance. See AIXM 5.1 and FIXM 4.2.0. Currently, UTM only allows WGS84 with no immediate plans to allow other options. FIXM and AIXM allow for 'SFC' which is equivalent to AGL."""

    W84 = "W84"


class AltitudeUnits(str, Enum):
    """The reference quantities used to express the value of altitude. See FIXM 4.2. Currently, UTM only allows meters with no immediate plans to allow other options."""

    M = "M"


class Altitude(ImplicitDict):
    value: float
    """The numeric value of the altitude. Note that min and max values are added as a sanity check. As use cases evolve and more options are made available in terms of units of measure or reference systems, these bounds may be re-evaluated. Invalid, No Value, or Unknown is –1000 m."""

    reference: AltitudeReference = AltitudeReference.W84
    """A code indicating the reference for a vertical distance. See AIXM 5.1 and FIXM 4.2.0. Currently, UTM only allows WGS84 with no immediate plans to allow other options. FIXM and AIXM allow for 'SFC' which is equivalent to AGL."""

    units: AltitudeUnits = AltitudeUnits.M
    """The reference quantities used to express the value of altitude. See FIXM 4.2. Currently, UTM only allows meters with no immediate plans to allow other options."""


class Polygon(ImplicitDict):
    """An enclosed area on the earth. The bounding edges of this polygon are defined to be the shortest paths between connected vertices.  This means, for instance, that the edge between two points both defined at a particular latitude is not generally contained at that latitude. The winding order must be interpreted as the order which produces the smaller area. The path between two vertices is defined to be the shortest possible path between those vertices. Edges may not cross. Vertices may not be duplicated.  In particular, the final polygon vertex must not be identical to the first vertex."""

    vertices: list[LatLngPoint]


class RIDOperationalStatus(str, Enum):
    """Operational Status indicates whether the associated UA is on the ground, airborne, or in an
    emergency situation, or the Remote ID system has failed. The emergency status takes
    precedence over the other status modes. This status can be used for filtering purposes.
    """

    Undeclared = "Undeclared"
    Ground = "Ground"
    Airborne = "Airborne"
    Emergency = "Emergency"
    RemoteIDSystemFailure = "RemoteIDSystemFailure"


SpecificSessionID = str
"""A unique 20 byte ID intended to identify a specific flight (session) while providing a
greater level of privacy to the operator. The first byte is the registered unique Specific Session ID
Type maintained by a registrar (see Annex A5), and the remaining 19 bytes is the Session ID per the
Specific Session ID Type specification.

Initial scheme registry entries include:

0 – reserved
1 – Internet Engineering Task Force (IETF) Drone Remote Identification Protocol (DRIP) entity ID
2 – IEEE 1609.2 HashedID8

Expressed as a hexadecimal string of the underlying data bytes.  A recipient should ignore any dashes in this value.  If fewer than 20 bytes are specified, the remaining bytes at the end are assumed to have value 0.
"""


class UASID(ImplicitDict):
    """Identification of the UAS performing this flight.  At least one field of this object must be specified."""

    serial_number: str | None = ""
    """This is expressed in the CTA-2063-A Serial Number format."""

    registration_id: str | None = ""
    """If a CAA provides a method of registering UAS, this number is provided by the CAA or its authorized representative.  Format is <ICAO Nationality MarkA>.<CAA Assigned ID>, ASCII encoded, only uppercase letters (A-Z), dot (.), and digits (0-9) are allowed. Example is valid for the US."""

    utm_id: str | None = ""
    """A UTM-provided universally unique ID traceable to a non-obfuscated ID that acts as a "session id" to protect exposure of operationally sensitive information."""

    specific_session_id: SpecificSessionID | None


class OperatorLocationAltitudeType(str, Enum):
    """Source of data for the altitude field."""

    Takeoff = "Takeoff"
    Dynamic = "Dynamic"
    Fixed = "Fixed"


class OperatorLocation(ImplicitDict):
    """Location associated with the Remote Pilot"""

    position: LatLngPoint
    """Position of the Remote Pilot."""

    altitude: Altitude | None
    """Provides the Operator Altitude based on WGS-84 height above ellipsoid (HAE) (See Geodetic Altitude).  This value is provided in meters and must have a minimum resolution of 1 m."""

    altitude_type: OperatorLocationAltitudeType | None
    """Source of data for the altitude field."""


class UAClassificationEUCategory(str, Enum):
    EUCategoryUndefined = "EUCategoryUndefined"
    Open = "Open"
    Specific = "Specific"
    Certified = "Certified"


class UAClassificationEUClass(str, Enum):
    EUClassUndefined = "EUClassUndefined"
    Class0 = "Class0"
    Class1 = "Class1"
    Class2 = "Class2"
    Class3 = "Class3"
    Class4 = "Class4"
    Class5 = "Class5"
    Class6 = "Class6"


UAClassificationEU = dict
"""Expected keys:
* category
* class
"""


class RIDFlightDetails(ImplicitDict):
    """Details about a flight reported by a remote ID service provider.  At least one of the registration or serial fields must be filled if required by CAA."""

    id: str
    """ID for this flight, matching argument in request."""

    eu_classification: UAClassificationEU | None
    """When this field is specified, the Classification Type is "European Union".  If no other classification field is specified, the Classification Type is "Undeclared"."""

    uas_id: UASID | None

    operator_id: str | None = ""
    """This optional field provides a CAA-issued registration/license ID for the remote pilot or operator. Format is <ICAO Nationality MarkA>.<CAA Assigned ID>, ASCII encoded, only uppercase letters (A-Z), dot (.), and digits (0-9) are allowed. Example is valid for the US."""

    operator_location: OperatorLocation | None

    operation_description: str | None = ""
    """Free-text field that enables the operator to describe the purpose of a flight, if so desired."""

    auth_data: RIDAuthData | None


class UAType(str, Enum):
    """The UA Type can help infer performance, speed, and duration of flights, for example, a
    "fixed wing" can generally fly in a forward direction only (as compared to a multi-rotor).
    This can also help differentiate aircraft types without sharing operationally sensitive
    information like the make and model of a particular aircraft. Make and model are
    anticipated to become available during the Registration ID lookup process. UAS Type is also
    useful for correlating visual observation with data received. The types were formulated
    based on unique flight characteristics.

    `HybridLift` is a fixed wing aircraft that can take off vertically.  `Helicopter` includes multirotor.
    """

    NotDeclared = "NotDeclared"
    Aeroplane = "Aeroplane"
    Helicopter = "Helicopter"
    Gyroplane = "Gyroplane"
    HybridLift = "HybridLift"
    Ornithopter = "Ornithopter"
    Glider = "Glider"
    Kite = "Kite"
    FreeBalloon = "FreeBalloon"
    CaptiveBalloon = "CaptiveBalloon"
    Airship = "Airship"
    FreeFallOrParachute = "FreeFallOrParachute"
    Rocket = "Rocket"
    TetheredPoweredAircraft = "TetheredPoweredAircraft"
    GroundObstacle = "GroundObstacle"
    Other = "Other"


USSBaseURL = str
"""The base URL of a USS implementation of part or all of the remote ID USS-USS API. Per the USS-USS API, the full URL
of a particular resource can be constructed by appending, e.g., `/uss/{resource}/{id}` to this base URL.
Accordingly, this URL may not have a trailing '/' character.
"""


SubscriptionUSSBaseURL = USSBaseURL


FlightsUSSBaseURL = USSBaseURL


class Circle(ImplicitDict):
    """A circular area on the surface of the earth."""

    center: LatLngPoint | None

    radius: Radius | None


class Volume3D(ImplicitDict):
    """A three-dimensional geographic volume consisting of a vertically-extruded shape. Exactly one outline must be specified."""

    outline_circle: Circle | None
    """A circular geographic shape on the surface of the earth."""

    outline_polygon: Polygon | None
    """A polygonal geographic shape on the surface of the earth."""

    altitude_lower: Altitude | None
    """Minimum bounding altitude of this volume. Must be less than altitude_upper, if specified."""

    altitude_upper: Altitude | None
    """Maximum bounding altitude of this volume. Must be greater than altitude_lower, if specified."""


class Volume4D(ImplicitDict):
    """Contiguous block of geographic spacetime."""

    volume: Volume3D

    time_start: Time | None
    """Beginning time of this volume. Must be before time_end."""

    time_end: Time | None
    """End time of this volume. Must be after time_start."""


class SubscriptionState(ImplicitDict):
    """State of Subscription which is causing a notification to be sent."""

    subscription_id: SubscriptionUUID

    notification_index: SubscriptionNotificationIndex | None = 0


class GetFlightDetailsResponse(ImplicitDict):
    """Response to remote ID provider query for details about a specific flight."""

    details: RIDFlightDetails


class RIDAircraftPosition(ImplicitDict):
    """Position of an aircraft as reported for remote ID purposes."""

    lat: Latitude | None

    lng: Longitude | None

    alt: float | None = -1000
    """Geodetic altitude (NOT altitude above launch, altitude above ground, or EGM96): aircraft distance above the WGS84 ellipsoid as measured along a line that passes through the aircraft and is normal to the surface of the WGS84 ellipsoid.  This value is provided in meters and must have a minimum resolution of 1 meter.  Invalid, No Value or Unknown is -1000 m."""

    accuracy_h: HorizontalAccuracy | None
    """Horizontal error that is likely to be present in this reported position.  Required when `extrapolated` field is true and always in the entry for the current state."""

    accuracy_v: VerticalAccuracy | None
    """Vertical error that is likely to be present in this reported position.  Required when `extrapolated` field is true and always in the entry for the current state."""

    extrapolated: bool | None = False
    """True if this position was generated primarily by computation rather than primarily from a direct instrument measurement.  Assumed false if not specified."""

    pressure_altitude: float | None = -1000
    """The uncorrected altitude (based on reference standard 29.92 inHg, 1013.25 mb) provides a reference for algorithms that utilize "altitude deltas" between aircraft.  This value is provided in meters and must have a minimum resolution of 1 meter.  Invalid, No Value or Unknown is -1000 m."""

    height: RIDHeight | None


class OperatingArea(ImplicitDict):
    """Area of operation containing one or more aircraft participating in remote identification."""

    aircraft_count: int | None
    """Allows for operating a single UA, group, formation, or swarm. Quantity in Group."""

    volumes: list[Volume4D] | None = []
    """The area where a group or Intent-Based Network Participant operation is planned or taking place."""


class SubscriberToNotify(ImplicitDict):
    """Subscriber to notify of a creation/change/deletion of a change in the airspace.  This is provided by the DSS to a client changing the airspace, and it is the responsibility of the client changing the airspace (they will receive a set of these notification requests) to send a notification to each specified `url`."""

    subscriptions: list[SubscriptionState]
    """Subscription(s) prompting this notification."""

    url: URL
    """The endpoint that the client mutating the airspace should provide the update to.  API depends on the DSS action taken that triggered this notification request."""


class RIDRecentAircraftPosition(ImplicitDict):
    time: Time
    """Time at which this position applied."""

    position: RIDAircraftPosition


class GetIdentificationServiceAreaDetailsResponse(ImplicitDict):
    """Response to request for the details of an identification service area with the given ID."""

    extents: Volume4D
    """The extents of the Identification Service Area."""


class CreateIdentificationServiceAreaParameters(ImplicitDict):
    """Parameters for a request to create an Identification Service Area in the DSS."""

    extents: Volume4D
    """The bounding spacetime extents of this Identification Service Area.  End time must be specified.  If start time is not specified, it will be set to the current time.  Start times in the past should be rejected by the DSS, except that it may adjust very recent start times to the current time.

    These extents should not reveal any sensitive information about the flight or flights within them.  This means, for instance, that extents should not tightly-wrap a flight path, nor should they generally be centered around the takeoff point of a single flight.
    """

    uss_base_url: FlightsUSSBaseURL


class UpdateIdentificationServiceAreaParameters(ImplicitDict):
    """Parameters for a request to update an Identification Service Area in the DSS."""

    extents: Volume4D
    """The bounding spacetime extents of this Identification Service Area.  End time must be specified.  If start time is not specified, it will remain unchanged.  Start times in the past should be rejected by the DSS unless they are unchanged from the Identification Service Area's current start time.

    These extents should not reveal any sensitive information about the flight or flights within them.  This means, for instance, that extents should not tightly-wrap a flight path, nor should they generally be centered around the takeoff point of a single flight.
    """

    uss_base_url: FlightsUSSBaseURL


class CreateSubscriptionParameters(ImplicitDict):
    """Parameters for a request to create a subscription in the DSS."""

    extents: Volume4D
    """The spacetime extents of the volume to subscribe to.

    This subscription will automatically be deleted after its end time if it has not been refreshed by then.  If end time is not specified, the value will be chosen automatically by the DSS.

    Note that some Entities triggering notifications may lie entirely outside the requested area.
    """

    uss_base_url: SubscriptionUSSBaseURL


class UpdateSubscriptionParameters(ImplicitDict):
    """Parameters for a request to update a subscription in the DSS."""

    extents: Volume4D
    """The spacetime extents of the volume to subscribe to.

    This subscription will automatically be deleted after its end time if it has not been refreshed by then.  If end time is not specified, the value will be chosen automatically by the DSS.

    Note that some Entities triggering notifications may lie entirely outside the requested area.
    """

    uss_base_url: SubscriptionUSSBaseURL


class Subscription(ImplicitDict):
    """Specification of a geographic area that a client is interested in on an ongoing basis (e.g., "planning area").  Internal to the DSS."""

    id: SubscriptionUUID
    """Unique identifier for this subscription."""

    uss_base_url: SubscriptionUSSBaseURL

    owner: str
    """Assigned by the DSS based on creating client’s ID (via access token).  Used for restricting mutation and deletion operations to owner."""

    notification_index: SubscriptionNotificationIndex | None = 0

    time_end: Time | None
    """If set, this subscription will be automatically removed after this time."""

    time_start: Time | None
    """If set, this Subscription will not generate any notifications before this time."""

    version: Version


class IdentificationServiceArea(ImplicitDict):
    """An Identification Service Area (area in which remote ID services are being provided).  The DSS reports only these declarations and clients must exchange flight information peer-to-peer."""

    uss_base_url: FlightsUSSBaseURL

    owner: str
    """Assigned by the DSS based on creating client’s ID (via access token).  Used for restricting mutation and deletion operations to owner."""

    time_start: Time
    """Beginning time of service."""

    time_end: Time
    """End time of service."""

    version: Version

    id: EntityUUID
    """Unique identifier for this Identification Service Area."""


class RIDAircraftState(ImplicitDict):
    """State of an aircraft for the purposes of remote ID."""

    timestamp: Time
    """Time at which this state was valid.  This may be the time coming from the source, such as a GPS, or the time when the system computes the values using an algorithm such as an Extended Kalman Filter (EKF).  Timestamp must be expressed with a minimum resolution of 1/10th of a second."""

    timestamp_accuracy: float = 0
    """Declaration of timestamp accuracy, which is the largest difference between Timestamp and true time of applicability for any of the following fields: Latitude, Longitude, Geodetic Altitude, Pressure Altitude of Position, Height. to determine time of applicability of the location data provided.  Expressed in seconds, precise to 1/10ths of seconds. The accuracy reflects the 95% uncertainty bound value for the timestamp."""

    operational_status: RIDOperationalStatus | None

    position: RIDAircraftPosition

    track: float | None = 361
    """Direction of flight expressed as a "True North-based" ground track angle.  This value is provided in clockwise degrees with a minimum resolution of 1 degree.  If aircraft is not moving horizontally, use the "Unknown" value.  A value of 361 indicates invalid, no value, or unknown."""

    speed: float | None = 255
    """Ground speed of flight in meters per second.  Invalid, No Value, or Unknown is 255 m/s, if speed is >254.25 m/s then report 254.25 m/s."""

    speed_accuracy: SpeedAccuracy
    """Provides quality/containment on horizontal ground speed."""

    vertical_speed: float | None = 63
    """Speed up (vertically) WGS84-HAE, m/s.  Invalid, No Value, or Unknown is 63 m/s, if speed is >62 m/s then report 62 m/s."""


class GetSubscriptionResponse(ImplicitDict):
    """Response to DSS request for the subscription with the given id."""

    subscription: Subscription


class SearchSubscriptionsResponse(ImplicitDict):
    """Response to DSS query for subscriptions in a particular area."""

    subscriptions: list[Subscription] | None = []
    """Subscriptions that overlap the specified area."""


class DeleteSubscriptionResponse(ImplicitDict):
    """Response for a successful request to delete an Subscription."""

    subscription: Subscription
    """The Subscription which was deleted."""


class RIDFlight(ImplicitDict):
    """Description of a remote ID flight."""

    id: RIDFlightID

    aircraft_type: UAType
    """Generic type of aircraft."""

    current_state: RIDAircraftState | None
    """The most up-to-date state of the aircraft.  Required when the aircraft is
    currently in the requested area unless no telemetry is expected during during
    the flight and `volumes` is specified.

    If current data is not being received from the UAS by the Service Provider,
    the lack of change in this field is sufficient to indicate that current
    data is not being received.

    If the USS believes a flight is airborne and expects to receive telemetry
    at some point during the flight but has not yet received telemetry, this
    field should be populated with the USS's best estimate of the position
    of the flight with appropriate accuracy indications.
    """

    operating_area: OperatingArea | None
    """The area the aircraft is/are within.  Required, with 1 or more elements, if
    `current_state` is not specified.  The fields `time_start` and `time_end` are
    required.

    If `current_state` is specified, this field should not be specified.
    If `current_state` was available at any time during the flight, or is
    expected to be available at any time during the flight, this field should
    not be specified.
    """

    simulated: bool | None = False
    """If specified as true, this flight is not a physical aircraft; it is just a simulation to test the system."""

    recent_positions: list[RIDRecentAircraftPosition] | None = []
    """A short collection of recent aircraft movement, specified only when `recent_positions_duration` is greater than zero.  If `volumes` is not specified and `recent_positions_duration` is greater than zero, then this field is required.

    Recent positions provided in this field must conform to requirements in the standard which generally prohibit including positions outside the requested area except transitionally when the aircraft enters or exits the requested area, and which prohibit including positions that not sufficiently recent.

    Note that a UI should not draw a connective line between two consecutive position reports that both lie outside the requested area.
    """


class PutIdentificationServiceAreaResponse(ImplicitDict):
    """Response to a request to create or update a reference to an Identification Service Area in the DSS."""

    subscribers: list[SubscriberToNotify] | None = []
    """DSS subscribers that this client now has the obligation to notify of the Identification Service Area changes just made.  This client must call POST for each provided URL according to the `/uss/identification_service_areas/{id}` path API."""

    service_area: IdentificationServiceArea
    """Resulting service area stored in DSS."""


class SearchIdentificationServiceAreasResponse(ImplicitDict):
    """Response to DSS query for Identification Service Areas in an area of interest."""

    service_areas: list[IdentificationServiceArea] | None = []
    """Identification Service Areas in the area of interest."""


class PutIdentificationServiceAreaNotificationParameters(ImplicitDict):
    """Parameters of a message informing of new full information for an Identification Service Area.  Pushed (by a client, not the DSS) directly to clients with subscriptions when another client makes a change to airspace within a cell with a subscription."""

    service_area: IdentificationServiceArea | None
    """Identification Service Area that the notifying client changed or created.

    If this field is populated, the Identification Service Area was created or updated.  If this field is not populated, the Identification Service Area was deleted.
    """

    subscriptions: list[SubscriptionState]
    """Subscription(s) prompting this notification."""

    extents: Volume4D | None
    """The new or updated extents of the Identification Service Area.

    Omitted if Identification Service Area was deleted.
    """


class DeleteIdentificationServiceAreaResponse(ImplicitDict):
    """Response for a request to delete an Identification Service Area."""

    service_area: IdentificationServiceArea
    """Identification Service Area that was just deleted."""

    subscribers: list[SubscriberToNotify] | None = []
    """DSS subscribers that this client now has the obligation to notify of the Identification Service Area just deleted.  This client must call POST for each provided URL according to the `/uss/identification_service_areas` path API."""


class PutSubscriptionResponse(ImplicitDict):
    """Response for a request to create or update a subscription."""

    service_areas: list[IdentificationServiceArea] | None = []
    """Identification Service Areas in or near the subscription area at the time of creation/update, if `identification_service_area_url` callback was specified."""

    subscription: Subscription
    """Result of the operation on the subscription."""


class GetIdentificationServiceAreaResponse(ImplicitDict):
    """Response to DSS request for the identification service area with the given ID."""

    service_area: IdentificationServiceArea


class GetFlightsResponse(ImplicitDict):
    """Response to remote ID provider query for flight information in an area of interest."""

    timestamp: Time
    """The remote ID service provider's timestamp for when this information was current."""

    flights: list[RIDFlight] | None = []
    """A list of all flights that have been within the requested area within the remote ID retention period.  This includes flights that are not currently within the requested area, but were within the requested area within the remote ID retention period.  Aircraft that are not in flight, and have not been in flight within the retention period, should not be included in this list."""

    no_isas_present: bool | None = False
    """The requested view is entirely outside any remote ID service provision areas (Identification Service Area volumes) this provider has.  A display provider receiving this response should discontinue polling for this endpoint for the view port requested until otherwise directed by DSS interactions."""


class OperationID(str, Enum):
    SearchIdentificationServiceAreas = "searchIdentificationServiceAreas"
    GetIdentificationServiceArea = "getIdentificationServiceArea"
    CreateIdentificationServiceArea = "createIdentificationServiceArea"
    UpdateIdentificationServiceArea = "updateIdentificationServiceArea"
    DeleteIdentificationServiceArea = "deleteIdentificationServiceArea"
    SearchFlights = "searchFlights"
    GetFlightDetails = "getFlightDetails"
    SearchSubscriptions = "searchSubscriptions"
    GetSubscription = "getSubscription"
    CreateSubscription = "createSubscription"
    UpdateSubscription = "updateSubscription"
    DeleteSubscription = "deleteSubscription"
    GetIdentificationServiceAreaDetails = "getIdentificationServiceAreaDetails"
    PostIdentificationServiceArea = "postIdentificationServiceArea"


OPERATIONS: dict[OperationID, Operation] = {
    OperationID.SearchIdentificationServiceAreas: Operation(
        id="searchIdentificationServiceAreas",
        path="/dss/identification_service_areas",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: SearchIdentificationServiceAreasResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetIdentificationServiceArea: Operation(
        id="getIdentificationServiceArea",
        path="/dss/identification_service_areas/{id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.CreateIdentificationServiceArea: Operation(
        id="createIdentificationServiceArea",
        path="/dss/identification_service_areas/{id}",
        verb="PUT",
        request_body_type=CreateIdentificationServiceAreaParameters,
        response_body_type={
            200: PutIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.UpdateIdentificationServiceArea: Operation(
        id="updateIdentificationServiceArea",
        path="/dss/identification_service_areas/{id}/{version}",
        verb="PUT",
        request_body_type=UpdateIdentificationServiceAreaParameters,
        response_body_type={
            200: PutIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.DeleteIdentificationServiceArea: Operation(
        id="deleteIdentificationServiceArea",
        path="/dss/identification_service_areas/{id}/{version}",
        verb="DELETE",
        request_body_type=None,
        response_body_type={
            200: DeleteIdentificationServiceAreaResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
            409: ErrorResponse,
        },
    ),
    OperationID.SearchFlights: Operation(
        id="searchFlights",
        path="/uss/flights",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetFlightsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetFlightDetails: Operation(
        id="getFlightDetails",
        path="/uss/flights/{id}/details",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetFlightDetailsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.SearchSubscriptions: Operation(
        id="searchSubscriptions",
        path="/dss/subscriptions",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: SearchSubscriptionsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            413: ErrorResponse,
        },
    ),
    OperationID.GetSubscription: Operation(
        id="getSubscription",
        path="/dss/subscriptions/{id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.CreateSubscription: Operation(
        id="createSubscription",
        path="/dss/subscriptions/{id}",
        verb="PUT",
        request_body_type=CreateSubscriptionParameters,
        response_body_type={
            200: PutSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            429: ErrorResponse,
        },
    ),
    OperationID.UpdateSubscription: Operation(
        id="updateSubscription",
        path="/dss/subscriptions/{id}/{version}",
        verb="PUT",
        request_body_type=UpdateSubscriptionParameters,
        response_body_type={
            200: PutSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
            429: ErrorResponse,
        },
    ),
    OperationID.DeleteSubscription: Operation(
        id="deleteSubscription",
        path="/dss/subscriptions/{id}/{version}",
        verb="DELETE",
        request_body_type=None,
        response_body_type={
            200: DeleteSubscriptionResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
            409: ErrorResponse,
        },
    ),
    OperationID.GetIdentificationServiceAreaDetails: Operation(
        id="getIdentificationServiceAreaDetails",
        path="/uss/identification_service_areas/{id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GetIdentificationServiceAreaDetailsResponse,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            404: ErrorResponse,
        },
    ),
    OperationID.PostIdentificationServiceArea: Operation(
        id="postIdentificationServiceArea",
        path="/uss/identification_service_areas/{id}",
        verb="POST",
        request_body_type=PutIdentificationServiceAreaNotificationParameters,
        response_body_type={
            204: None,
            400: ErrorResponse,
            401: ErrorResponse,
            403: ErrorResponse,
            409: ErrorResponse,
        },
    ),
}
