"""Data types and operations from Geo-Awareness Automated Test Interfaces 0.2.2 OpenAPI"""

# This file is autogenerated; do not modify manually!

from __future__ import annotations

from enum import Enum

from implicitdict import ImplicitDict, StringBasedDateTime

from uas_standards.utils import Operation

API_VERSION = "0.2.2"
"""Version of Geo-Awareness Automated Test Interfaces OpenAPI specification from which the objects in this package were generated."""

UUIDv4Format = str
"""String whose format matches a version-4 UUID according to RFC 4122."""


class StatusResponseStatus(str, Enum):
    """The status of the USS automated testing interface.
    - `Starting`: the USS is starting and the automated test driver should wait before sending requests.
    - `Ready`: the USS is ready to receive test requests.
    """

    Starting = "Starting"
    Ready = "Ready"


class StatusResponse(ImplicitDict):
    status: StatusResponseStatus
    """The status of the USS automated testing interface.
    - `Starting`: the USS is starting and the automated test driver should wait before sending requests.
    - `Ready`: the USS is ready to receive test requests.
    """


class GeozoneHttpsSourceFormat(str, Enum):
    """The format of the response expected from the source."""

    ED_269 = "ED-269"


class GeozoneHttpsSource(ImplicitDict):
    url: str
    """The URL at which the Geozone data shall be downloaded from."""

    format: GeozoneHttpsSourceFormat | None = GeozoneHttpsSourceFormat.ED_269
    """The format of the response expected from the source."""


class GeozoneSourceResponseResult(str, Enum):
    """The status of the Geozone source and the handling of its data by the USS.
    - `Activating`: the USS is processing the request and is currently activating the Geozone data.
    - `Ready`: the Geozone data has been successfully activated and the USS is ready to receive test requests.
    - `Deactivating`: the Geozone data is being deactivated.
    - `Unsupported`: the USS cannot process the dataset type specified.
    - `Rejected`: the Geozone data was rejected because it is invalid.
    - `Error`: the Geozone data activation or deactivation failed. The message field is required in this case.
    """

    Activating = "Activating"
    Ready = "Ready"
    Deactivating = "Deactivating"
    Unsupported = "Unsupported"
    Rejected = "Rejected"
    Error = "Error"


class GeozoneSourceResponse(ImplicitDict):
    result: GeozoneSourceResponseResult
    """The status of the Geozone source and the handling of its data by the USS.
    - `Activating`: the USS is processing the request and is currently activating the Geozone data.
    - `Ready`: the Geozone data has been successfully activated and the USS is ready to receive test requests.
    - `Deactivating`: the Geozone data is being deactivated.
    - `Unsupported`: the USS cannot process the dataset type specified.
    - `Rejected`: the Geozone data was rejected because it is invalid.
    - `Error`: the Geozone data activation or deactivation failed. The message field is required in this case.
    """

    message: str | None
    """Human-readable explanation of the result for debugging purpose only. This field is required when the result value is `Error`."""


class UomDimensions(str, Enum):
    M = "M"
    FT = "FT"


class VerticalReferenceType(str, Enum):
    AGL = "AGL"
    AMSL = "AMSL"


USpaceClass = str


class Restriction(str, Enum):
    PROHIBITED = "PROHIBITED"
    REQ_AUTHORISATION = "REQ_AUTHORISATION"
    CONDITIONAL = "CONDITIONAL"
    NO_RESTRICTION = "NO_RESTRICTION"


class Position(ImplicitDict):
    uomDimensions: UomDimensions

    verticalReferenceType: VerticalReferenceType

    height: float | None = 0
    """Height above vertical reference datum indicated in `verticalReferenceType`, in units of `uomDimensions`."""

    longitude: float | None = 0
    """Longitude, degrees east of prime meridian."""

    latitude: float | None = 0
    """Latitude, degrees north of the equator."""


class ED269Filters(ImplicitDict):
    """Filter criteria for the selection of Geozones according to ED-269 characteristics."""

    uSpaceClass: USpaceClass | None
    """If specified, only select Geozones which are of the specified `uSpaceClass`."""

    acceptableRestrictions: list[Restriction] | None
    """If specified and non-empty, only select Geozones which are one of the specified restriction types."""


class GeozonesCheckResultGeozone(str, Enum):
    """Indication of whether one or more applicable Geozones were selected according to the selection criteria of the corresponding check.
    * Present: One or more applicable Geozones were selected. * Absent: No applicable Geozones were selected. * UnsupportedFilter: Applicable Geozones could not be selected because one or more filter criteria are not supported by the USSP.  If this value is specified, `message` must be populated. * Error: An error or condition not enumerated above occurred.  If this value is specified, `message` must be populated.
    """

    Present = "Present"
    Absent = "Absent"
    UnsupportedFilter = "UnsupportedFilter"
    Error = "Error"


class GeozonesCheckResult(ImplicitDict):
    geozone: GeozonesCheckResultGeozone
    """Indication of whether one or more applicable Geozones were selected according to the selection criteria of the corresponding check.
    * Present: One or more applicable Geozones were selected. * Absent: No applicable Geozones were selected. * UnsupportedFilter: Applicable Geozones could not be selected because one or more filter criteria are not supported by the USSP.  If this value is specified, `message` must be populated. * Error: An error or condition not enumerated above occurred.  If this value is specified, `message` must be populated.
    """

    message: str | None
    """A human-readable description of why the non-standard `geozone` value was reported.  Should only be populated when appropriate according to the value of the `geozone` field."""


class CreateGeozoneSourceRequest(ImplicitDict):
    https_source: GeozoneHttpsSource | None


class GeozonesFilterSet(ImplicitDict):
    """Set of filters to select only a subset of Geozones.  Only Geozones which are applicable to all specified filters within this filter set should be selected."""

    position: Position | None
    """If specified, only select Geozones encompassing this position."""

    after: StringBasedDateTime | None
    """If specified, only select Geozones which encompass at least some times at or after this time."""

    before: StringBasedDateTime | None
    """If specified, only select Geozones which encompass at least some times at or before this time."""

    ed269: ED269Filters | None


class GeozonesCheckReply(ImplicitDict):
    applicableGeozone: list[GeozonesCheckResult] | None = []
    """Responses to each of the `checks` in the request.  The number of entries in this array should match the number of entries in the `checks` field of the request."""


class GeozonesCheck(ImplicitDict):
    filterSets: list[GeozonesFilterSet]
    """Select Geozones which match any of the specified filter sets."""


class GeozonesCheckRequest(ImplicitDict):
    checks: list[GeozonesCheck]


class OperationID(str, Enum):
    GetStatus = "GetStatus"
    PutGeozoneSource = "PutGeozoneSource"
    GetGeozoneSourceStatus = "GetGeozoneSourceStatus"
    DeleteGeozoneSource = "DeleteGeozoneSource"
    CheckGeozones = "CheckGeozones"


OPERATIONS: dict[OperationID, Operation] = {
    OperationID.GetStatus: Operation(
        id="GetStatus",
        path="/status",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: StatusResponse,
            401: None,
            403: None,
            404: None,
        },
    ),
    OperationID.PutGeozoneSource: Operation(
        id="PutGeozoneSource",
        path="/geozone_sources/{geozone_source_id}",
        verb="PUT",
        request_body_type=CreateGeozoneSourceRequest,
        response_body_type={
            200: GeozoneSourceResponse,
            401: None,
            403: None,
        },
    ),
    OperationID.GetGeozoneSourceStatus: Operation(
        id="GetGeozoneSourceStatus",
        path="/geozone_sources/{geozone_source_id}",
        verb="GET",
        request_body_type=None,
        response_body_type={
            200: GeozoneSourceResponse,
            401: None,
            403: None,
            404: None,
        },
    ),
    OperationID.DeleteGeozoneSource: Operation(
        id="DeleteGeozoneSource",
        path="/geozone_sources/{geozone_source_id}",
        verb="DELETE",
        request_body_type=None,
        response_body_type={
            200: GeozoneSourceResponse,
            401: None,
            403: None,
        },
    ),
    OperationID.CheckGeozones: Operation(
        id="CheckGeozones",
        path="/geozones/check",
        verb="POST",
        request_body_type=GeozonesCheckRequest,
        response_body_type={
            200: GeozonesCheckReply,
            401: None,
            403: None,
        },
    ),
}
