# API Reference

Quick reference for InjectQ's essential API.

## Quick Start

See the **[Quick Reference Guide](quick-reference.md)** for common API patterns and code examples.

## Main Topics Covered

- Container creation and configuration
- Binding services (dict interface and bind methods)
- Decorators (@inject, @singleton, @transient, @scoped, @resource)
- Module system and providers
- Testing utilities (test_container, override_dependency)
- Exception handling
- Scope management
- Type-safe injection

## For Detailed Implementation

For implementation details beyond the quick reference, refer to:

- [Injection Patterns](../injection-patterns/) - Different ways to inject dependencies
- [Scopes](../scopes/) - Service lifetime management
- [Modules](../modules/) - Organizing dependencies
- [Testing](../testing/) - Testing your dependency-injected code
