# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportConfigurationResponseDetails(object):
    """
    Array of configuration items with its dependencies to export.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportConfigurationResponseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param configuration_items:
            The value to assign to the configuration_items property of this ExportConfigurationResponseDetails.
        :type configuration_items: list[oci.apm_config.models.ExportImportConfigSummary]

        """
        self.swagger_types = {
            'configuration_items': 'list[ExportImportConfigSummary]'
        }
        self.attribute_map = {
            'configuration_items': 'configurationItems'
        }
        self._configuration_items = None

    @property
    def configuration_items(self):
        """
        **[Required]** Gets the configuration_items of this ExportConfigurationResponseDetails.
        A list of Configurations Details .


        :return: The configuration_items of this ExportConfigurationResponseDetails.
        :rtype: list[oci.apm_config.models.ExportImportConfigSummary]
        """
        return self._configuration_items

    @configuration_items.setter
    def configuration_items(self, configuration_items):
        """
        Sets the configuration_items of this ExportConfigurationResponseDetails.
        A list of Configurations Details .


        :param configuration_items: The configuration_items of this ExportConfigurationResponseDetails.
        :type: list[oci.apm_config.models.ExportImportConfigSummary]
        """
        self._configuration_items = configuration_items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
