# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceNetworkInterfaceAttachment(object):
    """
    Describes a network interface attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceNetworkInterfaceAttachment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attachment_key:
            The value to assign to the attachment_key property of this InstanceNetworkInterfaceAttachment.
        :type attachment_key: str

        :param time_attach:
            The value to assign to the time_attach property of this InstanceNetworkInterfaceAttachment.
        :type time_attach: datetime

        :param is_delete_on_termination:
            The value to assign to the is_delete_on_termination property of this InstanceNetworkInterfaceAttachment.
        :type is_delete_on_termination: bool

        :param device_index:
            The value to assign to the device_index property of this InstanceNetworkInterfaceAttachment.
        :type device_index: int

        :param network_card_index:
            The value to assign to the network_card_index property of this InstanceNetworkInterfaceAttachment.
        :type network_card_index: int

        :param status:
            The value to assign to the status property of this InstanceNetworkInterfaceAttachment.
        :type status: str

        """
        self.swagger_types = {
            'attachment_key': 'str',
            'time_attach': 'datetime',
            'is_delete_on_termination': 'bool',
            'device_index': 'int',
            'network_card_index': 'int',
            'status': 'str'
        }
        self.attribute_map = {
            'attachment_key': 'attachmentKey',
            'time_attach': 'timeAttach',
            'is_delete_on_termination': 'isDeleteOnTermination',
            'device_index': 'deviceIndex',
            'network_card_index': 'networkCardIndex',
            'status': 'status'
        }
        self._attachment_key = None
        self._time_attach = None
        self._is_delete_on_termination = None
        self._device_index = None
        self._network_card_index = None
        self._status = None

    @property
    def attachment_key(self):
        """
        Gets the attachment_key of this InstanceNetworkInterfaceAttachment.
        The ID of the network interface attachment.


        :return: The attachment_key of this InstanceNetworkInterfaceAttachment.
        :rtype: str
        """
        return self._attachment_key

    @attachment_key.setter
    def attachment_key(self, attachment_key):
        """
        Sets the attachment_key of this InstanceNetworkInterfaceAttachment.
        The ID of the network interface attachment.


        :param attachment_key: The attachment_key of this InstanceNetworkInterfaceAttachment.
        :type: str
        """
        self._attachment_key = attachment_key

    @property
    def time_attach(self):
        """
        Gets the time_attach of this InstanceNetworkInterfaceAttachment.
        The timestamp when the attachment initiated.


        :return: The time_attach of this InstanceNetworkInterfaceAttachment.
        :rtype: datetime
        """
        return self._time_attach

    @time_attach.setter
    def time_attach(self, time_attach):
        """
        Sets the time_attach of this InstanceNetworkInterfaceAttachment.
        The timestamp when the attachment initiated.


        :param time_attach: The time_attach of this InstanceNetworkInterfaceAttachment.
        :type: datetime
        """
        self._time_attach = time_attach

    @property
    def is_delete_on_termination(self):
        """
        Gets the is_delete_on_termination of this InstanceNetworkInterfaceAttachment.
        Indicates whether the network interface is deleted when the instance is terminated.


        :return: The is_delete_on_termination of this InstanceNetworkInterfaceAttachment.
        :rtype: bool
        """
        return self._is_delete_on_termination

    @is_delete_on_termination.setter
    def is_delete_on_termination(self, is_delete_on_termination):
        """
        Sets the is_delete_on_termination of this InstanceNetworkInterfaceAttachment.
        Indicates whether the network interface is deleted when the instance is terminated.


        :param is_delete_on_termination: The is_delete_on_termination of this InstanceNetworkInterfaceAttachment.
        :type: bool
        """
        self._is_delete_on_termination = is_delete_on_termination

    @property
    def device_index(self):
        """
        Gets the device_index of this InstanceNetworkInterfaceAttachment.
        The index of the device on the instance for the network interface attachment.


        :return: The device_index of this InstanceNetworkInterfaceAttachment.
        :rtype: int
        """
        return self._device_index

    @device_index.setter
    def device_index(self, device_index):
        """
        Sets the device_index of this InstanceNetworkInterfaceAttachment.
        The index of the device on the instance for the network interface attachment.


        :param device_index: The device_index of this InstanceNetworkInterfaceAttachment.
        :type: int
        """
        self._device_index = device_index

    @property
    def network_card_index(self):
        """
        Gets the network_card_index of this InstanceNetworkInterfaceAttachment.
        The index of the network card.


        :return: The network_card_index of this InstanceNetworkInterfaceAttachment.
        :rtype: int
        """
        return self._network_card_index

    @network_card_index.setter
    def network_card_index(self, network_card_index):
        """
        Sets the network_card_index of this InstanceNetworkInterfaceAttachment.
        The index of the network card.


        :param network_card_index: The network_card_index of this InstanceNetworkInterfaceAttachment.
        :type: int
        """
        self._network_card_index = network_card_index

    @property
    def status(self):
        """
        Gets the status of this InstanceNetworkInterfaceAttachment.
        The attachment state.


        :return: The status of this InstanceNetworkInterfaceAttachment.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this InstanceNetworkInterfaceAttachment.
        The attachment state.


        :param status: The status of this InstanceNetworkInterfaceAttachment.
        :type: str
        """
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
