# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceMaintenanceEvent(object):
    """
    It is the event in which the maintenance action will be be performed on the customer instance on the scheduled date and time.
    """

    #: A constant which can be used with the maintenance_category property of a InstanceMaintenanceEvent.
    #: This constant has a value of "EMERGENCY"
    MAINTENANCE_CATEGORY_EMERGENCY = "EMERGENCY"

    #: A constant which can be used with the maintenance_category property of a InstanceMaintenanceEvent.
    #: This constant has a value of "MANDATORY"
    MAINTENANCE_CATEGORY_MANDATORY = "MANDATORY"

    #: A constant which can be used with the maintenance_category property of a InstanceMaintenanceEvent.
    #: This constant has a value of "FLEXIBLE"
    MAINTENANCE_CATEGORY_FLEXIBLE = "FLEXIBLE"

    #: A constant which can be used with the maintenance_category property of a InstanceMaintenanceEvent.
    #: This constant has a value of "OPTIONAL"
    MAINTENANCE_CATEGORY_OPTIONAL = "OPTIONAL"

    #: A constant which can be used with the maintenance_category property of a InstanceMaintenanceEvent.
    #: This constant has a value of "NOTIFICATION"
    MAINTENANCE_CATEGORY_NOTIFICATION = "NOTIFICATION"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "EVACUATION"
    MAINTENANCE_REASON_EVACUATION = "EVACUATION"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "ENVIRONMENTAL_FACTORS"
    MAINTENANCE_REASON_ENVIRONMENTAL_FACTORS = "ENVIRONMENTAL_FACTORS"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "DECOMMISSION"
    MAINTENANCE_REASON_DECOMMISSION = "DECOMMISSION"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "HARDWARE_REPLACEMENT"
    MAINTENANCE_REASON_HARDWARE_REPLACEMENT = "HARDWARE_REPLACEMENT"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "FIRMWARE_UPDATE"
    MAINTENANCE_REASON_FIRMWARE_UPDATE = "FIRMWARE_UPDATE"

    #: A constant which can be used with the maintenance_reason property of a InstanceMaintenanceEvent.
    #: This constant has a value of "SECURITY_UPDATE"
    MAINTENANCE_REASON_SECURITY_UPDATE = "SECURITY_UPDATE"

    #: A constant which can be used with the instance_action property of a InstanceMaintenanceEvent.
    #: This constant has a value of "REBOOT_MIGRATION"
    INSTANCE_ACTION_REBOOT_MIGRATION = "REBOOT_MIGRATION"

    #: A constant which can be used with the instance_action property of a InstanceMaintenanceEvent.
    #: This constant has a value of "TERMINATE"
    INSTANCE_ACTION_TERMINATE = "TERMINATE"

    #: A constant which can be used with the instance_action property of a InstanceMaintenanceEvent.
    #: This constant has a value of "STOP"
    INSTANCE_ACTION_STOP = "STOP"

    #: A constant which can be used with the instance_action property of a InstanceMaintenanceEvent.
    #: This constant has a value of "NONE"
    INSTANCE_ACTION_NONE = "NONE"

    #: A constant which can be used with the alternative_resolution_actions property of a InstanceMaintenanceEvent.
    #: This constant has a value of "REBOOT_MIGRATION"
    ALTERNATIVE_RESOLUTION_ACTIONS_REBOOT_MIGRATION = "REBOOT_MIGRATION"

    #: A constant which can be used with the alternative_resolution_actions property of a InstanceMaintenanceEvent.
    #: This constant has a value of "TERMINATE"
    ALTERNATIVE_RESOLUTION_ACTIONS_TERMINATE = "TERMINATE"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "SCHEDULED"
    LIFECYCLE_STATE_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "STARTED"
    LIFECYCLE_STATE_STARTED = "STARTED"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "PROCESSING"
    LIFECYCLE_STATE_PROCESSING = "PROCESSING"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a InstanceMaintenanceEvent.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    #: A constant which can be used with the created_by property of a InstanceMaintenanceEvent.
    #: This constant has a value of "CUSTOMER"
    CREATED_BY_CUSTOMER = "CUSTOMER"

    #: A constant which can be used with the created_by property of a InstanceMaintenanceEvent.
    #: This constant has a value of "SYSTEM"
    CREATED_BY_SYSTEM = "SYSTEM"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceMaintenanceEvent object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this InstanceMaintenanceEvent.
        :type display_name: str

        :param defined_tags:
            The value to assign to the defined_tags property of this InstanceMaintenanceEvent.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this InstanceMaintenanceEvent.
        :type freeform_tags: dict(str, str)

        :param id:
            The value to assign to the id property of this InstanceMaintenanceEvent.
        :type id: str

        :param instance_id:
            The value to assign to the instance_id property of this InstanceMaintenanceEvent.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InstanceMaintenanceEvent.
        :type compartment_id: str

        :param maintenance_category:
            The value to assign to the maintenance_category property of this InstanceMaintenanceEvent.
            Allowed values for this property are: "EMERGENCY", "MANDATORY", "FLEXIBLE", "OPTIONAL", "NOTIFICATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_category: str

        :param maintenance_reason:
            The value to assign to the maintenance_reason property of this InstanceMaintenanceEvent.
            Allowed values for this property are: "EVACUATION", "ENVIRONMENTAL_FACTORS", "DECOMMISSION", "HARDWARE_REPLACEMENT", "FIRMWARE_UPDATE", "SECURITY_UPDATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type maintenance_reason: str

        :param instance_action:
            The value to assign to the instance_action property of this InstanceMaintenanceEvent.
            Allowed values for this property are: "REBOOT_MIGRATION", "TERMINATE", "STOP", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type instance_action: str

        :param alternative_resolution_actions:
            The value to assign to the alternative_resolution_actions property of this InstanceMaintenanceEvent.
            Allowed values for items in this list are: "REBOOT_MIGRATION", "TERMINATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type alternative_resolution_actions: list[str]

        :param time_started:
            The value to assign to the time_started property of this InstanceMaintenanceEvent.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this InstanceMaintenanceEvent.
        :type time_finished: datetime

        :param time_window_start:
            The value to assign to the time_window_start property of this InstanceMaintenanceEvent.
        :type time_window_start: datetime

        :param start_window_duration:
            The value to assign to the start_window_duration property of this InstanceMaintenanceEvent.
        :type start_window_duration: str

        :param estimated_duration:
            The value to assign to the estimated_duration property of this InstanceMaintenanceEvent.
        :type estimated_duration: str

        :param time_hard_due_date:
            The value to assign to the time_hard_due_date property of this InstanceMaintenanceEvent.
        :type time_hard_due_date: datetime

        :param can_reschedule:
            The value to assign to the can_reschedule property of this InstanceMaintenanceEvent.
        :type can_reschedule: bool

        :param time_created:
            The value to assign to the time_created property of this InstanceMaintenanceEvent.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this InstanceMaintenanceEvent.
            Allowed values for this property are: "SCHEDULED", "STARTED", "PROCESSING", "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this InstanceMaintenanceEvent.
        :type lifecycle_details: str

        :param created_by:
            The value to assign to the created_by property of this InstanceMaintenanceEvent.
            Allowed values for this property are: "CUSTOMER", "SYSTEM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type created_by: str

        :param description:
            The value to assign to the description property of this InstanceMaintenanceEvent.
        :type description: str

        :param correlation_token:
            The value to assign to the correlation_token property of this InstanceMaintenanceEvent.
        :type correlation_token: str

        :param can_delete_local_storage:
            The value to assign to the can_delete_local_storage property of this InstanceMaintenanceEvent.
        :type can_delete_local_storage: bool

        :param additional_details:
            The value to assign to the additional_details property of this InstanceMaintenanceEvent.
        :type additional_details: dict(str, str)

        """
        self.swagger_types = {
            'display_name': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'id': 'str',
            'instance_id': 'str',
            'compartment_id': 'str',
            'maintenance_category': 'str',
            'maintenance_reason': 'str',
            'instance_action': 'str',
            'alternative_resolution_actions': 'list[str]',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'time_window_start': 'datetime',
            'start_window_duration': 'str',
            'estimated_duration': 'str',
            'time_hard_due_date': 'datetime',
            'can_reschedule': 'bool',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'created_by': 'str',
            'description': 'str',
            'correlation_token': 'str',
            'can_delete_local_storage': 'bool',
            'additional_details': 'dict(str, str)'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'id': 'id',
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'maintenance_category': 'maintenanceCategory',
            'maintenance_reason': 'maintenanceReason',
            'instance_action': 'instanceAction',
            'alternative_resolution_actions': 'alternativeResolutionActions',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'time_window_start': 'timeWindowStart',
            'start_window_duration': 'startWindowDuration',
            'estimated_duration': 'estimatedDuration',
            'time_hard_due_date': 'timeHardDueDate',
            'can_reschedule': 'canReschedule',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'created_by': 'createdBy',
            'description': 'description',
            'correlation_token': 'correlationToken',
            'can_delete_local_storage': 'canDeleteLocalStorage',
            'additional_details': 'additionalDetails'
        }
        self._display_name = None
        self._defined_tags = None
        self._freeform_tags = None
        self._id = None
        self._instance_id = None
        self._compartment_id = None
        self._maintenance_category = None
        self._maintenance_reason = None
        self._instance_action = None
        self._alternative_resolution_actions = None
        self._time_started = None
        self._time_finished = None
        self._time_window_start = None
        self._start_window_duration = None
        self._estimated_duration = None
        self._time_hard_due_date = None
        self._can_reschedule = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._created_by = None
        self._description = None
        self._correlation_token = None
        self._can_delete_local_storage = None
        self._additional_details = None

    @property
    def display_name(self):
        """
        Gets the display_name of this InstanceMaintenanceEvent.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this InstanceMaintenanceEvent.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this InstanceMaintenanceEvent.
        :type: str
        """
        self._display_name = display_name

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this InstanceMaintenanceEvent.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this InstanceMaintenanceEvent.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this InstanceMaintenanceEvent.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this InstanceMaintenanceEvent.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this InstanceMaintenanceEvent.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this InstanceMaintenanceEvent.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this InstanceMaintenanceEvent.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this InstanceMaintenanceEvent.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InstanceMaintenanceEvent.
        The `OCID`__ of the maintenance event.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InstanceMaintenanceEvent.
        The `OCID`__ of the maintenance event.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this InstanceMaintenanceEvent.
        :type: str
        """
        self._id = id

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this InstanceMaintenanceEvent.
        The OCID of the instance.


        :return: The instance_id of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this InstanceMaintenanceEvent.
        The OCID of the instance.


        :param instance_id: The instance_id of this InstanceMaintenanceEvent.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InstanceMaintenanceEvent.
        The OCID of the compartment that contains the instance.


        :return: The compartment_id of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstanceMaintenanceEvent.
        The OCID of the compartment that contains the instance.


        :param compartment_id: The compartment_id of this InstanceMaintenanceEvent.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def maintenance_category(self):
        """
        **[Required]** Gets the maintenance_category of this InstanceMaintenanceEvent.
        This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have
        tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled,
        deferred, or even cancelled. Please see the
        `Instance Maintenance`__ documentation for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm

        Allowed values for this property are: "EMERGENCY", "MANDATORY", "FLEXIBLE", "OPTIONAL", "NOTIFICATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_category of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_category

    @maintenance_category.setter
    def maintenance_category(self, maintenance_category):
        """
        Sets the maintenance_category of this InstanceMaintenanceEvent.
        This indicates the priority and allowed actions for this Maintenance. Higher priority forms of Maintenance have
        tighter restrictions and may not be rescheduled, while lower priority/severity Maintenance can be rescheduled,
        deferred, or even cancelled. Please see the
        `Instance Maintenance`__ documentation for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm


        :param maintenance_category: The maintenance_category of this InstanceMaintenanceEvent.
        :type: str
        """
        allowed_values = ["EMERGENCY", "MANDATORY", "FLEXIBLE", "OPTIONAL", "NOTIFICATION"]
        if not value_allowed_none_or_none_sentinel(maintenance_category, allowed_values):
            maintenance_category = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_category = maintenance_category

    @property
    def maintenance_reason(self):
        """
        **[Required]** Gets the maintenance_reason of this InstanceMaintenanceEvent.
        This is the reason that Maintenance is being performed. See
        `Instance Maintenance`__ documentation for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm

        Allowed values for this property are: "EVACUATION", "ENVIRONMENTAL_FACTORS", "DECOMMISSION", "HARDWARE_REPLACEMENT", "FIRMWARE_UPDATE", "SECURITY_UPDATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The maintenance_reason of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._maintenance_reason

    @maintenance_reason.setter
    def maintenance_reason(self, maintenance_reason):
        """
        Sets the maintenance_reason of this InstanceMaintenanceEvent.
        This is the reason that Maintenance is being performed. See
        `Instance Maintenance`__ documentation for details.

        __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/placeholder.htm


        :param maintenance_reason: The maintenance_reason of this InstanceMaintenanceEvent.
        :type: str
        """
        allowed_values = ["EVACUATION", "ENVIRONMENTAL_FACTORS", "DECOMMISSION", "HARDWARE_REPLACEMENT", "FIRMWARE_UPDATE", "SECURITY_UPDATE"]
        if not value_allowed_none_or_none_sentinel(maintenance_reason, allowed_values):
            maintenance_reason = 'UNKNOWN_ENUM_VALUE'
        self._maintenance_reason = maintenance_reason

    @property
    def instance_action(self):
        """
        **[Required]** Gets the instance_action of this InstanceMaintenanceEvent.
        This is the action that will be performed on the Instance by OCI when the Maintenance begins.

        Allowed values for this property are: "REBOOT_MIGRATION", "TERMINATE", "STOP", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The instance_action of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._instance_action

    @instance_action.setter
    def instance_action(self, instance_action):
        """
        Sets the instance_action of this InstanceMaintenanceEvent.
        This is the action that will be performed on the Instance by OCI when the Maintenance begins.


        :param instance_action: The instance_action of this InstanceMaintenanceEvent.
        :type: str
        """
        allowed_values = ["REBOOT_MIGRATION", "TERMINATE", "STOP", "NONE"]
        if not value_allowed_none_or_none_sentinel(instance_action, allowed_values):
            instance_action = 'UNKNOWN_ENUM_VALUE'
        self._instance_action = instance_action

    @property
    def alternative_resolution_actions(self):
        """
        **[Required]** Gets the alternative_resolution_actions of this InstanceMaintenanceEvent.
        These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.

        Allowed values for items in this list are: "REBOOT_MIGRATION", "TERMINATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The alternative_resolution_actions of this InstanceMaintenanceEvent.
        :rtype: list[str]
        """
        return self._alternative_resolution_actions

    @alternative_resolution_actions.setter
    def alternative_resolution_actions(self, alternative_resolution_actions):
        """
        Sets the alternative_resolution_actions of this InstanceMaintenanceEvent.
        These are alternative actions to the requested instanceAction that can be taken to resolve the Maintenance.


        :param alternative_resolution_actions: The alternative_resolution_actions of this InstanceMaintenanceEvent.
        :type: list[str]
        """
        allowed_values = ["REBOOT_MIGRATION", "TERMINATE"]
        if alternative_resolution_actions:
            alternative_resolution_actions[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in alternative_resolution_actions]
        self._alternative_resolution_actions = alternative_resolution_actions

    @property
    def time_started(self):
        """
        Gets the time_started of this InstanceMaintenanceEvent.
        The time at which the Maintenance actually started.


        :return: The time_started of this InstanceMaintenanceEvent.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this InstanceMaintenanceEvent.
        The time at which the Maintenance actually started.


        :param time_started: The time_started of this InstanceMaintenanceEvent.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this InstanceMaintenanceEvent.
        The time at which the Maintenance actually finished.


        :return: The time_finished of this InstanceMaintenanceEvent.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this InstanceMaintenanceEvent.
        The time at which the Maintenance actually finished.


        :param time_finished: The time_finished of this InstanceMaintenanceEvent.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def time_window_start(self):
        """
        **[Required]** Gets the time_window_start of this InstanceMaintenanceEvent.
        The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before
        this time.


        :return: The time_window_start of this InstanceMaintenanceEvent.
        :rtype: datetime
        """
        return self._time_window_start

    @time_window_start.setter
    def time_window_start(self, time_window_start):
        """
        Sets the time_window_start of this InstanceMaintenanceEvent.
        The beginning of the time window when Maintenance is scheduled to begin. The Maintenance will not begin before
        this time.


        :param time_window_start: The time_window_start of this InstanceMaintenanceEvent.
        :type: datetime
        """
        self._time_window_start = time_window_start

    @property
    def start_window_duration(self):
        """
        Gets the start_window_duration of this InstanceMaintenanceEvent.
        The duration of the time window Maintenance is scheduled to begin within.


        :return: The start_window_duration of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._start_window_duration

    @start_window_duration.setter
    def start_window_duration(self, start_window_duration):
        """
        Sets the start_window_duration of this InstanceMaintenanceEvent.
        The duration of the time window Maintenance is scheduled to begin within.


        :param start_window_duration: The start_window_duration of this InstanceMaintenanceEvent.
        :type: str
        """
        self._start_window_duration = start_window_duration

    @property
    def estimated_duration(self):
        """
        Gets the estimated_duration of this InstanceMaintenanceEvent.
        This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.


        :return: The estimated_duration of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._estimated_duration

    @estimated_duration.setter
    def estimated_duration(self, estimated_duration):
        """
        Sets the estimated_duration of this InstanceMaintenanceEvent.
        This is the estimated duration of the Maintenance, once the Maintenance has entered the STARTED state.


        :param estimated_duration: The estimated_duration of this InstanceMaintenanceEvent.
        :type: str
        """
        self._estimated_duration = estimated_duration

    @property
    def time_hard_due_date(self):
        """
        Gets the time_hard_due_date of this InstanceMaintenanceEvent.
        It is the scheduled hard due date and time of the maintenance event.
        The maintenance event will happen at this time and the due date will not be extended.


        :return: The time_hard_due_date of this InstanceMaintenanceEvent.
        :rtype: datetime
        """
        return self._time_hard_due_date

    @time_hard_due_date.setter
    def time_hard_due_date(self, time_hard_due_date):
        """
        Sets the time_hard_due_date of this InstanceMaintenanceEvent.
        It is the scheduled hard due date and time of the maintenance event.
        The maintenance event will happen at this time and the due date will not be extended.


        :param time_hard_due_date: The time_hard_due_date of this InstanceMaintenanceEvent.
        :type: datetime
        """
        self._time_hard_due_date = time_hard_due_date

    @property
    def can_reschedule(self):
        """
        **[Required]** Gets the can_reschedule of this InstanceMaintenanceEvent.
        Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.


        :return: The can_reschedule of this InstanceMaintenanceEvent.
        :rtype: bool
        """
        return self._can_reschedule

    @can_reschedule.setter
    def can_reschedule(self, can_reschedule):
        """
        Sets the can_reschedule of this InstanceMaintenanceEvent.
        Indicates if this MaintenanceEvent is capable of being rescheduled up to the timeHardDueDate.


        :param can_reschedule: The can_reschedule of this InstanceMaintenanceEvent.
        :type: bool
        """
        self._can_reschedule = can_reschedule

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this InstanceMaintenanceEvent.
        The date and time the maintenance event was created, in the format defined by `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this InstanceMaintenanceEvent.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this InstanceMaintenanceEvent.
        The date and time the maintenance event was created, in the format defined by `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this InstanceMaintenanceEvent.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this InstanceMaintenanceEvent.
        The current state of the maintenance event.

        Allowed values for this property are: "SCHEDULED", "STARTED", "PROCESSING", "SUCCEEDED", "FAILED", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this InstanceMaintenanceEvent.
        The current state of the maintenance event.


        :param lifecycle_state: The lifecycle_state of this InstanceMaintenanceEvent.
        :type: str
        """
        allowed_values = ["SCHEDULED", "STARTED", "PROCESSING", "SUCCEEDED", "FAILED", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this InstanceMaintenanceEvent.
        Provides more details about the state of the maintenance event.


        :return: The lifecycle_details of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this InstanceMaintenanceEvent.
        Provides more details about the state of the maintenance event.


        :param lifecycle_details: The lifecycle_details of this InstanceMaintenanceEvent.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this InstanceMaintenanceEvent.
        The creator of the maintenance event.

        Allowed values for this property are: "CUSTOMER", "SYSTEM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The created_by of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this InstanceMaintenanceEvent.
        The creator of the maintenance event.


        :param created_by: The created_by of this InstanceMaintenanceEvent.
        :type: str
        """
        allowed_values = ["CUSTOMER", "SYSTEM"]
        if not value_allowed_none_or_none_sentinel(created_by, allowed_values):
            created_by = 'UNKNOWN_ENUM_VALUE'
        self._created_by = created_by

    @property
    def description(self):
        """
        Gets the description of this InstanceMaintenanceEvent.
        It is the descriptive information about the maintenance taking place on the customer instance.


        :return: The description of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InstanceMaintenanceEvent.
        It is the descriptive information about the maintenance taking place on the customer instance.


        :param description: The description of this InstanceMaintenanceEvent.
        :type: str
        """
        self._description = description

    @property
    def correlation_token(self):
        """
        Gets the correlation_token of this InstanceMaintenanceEvent.
        A unique identifier that will group Instances that have a relationship with one another and must be scheduled
        together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance
        perspective will have a matching correlationToken.


        :return: The correlation_token of this InstanceMaintenanceEvent.
        :rtype: str
        """
        return self._correlation_token

    @correlation_token.setter
    def correlation_token(self, correlation_token):
        """
        Sets the correlation_token of this InstanceMaintenanceEvent.
        A unique identifier that will group Instances that have a relationship with one another and must be scheduled
        together for the Maintenance to proceed. Any Instances that have a relationship with one another from a Maintenance
        perspective will have a matching correlationToken.


        :param correlation_token: The correlation_token of this InstanceMaintenanceEvent.
        :type: str
        """
        self._correlation_token = correlation_token

    @property
    def can_delete_local_storage(self):
        """
        Gets the can_delete_local_storage of this InstanceMaintenanceEvent.
        For Instances that have local storage, this field is set to true when local storage
        will be deleted as a result of the Maintenance.


        :return: The can_delete_local_storage of this InstanceMaintenanceEvent.
        :rtype: bool
        """
        return self._can_delete_local_storage

    @can_delete_local_storage.setter
    def can_delete_local_storage(self, can_delete_local_storage):
        """
        Sets the can_delete_local_storage of this InstanceMaintenanceEvent.
        For Instances that have local storage, this field is set to true when local storage
        will be deleted as a result of the Maintenance.


        :param can_delete_local_storage: The can_delete_local_storage of this InstanceMaintenanceEvent.
        :type: bool
        """
        self._can_delete_local_storage = can_delete_local_storage

    @property
    def additional_details(self):
        """
        Gets the additional_details of this InstanceMaintenanceEvent.
        Additional details of the maintenance in the form of json.


        :return: The additional_details of this InstanceMaintenanceEvent.
        :rtype: dict(str, str)
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this InstanceMaintenanceEvent.
        Additional details of the maintenance in the form of json.


        :param additional_details: The additional_details of this InstanceMaintenanceEvent.
        :type: dict(str, str)
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
