# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .update_instance_platform_config import UpdateInstancePlatformConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IntelVmUpdateInstancePlatformConfig(UpdateInstancePlatformConfig):
    """
    The platform configuration used when updating a virtual machine instance with the Intel platform.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IntelVmUpdateInstancePlatformConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.core.models.IntelVmUpdateInstancePlatformConfig.type` attribute
        of this class is ``INTEL_VM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IntelVmUpdateInstancePlatformConfig.
            Allowed values for this property are: "AMD_VM", "INTEL_VM"
        :type type: str

        :param is_symmetric_multi_threading_enabled:
            The value to assign to the is_symmetric_multi_threading_enabled property of this IntelVmUpdateInstancePlatformConfig.
        :type is_symmetric_multi_threading_enabled: bool

        """
        self.swagger_types = {
            'type': 'str',
            'is_symmetric_multi_threading_enabled': 'bool'
        }
        self.attribute_map = {
            'type': 'type',
            'is_symmetric_multi_threading_enabled': 'isSymmetricMultiThreadingEnabled'
        }
        self._type = None
        self._is_symmetric_multi_threading_enabled = None
        self._type = 'INTEL_VM'

    @property
    def is_symmetric_multi_threading_enabled(self):
        """
        Gets the is_symmetric_multi_threading_enabled of this IntelVmUpdateInstancePlatformConfig.
        Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is also
        called simultaneous multithreading (SMT) or Intel Hyper-Threading.

        Intel and AMD processors have two hardware execution threads per core (OCPU). SMT permits multiple
        independent threads of execution, to better use the resources and increase the efficiency
        of the CPU. When multithreading is disabled, only one thread is permitted to run on each core, which
        can provide higher or more predictable performance for some workloads.


        :return: The is_symmetric_multi_threading_enabled of this IntelVmUpdateInstancePlatformConfig.
        :rtype: bool
        """
        return self._is_symmetric_multi_threading_enabled

    @is_symmetric_multi_threading_enabled.setter
    def is_symmetric_multi_threading_enabled(self, is_symmetric_multi_threading_enabled):
        """
        Sets the is_symmetric_multi_threading_enabled of this IntelVmUpdateInstancePlatformConfig.
        Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is also
        called simultaneous multithreading (SMT) or Intel Hyper-Threading.

        Intel and AMD processors have two hardware execution threads per core (OCPU). SMT permits multiple
        independent threads of execution, to better use the resources and increase the efficiency
        of the CPU. When multithreading is disabled, only one thread is permitted to run on each core, which
        can provide higher or more predictable performance for some workloads.


        :param is_symmetric_multi_threading_enabled: The is_symmetric_multi_threading_enabled of this IntelVmUpdateInstancePlatformConfig.
        :type: bool
        """
        self._is_symmetric_multi_threading_enabled = is_symmetric_multi_threading_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
