# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IpInventorySubnetResourceSummary(object):
    """
    Provides the IP Inventory details of a subnet and its associated resources.
    """

    #: A constant which can be used with the ip_address_lifetime property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "Ephemeral"
    IP_ADDRESS_LIFETIME_EPHEMERAL = "Ephemeral"

    #: A constant which can be used with the ip_address_lifetime property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "Reserved"
    IP_ADDRESS_LIFETIME_RESERVED = "Reserved"

    #: A constant which can be used with the public_ip_lifetime property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "Ephemeral"
    PUBLIC_IP_LIFETIME_EPHEMERAL = "Ephemeral"

    #: A constant which can be used with the public_ip_lifetime property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "Reserved"
    PUBLIC_IP_LIFETIME_RESERVED = "Reserved"

    #: A constant which can be used with the associated_public_ip_pool property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "ORACLE"
    ASSOCIATED_PUBLIC_IP_POOL_ORACLE = "ORACLE"

    #: A constant which can be used with the associated_public_ip_pool property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "BYOIP"
    ASSOCIATED_PUBLIC_IP_POOL_BYOIP = "BYOIP"

    #: A constant which can be used with the assigned_resource_type property of a IpInventorySubnetResourceSummary.
    #: This constant has a value of "Resource"
    ASSIGNED_RESOURCE_TYPE_RESOURCE = "Resource"

    def __init__(self, **kwargs):
        """
        Initializes a new IpInventorySubnetResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ip_id:
            The value to assign to the ip_id property of this IpInventorySubnetResourceSummary.
        :type ip_id: str

        :param ip_address:
            The value to assign to the ip_address property of this IpInventorySubnetResourceSummary.
        :type ip_address: str

        :param ip_address_lifetime:
            The value to assign to the ip_address_lifetime property of this IpInventorySubnetResourceSummary.
            Allowed values for this property are: "Ephemeral", "Reserved", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type ip_address_lifetime: str

        :param parent_cidr:
            The value to assign to the parent_cidr property of this IpInventorySubnetResourceSummary.
        :type parent_cidr: str

        :param associated_public_ip:
            The value to assign to the associated_public_ip property of this IpInventorySubnetResourceSummary.
        :type associated_public_ip: str

        :param public_ip_lifetime:
            The value to assign to the public_ip_lifetime property of this IpInventorySubnetResourceSummary.
            Allowed values for this property are: "Ephemeral", "Reserved", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type public_ip_lifetime: str

        :param associated_public_ip_pool:
            The value to assign to the associated_public_ip_pool property of this IpInventorySubnetResourceSummary.
            Allowed values for this property are: "ORACLE", "BYOIP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type associated_public_ip_pool: str

        :param dns_host_name:
            The value to assign to the dns_host_name property of this IpInventorySubnetResourceSummary.
        :type dns_host_name: str

        :param assigned_resource_name:
            The value to assign to the assigned_resource_name property of this IpInventorySubnetResourceSummary.
        :type assigned_resource_name: str

        :param assigned_resource_type:
            The value to assign to the assigned_resource_type property of this IpInventorySubnetResourceSummary.
            Allowed values for this property are: "Resource", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type assigned_resource_type: str

        :param address_type:
            The value to assign to the address_type property of this IpInventorySubnetResourceSummary.
        :type address_type: str

        :param assigned_time:
            The value to assign to the assigned_time property of this IpInventorySubnetResourceSummary.
        :type assigned_time: datetime

        """
        self.swagger_types = {
            'ip_id': 'str',
            'ip_address': 'str',
            'ip_address_lifetime': 'str',
            'parent_cidr': 'str',
            'associated_public_ip': 'str',
            'public_ip_lifetime': 'str',
            'associated_public_ip_pool': 'str',
            'dns_host_name': 'str',
            'assigned_resource_name': 'str',
            'assigned_resource_type': 'str',
            'address_type': 'str',
            'assigned_time': 'datetime'
        }
        self.attribute_map = {
            'ip_id': 'ipId',
            'ip_address': 'ipAddress',
            'ip_address_lifetime': 'ipAddressLifetime',
            'parent_cidr': 'parentCidr',
            'associated_public_ip': 'associatedPublicIp',
            'public_ip_lifetime': 'publicIpLifetime',
            'associated_public_ip_pool': 'associatedPublicIpPool',
            'dns_host_name': 'dnsHostName',
            'assigned_resource_name': 'assignedResourceName',
            'assigned_resource_type': 'assignedResourceType',
            'address_type': 'addressType',
            'assigned_time': 'assignedTime'
        }
        self._ip_id = None
        self._ip_address = None
        self._ip_address_lifetime = None
        self._parent_cidr = None
        self._associated_public_ip = None
        self._public_ip_lifetime = None
        self._associated_public_ip_pool = None
        self._dns_host_name = None
        self._assigned_resource_name = None
        self._assigned_resource_type = None
        self._address_type = None
        self._assigned_time = None

    @property
    def ip_id(self):
        """
        Gets the ip_id of this IpInventorySubnetResourceSummary.
        The `OCID`__ of the IP address.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The ip_id of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._ip_id

    @ip_id.setter
    def ip_id(self, ip_id):
        """
        Sets the ip_id of this IpInventorySubnetResourceSummary.
        The `OCID`__ of the IP address.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param ip_id: The ip_id of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._ip_id = ip_id

    @property
    def ip_address(self):
        """
        Gets the ip_address of this IpInventorySubnetResourceSummary.
        Lists the allocated private IP address.


        :return: The ip_address of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this IpInventorySubnetResourceSummary.
        Lists the allocated private IP address.


        :param ip_address: The ip_address of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def ip_address_lifetime(self):
        """
        Gets the ip_address_lifetime of this IpInventorySubnetResourceSummary.
        Lifetime of the allocated private IP address.

        Allowed values for this property are: "Ephemeral", "Reserved", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The ip_address_lifetime of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._ip_address_lifetime

    @ip_address_lifetime.setter
    def ip_address_lifetime(self, ip_address_lifetime):
        """
        Sets the ip_address_lifetime of this IpInventorySubnetResourceSummary.
        Lifetime of the allocated private IP address.


        :param ip_address_lifetime: The ip_address_lifetime of this IpInventorySubnetResourceSummary.
        :type: str
        """
        allowed_values = ["Ephemeral", "Reserved"]
        if not value_allowed_none_or_none_sentinel(ip_address_lifetime, allowed_values):
            ip_address_lifetime = 'UNKNOWN_ENUM_VALUE'
        self._ip_address_lifetime = ip_address_lifetime

    @property
    def parent_cidr(self):
        """
        Gets the parent_cidr of this IpInventorySubnetResourceSummary.
        The address range the IP address is assigned from.


        :return: The parent_cidr of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._parent_cidr

    @parent_cidr.setter
    def parent_cidr(self, parent_cidr):
        """
        Sets the parent_cidr of this IpInventorySubnetResourceSummary.
        The address range the IP address is assigned from.


        :param parent_cidr: The parent_cidr of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._parent_cidr = parent_cidr

    @property
    def associated_public_ip(self):
        """
        Gets the associated_public_ip of this IpInventorySubnetResourceSummary.
        Associated public IP address for the private IP address.


        :return: The associated_public_ip of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._associated_public_ip

    @associated_public_ip.setter
    def associated_public_ip(self, associated_public_ip):
        """
        Sets the associated_public_ip of this IpInventorySubnetResourceSummary.
        Associated public IP address for the private IP address.


        :param associated_public_ip: The associated_public_ip of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._associated_public_ip = associated_public_ip

    @property
    def public_ip_lifetime(self):
        """
        Gets the public_ip_lifetime of this IpInventorySubnetResourceSummary.
        Lifetime of the assigned public IP address.

        Allowed values for this property are: "Ephemeral", "Reserved", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The public_ip_lifetime of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._public_ip_lifetime

    @public_ip_lifetime.setter
    def public_ip_lifetime(self, public_ip_lifetime):
        """
        Sets the public_ip_lifetime of this IpInventorySubnetResourceSummary.
        Lifetime of the assigned public IP address.


        :param public_ip_lifetime: The public_ip_lifetime of this IpInventorySubnetResourceSummary.
        :type: str
        """
        allowed_values = ["Ephemeral", "Reserved"]
        if not value_allowed_none_or_none_sentinel(public_ip_lifetime, allowed_values):
            public_ip_lifetime = 'UNKNOWN_ENUM_VALUE'
        self._public_ip_lifetime = public_ip_lifetime

    @property
    def associated_public_ip_pool(self):
        """
        Gets the associated_public_ip_pool of this IpInventorySubnetResourceSummary.
        Public IP address Pool the IP address is allocated from.

        Allowed values for this property are: "ORACLE", "BYOIP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The associated_public_ip_pool of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._associated_public_ip_pool

    @associated_public_ip_pool.setter
    def associated_public_ip_pool(self, associated_public_ip_pool):
        """
        Sets the associated_public_ip_pool of this IpInventorySubnetResourceSummary.
        Public IP address Pool the IP address is allocated from.


        :param associated_public_ip_pool: The associated_public_ip_pool of this IpInventorySubnetResourceSummary.
        :type: str
        """
        allowed_values = ["ORACLE", "BYOIP"]
        if not value_allowed_none_or_none_sentinel(associated_public_ip_pool, allowed_values):
            associated_public_ip_pool = 'UNKNOWN_ENUM_VALUE'
        self._associated_public_ip_pool = associated_public_ip_pool

    @property
    def dns_host_name(self):
        """
        Gets the dns_host_name of this IpInventorySubnetResourceSummary.
        DNS hostname of the IP address.


        :return: The dns_host_name of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._dns_host_name

    @dns_host_name.setter
    def dns_host_name(self, dns_host_name):
        """
        Sets the dns_host_name of this IpInventorySubnetResourceSummary.
        DNS hostname of the IP address.


        :param dns_host_name: The dns_host_name of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._dns_host_name = dns_host_name

    @property
    def assigned_resource_name(self):
        """
        Gets the assigned_resource_name of this IpInventorySubnetResourceSummary.
        Name of the created resource.


        :return: The assigned_resource_name of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._assigned_resource_name

    @assigned_resource_name.setter
    def assigned_resource_name(self, assigned_resource_name):
        """
        Sets the assigned_resource_name of this IpInventorySubnetResourceSummary.
        Name of the created resource.


        :param assigned_resource_name: The assigned_resource_name of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._assigned_resource_name = assigned_resource_name

    @property
    def assigned_resource_type(self):
        """
        Gets the assigned_resource_type of this IpInventorySubnetResourceSummary.
        Type of the resource.

        Allowed values for this property are: "Resource", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The assigned_resource_type of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._assigned_resource_type

    @assigned_resource_type.setter
    def assigned_resource_type(self, assigned_resource_type):
        """
        Sets the assigned_resource_type of this IpInventorySubnetResourceSummary.
        Type of the resource.


        :param assigned_resource_type: The assigned_resource_type of this IpInventorySubnetResourceSummary.
        :type: str
        """
        allowed_values = ["Resource"]
        if not value_allowed_none_or_none_sentinel(assigned_resource_type, allowed_values):
            assigned_resource_type = 'UNKNOWN_ENUM_VALUE'
        self._assigned_resource_type = assigned_resource_type

    @property
    def address_type(self):
        """
        Gets the address_type of this IpInventorySubnetResourceSummary.
        Address type of the allocated private IP address.


        :return: The address_type of this IpInventorySubnetResourceSummary.
        :rtype: str
        """
        return self._address_type

    @address_type.setter
    def address_type(self, address_type):
        """
        Sets the address_type of this IpInventorySubnetResourceSummary.
        Address type of the allocated private IP address.


        :param address_type: The address_type of this IpInventorySubnetResourceSummary.
        :type: str
        """
        self._address_type = address_type

    @property
    def assigned_time(self):
        """
        Gets the assigned_time of this IpInventorySubnetResourceSummary.
        Assigned time of the private IP address.


        :return: The assigned_time of this IpInventorySubnetResourceSummary.
        :rtype: datetime
        """
        return self._assigned_time

    @assigned_time.setter
    def assigned_time(self, assigned_time):
        """
        Sets the assigned_time of this IpInventorySubnetResourceSummary.
        Assigned time of the private IP address.


        :param assigned_time: The assigned_time of this IpInventorySubnetResourceSummary.
        :type: datetime
        """
        self._assigned_time = assigned_time

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
