# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateScheduleDetails(object):
    """
    Creation details for a new schedule.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateScheduleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateScheduleDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateScheduleDetails.
        :type description: str

        :param project_id:
            The value to assign to the project_id property of this CreateScheduleDetails.
        :type project_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateScheduleDetails.
        :type compartment_id: str

        :param trigger:
            The value to assign to the trigger property of this CreateScheduleDetails.
        :type trigger: oci.data_science.models.ScheduleTrigger

        :param action:
            The value to assign to the action property of this CreateScheduleDetails.
        :type action: oci.data_science.models.ScheduleAction

        :param log_details:
            The value to assign to the log_details property of this CreateScheduleDetails.
        :type log_details: oci.data_science.models.ScheduleLogDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateScheduleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateScheduleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'project_id': 'str',
            'compartment_id': 'str',
            'trigger': 'ScheduleTrigger',
            'action': 'ScheduleAction',
            'log_details': 'ScheduleLogDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'project_id': 'projectId',
            'compartment_id': 'compartmentId',
            'trigger': 'trigger',
            'action': 'action',
            'log_details': 'logDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._project_id = None
        self._compartment_id = None
        self._trigger = None
        self._action = None
        self._log_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateScheduleDetails.
        A user-friendly name. Avoid entering confidential information.


        :return: The display_name of this CreateScheduleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateScheduleDetails.
        A user-friendly name. Avoid entering confidential information.


        :param display_name: The display_name of this CreateScheduleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateScheduleDetails.
        A short description of the schedule.


        :return: The description of this CreateScheduleDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateScheduleDetails.
        A short description of the schedule.


        :param description: The description of this CreateScheduleDetails.
        :type: str
        """
        self._description = description

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this CreateScheduleDetails.
        The `OCID`__ of the project to associate the schedule with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this CreateScheduleDetails.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this CreateScheduleDetails.
        The `OCID`__ of the project to associate the schedule with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this CreateScheduleDetails.
        :type: str
        """
        self._project_id = project_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateScheduleDetails.
        The `OCID`__ of the compartment that contains the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateScheduleDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateScheduleDetails.
        The `OCID`__ of the compartment that contains the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateScheduleDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def trigger(self):
        """
        **[Required]** Gets the trigger of this CreateScheduleDetails.

        :return: The trigger of this CreateScheduleDetails.
        :rtype: oci.data_science.models.ScheduleTrigger
        """
        return self._trigger

    @trigger.setter
    def trigger(self, trigger):
        """
        Sets the trigger of this CreateScheduleDetails.

        :param trigger: The trigger of this CreateScheduleDetails.
        :type: oci.data_science.models.ScheduleTrigger
        """
        self._trigger = trigger

    @property
    def action(self):
        """
        **[Required]** Gets the action of this CreateScheduleDetails.

        :return: The action of this CreateScheduleDetails.
        :rtype: oci.data_science.models.ScheduleAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this CreateScheduleDetails.

        :param action: The action of this CreateScheduleDetails.
        :type: oci.data_science.models.ScheduleAction
        """
        self._action = action

    @property
    def log_details(self):
        """
        Gets the log_details of this CreateScheduleDetails.

        :return: The log_details of this CreateScheduleDetails.
        :rtype: oci.data_science.models.ScheduleLogDetails
        """
        return self._log_details

    @log_details.setter
    def log_details(self, log_details):
        """
        Sets the log_details of this CreateScheduleDetails.

        :param log_details: The log_details of this CreateScheduleDetails.
        :type: oci.data_science.models.ScheduleLogDetails
        """
        self._log_details = log_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateScheduleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateScheduleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateScheduleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateScheduleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateScheduleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateScheduleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
