# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .metric_expression_rule import MetricExpressionRule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomMetricExpressionRule(MetricExpressionRule):
    """
    A custom Monitoring Query Language (MQL) expression for triggering an autoscaling action on the model deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomMetricExpressionRule object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.CustomMetricExpressionRule.metric_expression_rule_type` attribute
        of this class is ``CUSTOM_EXPRESSION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_expression_rule_type:
            The value to assign to the metric_expression_rule_type property of this CustomMetricExpressionRule.
            Allowed values for this property are: "PREDEFINED_EXPRESSION", "CUSTOM_EXPRESSION"
        :type metric_expression_rule_type: str

        :param scale_in_configuration:
            The value to assign to the scale_in_configuration property of this CustomMetricExpressionRule.
        :type scale_in_configuration: oci.data_science.models.CustomExpressionQueryScalingConfiguration

        :param scale_out_configuration:
            The value to assign to the scale_out_configuration property of this CustomMetricExpressionRule.
        :type scale_out_configuration: oci.data_science.models.CustomExpressionQueryScalingConfiguration

        """
        self.swagger_types = {
            'metric_expression_rule_type': 'str',
            'scale_in_configuration': 'CustomExpressionQueryScalingConfiguration',
            'scale_out_configuration': 'CustomExpressionQueryScalingConfiguration'
        }
        self.attribute_map = {
            'metric_expression_rule_type': 'metricExpressionRuleType',
            'scale_in_configuration': 'scaleInConfiguration',
            'scale_out_configuration': 'scaleOutConfiguration'
        }
        self._metric_expression_rule_type = None
        self._scale_in_configuration = None
        self._scale_out_configuration = None
        self._metric_expression_rule_type = 'CUSTOM_EXPRESSION'

    @property
    def scale_in_configuration(self):
        """
        **[Required]** Gets the scale_in_configuration of this CustomMetricExpressionRule.

        :return: The scale_in_configuration of this CustomMetricExpressionRule.
        :rtype: oci.data_science.models.CustomExpressionQueryScalingConfiguration
        """
        return self._scale_in_configuration

    @scale_in_configuration.setter
    def scale_in_configuration(self, scale_in_configuration):
        """
        Sets the scale_in_configuration of this CustomMetricExpressionRule.

        :param scale_in_configuration: The scale_in_configuration of this CustomMetricExpressionRule.
        :type: oci.data_science.models.CustomExpressionQueryScalingConfiguration
        """
        self._scale_in_configuration = scale_in_configuration

    @property
    def scale_out_configuration(self):
        """
        **[Required]** Gets the scale_out_configuration of this CustomMetricExpressionRule.

        :return: The scale_out_configuration of this CustomMetricExpressionRule.
        :rtype: oci.data_science.models.CustomExpressionQueryScalingConfiguration
        """
        return self._scale_out_configuration

    @scale_out_configuration.setter
    def scale_out_configuration(self, scale_out_configuration):
        """
        Sets the scale_out_configuration of this CustomMetricExpressionRule.

        :param scale_out_configuration: The scale_out_configuration of this CustomMetricExpressionRule.
        :type: oci.data_science.models.CustomExpressionQueryScalingConfiguration
        """
        self._scale_out_configuration = scale_out_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
