# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousContainerDatabaseBackup(object):
    """
    An Autonomous Database backup.
    """

    #: A constant which can be used with the type property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "INCREMENTAL"
    TYPE_INCREMENTAL = "INCREMENTAL"

    #: A constant which can be used with the type property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "FULL"
    TYPE_FULL = "FULL"

    #: A constant which can be used with the lifecycle_state property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the infrastructure_type property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "CLOUD"
    INFRASTRUCTURE_TYPE_CLOUD = "CLOUD"

    #: A constant which can be used with the infrastructure_type property of a AutonomousContainerDatabaseBackup.
    #: This constant has a value of "CLOUD_AT_CUSTOMER"
    INFRASTRUCTURE_TYPE_CLOUD_AT_CUSTOMER = "CLOUD_AT_CUSTOMER"

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousContainerDatabaseBackup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AutonomousContainerDatabaseBackup.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AutonomousContainerDatabaseBackup.
        :type compartment_id: str

        :param autonomous_container_database_id:
            The value to assign to the autonomous_container_database_id property of this AutonomousContainerDatabaseBackup.
        :type autonomous_container_database_id: str

        :param display_name:
            The value to assign to the display_name property of this AutonomousContainerDatabaseBackup.
        :type display_name: str

        :param acd_display_name:
            The value to assign to the acd_display_name property of this AutonomousContainerDatabaseBackup.
        :type acd_display_name: str

        :param type:
            The value to assign to the type property of this AutonomousContainerDatabaseBackup.
            Allowed values for this property are: "INCREMENTAL", "FULL"
        :type type: str

        :param is_automatic:
            The value to assign to the is_automatic property of this AutonomousContainerDatabaseBackup.
        :type is_automatic: bool

        :param time_started:
            The value to assign to the time_started property of this AutonomousContainerDatabaseBackup.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this AutonomousContainerDatabaseBackup.
        :type time_ended: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AutonomousContainerDatabaseBackup.
        :type lifecycle_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AutonomousContainerDatabaseBackup.
            Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param retention_period_in_days:
            The value to assign to the retention_period_in_days property of this AutonomousContainerDatabaseBackup.
        :type retention_period_in_days: int

        :param is_remote_backup:
            The value to assign to the is_remote_backup property of this AutonomousContainerDatabaseBackup.
        :type is_remote_backup: bool

        :param infrastructure_type:
            The value to assign to the infrastructure_type property of this AutonomousContainerDatabaseBackup.
            Allowed values for this property are: "CLOUD", "CLOUD_AT_CUSTOMER"
        :type infrastructure_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AutonomousContainerDatabaseBackup.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AutonomousContainerDatabaseBackup.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AutonomousContainerDatabaseBackup.
        :type system_tags: dict(str, dict(str, object))

        :param autonomous_databases:
            The value to assign to the autonomous_databases property of this AutonomousContainerDatabaseBackup.
        :type autonomous_databases: list[oci.database.models.AutonomousDatabaseInBackup]

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'autonomous_container_database_id': 'str',
            'display_name': 'str',
            'acd_display_name': 'str',
            'type': 'str',
            'is_automatic': 'bool',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'lifecycle_details': 'str',
            'lifecycle_state': 'str',
            'retention_period_in_days': 'int',
            'is_remote_backup': 'bool',
            'infrastructure_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'autonomous_databases': 'list[AutonomousDatabaseInBackup]'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'autonomous_container_database_id': 'autonomousContainerDatabaseId',
            'display_name': 'displayName',
            'acd_display_name': 'acdDisplayName',
            'type': 'type',
            'is_automatic': 'isAutomatic',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'lifecycle_details': 'lifecycleDetails',
            'lifecycle_state': 'lifecycleState',
            'retention_period_in_days': 'retentionPeriodInDays',
            'is_remote_backup': 'isRemoteBackup',
            'infrastructure_type': 'infrastructureType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'autonomous_databases': 'autonomousDatabases'
        }
        self._id = None
        self._compartment_id = None
        self._autonomous_container_database_id = None
        self._display_name = None
        self._acd_display_name = None
        self._type = None
        self._is_automatic = None
        self._time_started = None
        self._time_ended = None
        self._lifecycle_details = None
        self._lifecycle_state = None
        self._retention_period_in_days = None
        self._is_remote_backup = None
        self._infrastructure_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._autonomous_databases = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the Autonomous Database backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the Autonomous Database backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def autonomous_container_database_id(self):
        """
        **[Required]** Gets the autonomous_container_database_id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the Autonomous Container Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The autonomous_container_database_id of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._autonomous_container_database_id

    @autonomous_container_database_id.setter
    def autonomous_container_database_id(self, autonomous_container_database_id):
        """
        Sets the autonomous_container_database_id of this AutonomousContainerDatabaseBackup.
        The `OCID`__ of the Autonomous Container Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param autonomous_container_database_id: The autonomous_container_database_id of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._autonomous_container_database_id = autonomous_container_database_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AutonomousContainerDatabaseBackup.
        A user-friendly name for the backup. This name need not be unique.


        :return: The display_name of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AutonomousContainerDatabaseBackup.
        A user-friendly name for the backup. This name need not be unique.


        :param display_name: The display_name of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._display_name = display_name

    @property
    def acd_display_name(self):
        """
        Gets the acd_display_name of this AutonomousContainerDatabaseBackup.
        The user-friendly name for the Autonomous Container Database when the Backup was initiated. This name need not be unique. This field captures the name at the time of backup creation, accounting for possible later updates to the display name.


        :return: The acd_display_name of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._acd_display_name

    @acd_display_name.setter
    def acd_display_name(self, acd_display_name):
        """
        Sets the acd_display_name of this AutonomousContainerDatabaseBackup.
        The user-friendly name for the Autonomous Container Database when the Backup was initiated. This name need not be unique. This field captures the name at the time of backup creation, accounting for possible later updates to the display name.


        :param acd_display_name: The acd_display_name of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._acd_display_name = acd_display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this AutonomousContainerDatabaseBackup.
        The type of backup.

        Allowed values for this property are: "INCREMENTAL", "FULL"


        :return: The type of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AutonomousContainerDatabaseBackup.
        The type of backup.


        :param type: The type of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        allowed_values = ["INCREMENTAL", "FULL"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def is_automatic(self):
        """
        **[Required]** Gets the is_automatic of this AutonomousContainerDatabaseBackup.
        Indicates whether the backup is user-initiated or automatic.


        :return: The is_automatic of this AutonomousContainerDatabaseBackup.
        :rtype: bool
        """
        return self._is_automatic

    @is_automatic.setter
    def is_automatic(self, is_automatic):
        """
        Sets the is_automatic of this AutonomousContainerDatabaseBackup.
        Indicates whether the backup is user-initiated or automatic.


        :param is_automatic: The is_automatic of this AutonomousContainerDatabaseBackup.
        :type: bool
        """
        self._is_automatic = is_automatic

    @property
    def time_started(self):
        """
        Gets the time_started of this AutonomousContainerDatabaseBackup.
        The date and time the backup started.


        :return: The time_started of this AutonomousContainerDatabaseBackup.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this AutonomousContainerDatabaseBackup.
        The date and time the backup started.


        :param time_started: The time_started of this AutonomousContainerDatabaseBackup.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this AutonomousContainerDatabaseBackup.
        The date and time the backup completed.


        :return: The time_ended of this AutonomousContainerDatabaseBackup.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this AutonomousContainerDatabaseBackup.
        The date and time the backup completed.


        :param time_ended: The time_ended of this AutonomousContainerDatabaseBackup.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AutonomousContainerDatabaseBackup.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AutonomousContainerDatabaseBackup.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AutonomousContainerDatabaseBackup.
        The current state of the backup.

        Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED"


        :return: The lifecycle_state of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AutonomousContainerDatabaseBackup.
        The current state of the backup.


        :param lifecycle_state: The lifecycle_state of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def retention_period_in_days(self):
        """
        Gets the retention_period_in_days of this AutonomousContainerDatabaseBackup.
        Retention period, in days, for long-term backups


        :return: The retention_period_in_days of this AutonomousContainerDatabaseBackup.
        :rtype: int
        """
        return self._retention_period_in_days

    @retention_period_in_days.setter
    def retention_period_in_days(self, retention_period_in_days):
        """
        Sets the retention_period_in_days of this AutonomousContainerDatabaseBackup.
        Retention period, in days, for long-term backups


        :param retention_period_in_days: The retention_period_in_days of this AutonomousContainerDatabaseBackup.
        :type: int
        """
        self._retention_period_in_days = retention_period_in_days

    @property
    def is_remote_backup(self):
        """
        Gets the is_remote_backup of this AutonomousContainerDatabaseBackup.
        Whether backup is for remote-region or local region


        :return: The is_remote_backup of this AutonomousContainerDatabaseBackup.
        :rtype: bool
        """
        return self._is_remote_backup

    @is_remote_backup.setter
    def is_remote_backup(self, is_remote_backup):
        """
        Sets the is_remote_backup of this AutonomousContainerDatabaseBackup.
        Whether backup is for remote-region or local region


        :param is_remote_backup: The is_remote_backup of this AutonomousContainerDatabaseBackup.
        :type: bool
        """
        self._is_remote_backup = is_remote_backup

    @property
    def infrastructure_type(self):
        """
        Gets the infrastructure_type of this AutonomousContainerDatabaseBackup.
        The infrastructure type this resource belongs to.

        Allowed values for this property are: "CLOUD", "CLOUD_AT_CUSTOMER"


        :return: The infrastructure_type of this AutonomousContainerDatabaseBackup.
        :rtype: str
        """
        return self._infrastructure_type

    @infrastructure_type.setter
    def infrastructure_type(self, infrastructure_type):
        """
        Sets the infrastructure_type of this AutonomousContainerDatabaseBackup.
        The infrastructure type this resource belongs to.


        :param infrastructure_type: The infrastructure_type of this AutonomousContainerDatabaseBackup.
        :type: str
        """
        allowed_values = ["CLOUD", "CLOUD_AT_CUSTOMER"]
        if not value_allowed_none_or_none_sentinel(infrastructure_type, allowed_values):
            raise ValueError(
                f"Invalid value for `infrastructure_type`, must be None or one of {allowed_values}"
            )
        self._infrastructure_type = infrastructure_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AutonomousContainerDatabaseBackup.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AutonomousContainerDatabaseBackup.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AutonomousContainerDatabaseBackup.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AutonomousContainerDatabaseBackup.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AutonomousContainerDatabaseBackup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AutonomousContainerDatabaseBackup.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AutonomousContainerDatabaseBackup.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AutonomousContainerDatabaseBackup.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AutonomousContainerDatabaseBackup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this AutonomousContainerDatabaseBackup.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AutonomousContainerDatabaseBackup.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this AutonomousContainerDatabaseBackup.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def autonomous_databases(self):
        """
        Gets the autonomous_databases of this AutonomousContainerDatabaseBackup.
        List of Autonomous Databases that is part of this Autonomous Container Database Backup


        :return: The autonomous_databases of this AutonomousContainerDatabaseBackup.
        :rtype: list[oci.database.models.AutonomousDatabaseInBackup]
        """
        return self._autonomous_databases

    @autonomous_databases.setter
    def autonomous_databases(self, autonomous_databases):
        """
        Sets the autonomous_databases of this AutonomousContainerDatabaseBackup.
        List of Autonomous Databases that is part of this Autonomous Container Database Backup


        :param autonomous_databases: The autonomous_databases of this AutonomousContainerDatabaseBackup.
        :type: list[oci.database.models.AutonomousDatabaseInBackup]
        """
        self._autonomous_databases = autonomous_databases

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
