# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemUpgradeSummary(object):
    """
    It describes the various upgrade properties such as component, osversion, giversion for any VM DB system.
    """

    #: A constant which can be used with the component property of a DbSystemUpgradeSummary.
    #: This constant has a value of "OS"
    COMPONENT_OS = "OS"

    #: A constant which can be used with the component property of a DbSystemUpgradeSummary.
    #: This constant has a value of "OS_GI"
    COMPONENT_OS_GI = "OS_GI"

    #: A constant which can be used with the component property of a DbSystemUpgradeSummary.
    #: This constant has a value of "GI"
    COMPONENT_GI = "GI"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemUpgradeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component:
            The value to assign to the component property of this DbSystemUpgradeSummary.
            Allowed values for this property are: "OS", "OS_GI", "GI", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type component: str

        :param os_version:
            The value to assign to the os_version property of this DbSystemUpgradeSummary.
        :type os_version: str

        :param gi_version:
            The value to assign to the gi_version property of this DbSystemUpgradeSummary.
        :type gi_version: str

        """
        self.swagger_types = {
            'component': 'str',
            'os_version': 'str',
            'gi_version': 'str'
        }
        self.attribute_map = {
            'component': 'component',
            'os_version': 'osVersion',
            'gi_version': 'giVersion'
        }
        self._component = None
        self._os_version = None
        self._gi_version = None

    @property
    def component(self):
        """
        **[Required]** Gets the component of this DbSystemUpgradeSummary.
        The component on which upgrade is applicable. OS (Operating System upgrade), GI (Grid Infrastructure upgrade) or OS_GI (both Operating System and Grid Infrastructure upgrade)

        Allowed values for this property are: "OS", "OS_GI", "GI", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The component of this DbSystemUpgradeSummary.
        :rtype: str
        """
        return self._component

    @component.setter
    def component(self, component):
        """
        Sets the component of this DbSystemUpgradeSummary.
        The component on which upgrade is applicable. OS (Operating System upgrade), GI (Grid Infrastructure upgrade) or OS_GI (both Operating System and Grid Infrastructure upgrade)


        :param component: The component of this DbSystemUpgradeSummary.
        :type: str
        """
        allowed_values = ["OS", "OS_GI", "GI"]
        if not value_allowed_none_or_none_sentinel(component, allowed_values):
            component = 'UNKNOWN_ENUM_VALUE'
        self._component = component

    @property
    def os_version(self):
        """
        Gets the os_version of this DbSystemUpgradeSummary.
        The version of the OS for this upgrade eg. Oracle Linux Server release 7.9


        :return: The os_version of this DbSystemUpgradeSummary.
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """
        Sets the os_version of this DbSystemUpgradeSummary.
        The version of the OS for this upgrade eg. Oracle Linux Server release 7.9


        :param os_version: The os_version of this DbSystemUpgradeSummary.
        :type: str
        """
        self._os_version = os_version

    @property
    def gi_version(self):
        """
        Gets the gi_version of this DbSystemUpgradeSummary.
        The version of the grid infrastructure for this upgrade. This is only applicable for ASM based DbSystems


        :return: The gi_version of this DbSystemUpgradeSummary.
        :rtype: str
        """
        return self._gi_version

    @gi_version.setter
    def gi_version(self, gi_version):
        """
        Sets the gi_version of this DbSystemUpgradeSummary.
        The version of the grid infrastructure for this upgrade. This is only applicable for ASM based DbSystems


        :param gi_version: The gi_version of this DbSystemUpgradeSummary.
        :type: str
        """
        self._gi_version = gi_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
