# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDataGuardDetails(object):
    """
    The properties for updating a standby database.
    """

    #: A constant which can be used with the protection_mode property of a UpdateDataGuardDetails.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a UpdateDataGuardDetails.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    #: A constant which can be used with the protection_mode property of a UpdateDataGuardDetails.
    #: This constant has a value of "MAXIMUM_PROTECTION"
    PROTECTION_MODE_MAXIMUM_PROTECTION = "MAXIMUM_PROTECTION"

    #: A constant which can be used with the transport_type property of a UpdateDataGuardDetails.
    #: This constant has a value of "SYNC"
    TRANSPORT_TYPE_SYNC = "SYNC"

    #: A constant which can be used with the transport_type property of a UpdateDataGuardDetails.
    #: This constant has a value of "ASYNC"
    TRANSPORT_TYPE_ASYNC = "ASYNC"

    #: A constant which can be used with the transport_type property of a UpdateDataGuardDetails.
    #: This constant has a value of "FASTSYNC"
    TRANSPORT_TYPE_FASTSYNC = "FASTSYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDataGuardDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_admin_password:
            The value to assign to the database_admin_password property of this UpdateDataGuardDetails.
        :type database_admin_password: str

        :param protection_mode:
            The value to assign to the protection_mode property of this UpdateDataGuardDetails.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"
        :type protection_mode: str

        :param transport_type:
            The value to assign to the transport_type property of this UpdateDataGuardDetails.
            Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"
        :type transport_type: str

        :param is_active_data_guard_enabled:
            The value to assign to the is_active_data_guard_enabled property of this UpdateDataGuardDetails.
        :type is_active_data_guard_enabled: bool

        """
        self.swagger_types = {
            'database_admin_password': 'str',
            'protection_mode': 'str',
            'transport_type': 'str',
            'is_active_data_guard_enabled': 'bool'
        }
        self.attribute_map = {
            'database_admin_password': 'databaseAdminPassword',
            'protection_mode': 'protectionMode',
            'transport_type': 'transportType',
            'is_active_data_guard_enabled': 'isActiveDataGuardEnabled'
        }
        self._database_admin_password = None
        self._protection_mode = None
        self._transport_type = None
        self._is_active_data_guard_enabled = None

    @property
    def database_admin_password(self):
        """
        Gets the database_admin_password of this UpdateDataGuardDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :return: The database_admin_password of this UpdateDataGuardDetails.
        :rtype: str
        """
        return self._database_admin_password

    @database_admin_password.setter
    def database_admin_password(self, database_admin_password):
        """
        Sets the database_admin_password of this UpdateDataGuardDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :param database_admin_password: The database_admin_password of this UpdateDataGuardDetails.
        :type: str
        """
        self._database_admin_password = database_admin_password

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this UpdateDataGuardDetails.
        The protection mode of this Data Guard. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"


        :return: The protection_mode of this UpdateDataGuardDetails.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this UpdateDataGuardDetails.
        The protection mode of this Data Guard. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000


        :param protection_mode: The protection_mode of this UpdateDataGuardDetails.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `protection_mode`, must be None or one of {allowed_values}"
            )
        self._protection_mode = protection_mode

    @property
    def transport_type(self):
        """
        Gets the transport_type of this UpdateDataGuardDetails.
        The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:

        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see
        `Redo Transport Services`__
        in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400

        Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"


        :return: The transport_type of this UpdateDataGuardDetails.
        :rtype: str
        """
        return self._transport_type

    @transport_type.setter
    def transport_type(self, transport_type):
        """
        Sets the transport_type of this UpdateDataGuardDetails.
        The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:

        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see
        `Redo Transport Services`__
        in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400


        :param transport_type: The transport_type of this UpdateDataGuardDetails.
        :type: str
        """
        allowed_values = ["SYNC", "ASYNC", "FASTSYNC"]
        if not value_allowed_none_or_none_sentinel(transport_type, allowed_values):
            raise ValueError(
                f"Invalid value for `transport_type`, must be None or one of {allowed_values}"
            )
        self._transport_type = transport_type

    @property
    def is_active_data_guard_enabled(self):
        """
        Gets the is_active_data_guard_enabled of this UpdateDataGuardDetails.
        True if active Data Guard is enabled.


        :return: The is_active_data_guard_enabled of this UpdateDataGuardDetails.
        :rtype: bool
        """
        return self._is_active_data_guard_enabled

    @is_active_data_guard_enabled.setter
    def is_active_data_guard_enabled(self, is_active_data_guard_enabled):
        """
        Sets the is_active_data_guard_enabled of this UpdateDataGuardDetails.
        True if active Data Guard is enabled.


        :param is_active_data_guard_enabled: The is_active_data_guard_enabled of this UpdateDataGuardDetails.
        :type: bool
        """
        self._is_active_data_guard_enabled = is_active_data_guard_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
