# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateExecutionActionDetails(object):
    """
    Describes the modification parameters for the execution action.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateExecutionActionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param execution_window_id:
            The value to assign to the execution_window_id property of this UpdateExecutionActionDetails.
        :type execution_window_id: str

        :param action_params:
            The value to assign to the action_params property of this UpdateExecutionActionDetails.
        :type action_params: dict(str, str)

        :param action_members:
            The value to assign to the action_members property of this UpdateExecutionActionDetails.
        :type action_members: list[oci.database.models.ExecutionActionMember]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateExecutionActionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateExecutionActionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'execution_window_id': 'str',
            'action_params': 'dict(str, str)',
            'action_members': 'list[ExecutionActionMember]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'execution_window_id': 'executionWindowId',
            'action_params': 'actionParams',
            'action_members': 'actionMembers',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._execution_window_id = None
        self._action_params = None
        self._action_members = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def execution_window_id(self):
        """
        Gets the execution_window_id of this UpdateExecutionActionDetails.
        The `OCID`__ of the execution window resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The execution_window_id of this UpdateExecutionActionDetails.
        :rtype: str
        """
        return self._execution_window_id

    @execution_window_id.setter
    def execution_window_id(self, execution_window_id):
        """
        Sets the execution_window_id of this UpdateExecutionActionDetails.
        The `OCID`__ of the execution window resource the execution action belongs to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param execution_window_id: The execution_window_id of this UpdateExecutionActionDetails.
        :type: str
        """
        self._execution_window_id = execution_window_id

    @property
    def action_params(self):
        """
        Gets the action_params of this UpdateExecutionActionDetails.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :return: The action_params of this UpdateExecutionActionDetails.
        :rtype: dict(str, str)
        """
        return self._action_params

    @action_params.setter
    def action_params(self, action_params):
        """
        Sets the action_params of this UpdateExecutionActionDetails.
        Map<ParamName, ParamValue> where a key value pair describes the specific action parameter.
        Example: `{\"count\": \"3\"}`


        :param action_params: The action_params of this UpdateExecutionActionDetails.
        :type: dict(str, str)
        """
        self._action_params = action_params

    @property
    def action_members(self):
        """
        Gets the action_members of this UpdateExecutionActionDetails.
        List of action members of this execution action.


        :return: The action_members of this UpdateExecutionActionDetails.
        :rtype: list[oci.database.models.ExecutionActionMember]
        """
        return self._action_members

    @action_members.setter
    def action_members(self, action_members):
        """
        Sets the action_members of this UpdateExecutionActionDetails.
        List of action members of this execution action.


        :param action_members: The action_members of this UpdateExecutionActionDetails.
        :type: list[oci.database.models.ExecutionActionMember]
        """
        self._action_members = action_members

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateExecutionActionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateExecutionActionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateExecutionActionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateExecutionActionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateExecutionActionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateExecutionActionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateExecutionActionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateExecutionActionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
