# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalMySqlDatabase(object):
    """
    External database.
    """

    #: A constant which can be used with the management_state property of a ExternalMySqlDatabase.
    #: This constant has a value of "ENABLED"
    MANAGEMENT_STATE_ENABLED = "ENABLED"

    #: A constant which can be used with the management_state property of a ExternalMySqlDatabase.
    #: This constant has a value of "DISABLED"
    MANAGEMENT_STATE_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalMySqlDatabase object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ExternalMySqlDatabase.
        :type compartment_id: str

        :param external_database_id:
            The value to assign to the external_database_id property of this ExternalMySqlDatabase.
        :type external_database_id: str

        :param db_name:
            The value to assign to the db_name property of this ExternalMySqlDatabase.
        :type db_name: str

        :param management_state:
            The value to assign to the management_state property of this ExternalMySqlDatabase.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type management_state: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'external_database_id': 'str',
            'db_name': 'str',
            'management_state': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'external_database_id': 'externalDatabaseId',
            'db_name': 'dbName',
            'management_state': 'managementState'
        }
        self._compartment_id = None
        self._external_database_id = None
        self._db_name = None
        self._management_state = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExternalMySqlDatabase.
        OCID of compartment for the External MySQL Database.


        :return: The compartment_id of this ExternalMySqlDatabase.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExternalMySqlDatabase.
        OCID of compartment for the External MySQL Database.


        :param compartment_id: The compartment_id of this ExternalMySqlDatabase.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def external_database_id(self):
        """
        Gets the external_database_id of this ExternalMySqlDatabase.
        OCID of External MySQL Database.


        :return: The external_database_id of this ExternalMySqlDatabase.
        :rtype: str
        """
        return self._external_database_id

    @external_database_id.setter
    def external_database_id(self, external_database_id):
        """
        Sets the external_database_id of this ExternalMySqlDatabase.
        OCID of External MySQL Database.


        :param external_database_id: The external_database_id of this ExternalMySqlDatabase.
        :type: str
        """
        self._external_database_id = external_database_id

    @property
    def db_name(self):
        """
        **[Required]** Gets the db_name of this ExternalMySqlDatabase.
        Display Name of the External MySQL Database.


        :return: The db_name of this ExternalMySqlDatabase.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this ExternalMySqlDatabase.
        Display Name of the External MySQL Database.


        :param db_name: The db_name of this ExternalMySqlDatabase.
        :type: str
        """
        self._db_name = db_name

    @property
    def management_state(self):
        """
        Gets the management_state of this ExternalMySqlDatabase.
        Indicates database management state.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The management_state of this ExternalMySqlDatabase.
        :rtype: str
        """
        return self._management_state

    @management_state.setter
    def management_state(self, management_state):
        """
        Sets the management_state of this ExternalMySqlDatabase.
        Indicates database management state.


        :param management_state: The management_state of this ExternalMySqlDatabase.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(management_state, allowed_values):
            management_state = 'UNKNOWN_ENUM_VALUE'
        self._management_state = management_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
