# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseHighAvailabilityMemberCollection(object):
    """
    Information pertaining to high availability of a MySQL server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseHighAvailabilityMemberCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param group_name:
            The value to assign to the group_name property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type group_name: str

        :param single_primary_mode:
            The value to assign to the single_primary_mode property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type single_primary_mode: str

        :param group_auto_increment:
            The value to assign to the group_auto_increment property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type group_auto_increment: int

        :param flow_control:
            The value to assign to the flow_control property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type flow_control: str

        :param member_state:
            The value to assign to the member_state property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type member_state: str

        :param member_role:
            The value to assign to the member_role property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type member_role: str

        :param view_id:
            The value to assign to the view_id property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type view_id: str

        :param transactions_in_gtid_executed:
            The value to assign to the transactions_in_gtid_executed property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type transactions_in_gtid_executed: int

        :param items:
            The value to assign to the items property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type items: list[oci.database_management.models.ManagedMySqlDatabaseHighAvailabilityMemberSummary]

        :param status_summary:
            The value to assign to the status_summary property of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type status_summary: oci.database_management.models.MySqlHighAvailabilityStatusSummary

        """
        self.swagger_types = {
            'group_name': 'str',
            'single_primary_mode': 'str',
            'group_auto_increment': 'int',
            'flow_control': 'str',
            'member_state': 'str',
            'member_role': 'str',
            'view_id': 'str',
            'transactions_in_gtid_executed': 'int',
            'items': 'list[ManagedMySqlDatabaseHighAvailabilityMemberSummary]',
            'status_summary': 'MySqlHighAvailabilityStatusSummary'
        }
        self.attribute_map = {
            'group_name': 'groupName',
            'single_primary_mode': 'singlePrimaryMode',
            'group_auto_increment': 'groupAutoIncrement',
            'flow_control': 'flowControl',
            'member_state': 'memberState',
            'member_role': 'memberRole',
            'view_id': 'viewId',
            'transactions_in_gtid_executed': 'transactionsInGtidExecuted',
            'items': 'items',
            'status_summary': 'statusSummary'
        }
        self._group_name = None
        self._single_primary_mode = None
        self._group_auto_increment = None
        self._flow_control = None
        self._member_state = None
        self._member_role = None
        self._view_id = None
        self._transactions_in_gtid_executed = None
        self._items = None
        self._status_summary = None

    @property
    def group_name(self):
        """
        Gets the group_name of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The name of the group to which this server instance belongs.


        :return: The group_name of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The name of the group to which this server instance belongs.


        :param group_name: The group_name of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._group_name = group_name

    @property
    def single_primary_mode(self):
        """
        Gets the single_primary_mode of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        Indicates if the replication group is running in single-primary mode.


        :return: The single_primary_mode of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._single_primary_mode

    @single_primary_mode.setter
    def single_primary_mode(self, single_primary_mode):
        """
        Sets the single_primary_mode of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        Indicates if the replication group is running in single-primary mode.


        :param single_primary_mode: The single_primary_mode of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._single_primary_mode = single_primary_mode

    @property
    def group_auto_increment(self):
        """
        Gets the group_auto_increment of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The interval between successive values for auto-incremented columns for transactions that execute on this server instance.


        :return: The group_auto_increment of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: int
        """
        return self._group_auto_increment

    @group_auto_increment.setter
    def group_auto_increment(self, group_auto_increment):
        """
        Sets the group_auto_increment of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The interval between successive values for auto-incremented columns for transactions that execute on this server instance.


        :param group_auto_increment: The group_auto_increment of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: int
        """
        self._group_auto_increment = group_auto_increment

    @property
    def flow_control(self):
        """
        Gets the flow_control of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The mode used for flow control.


        :return: The flow_control of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._flow_control

    @flow_control.setter
    def flow_control(self, flow_control):
        """
        Sets the flow_control of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The mode used for flow control.


        :param flow_control: The flow_control of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._flow_control = flow_control

    @property
    def member_state(self):
        """
        Gets the member_state of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The state of this server as a group replication member.


        :return: The member_state of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._member_state

    @member_state.setter
    def member_state(self, member_state):
        """
        Sets the member_state of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The state of this server as a group replication member.


        :param member_state: The member_state of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._member_state = member_state

    @property
    def member_role(self):
        """
        Gets the member_role of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The role of this server as a group replication member.


        :return: The member_role of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._member_role

    @member_role.setter
    def member_role(self, member_role):
        """
        Sets the member_role of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The role of this server as a group replication member.


        :param member_role: The member_role of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._member_role = member_role

    @property
    def view_id(self):
        """
        Gets the view_id of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The current view identifier for this group.


        :return: The view_id of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: str
        """
        return self._view_id

    @view_id.setter
    def view_id(self, view_id):
        """
        Sets the view_id of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The current view identifier for this group.


        :param view_id: The view_id of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: str
        """
        self._view_id = view_id

    @property
    def transactions_in_gtid_executed(self):
        """
        Gets the transactions_in_gtid_executed of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The number of transactions that were replicated within the cluster.


        :return: The transactions_in_gtid_executed of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: int
        """
        return self._transactions_in_gtid_executed

    @transactions_in_gtid_executed.setter
    def transactions_in_gtid_executed(self, transactions_in_gtid_executed):
        """
        Sets the transactions_in_gtid_executed of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        The number of transactions that were replicated within the cluster.


        :param transactions_in_gtid_executed: The transactions_in_gtid_executed of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: int
        """
        self._transactions_in_gtid_executed = transactions_in_gtid_executed

    @property
    def items(self):
        """
        **[Required]** Gets the items of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        A list of MySqlHighAvailabilityMember records.


        :return: The items of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: list[oci.database_management.models.ManagedMySqlDatabaseHighAvailabilityMemberSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        A list of MySqlHighAvailabilityMember records.


        :param items: The items of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: list[oci.database_management.models.ManagedMySqlDatabaseHighAvailabilityMemberSummary]
        """
        self._items = items

    @property
    def status_summary(self):
        """
        Gets the status_summary of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.

        :return: The status_summary of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :rtype: oci.database_management.models.MySqlHighAvailabilityStatusSummary
        """
        return self._status_summary

    @status_summary.setter
    def status_summary(self, status_summary):
        """
        Sets the status_summary of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.

        :param status_summary: The status_summary of this ManagedMySqlDatabaseHighAvailabilityMemberCollection.
        :type: oci.database_management.models.MySqlHighAvailabilityStatusSummary
        """
        self._status_summary = status_summary

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
