# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ArcAgentNodes(object):
    """
    Azure Arc Agent Node Details.
    """

    #: A constant which can be used with the status property of a ArcAgentNodes.
    #: This constant has a value of "CONNECTED"
    STATUS_CONNECTED = "CONNECTED"

    #: A constant which can be used with the status property of a ArcAgentNodes.
    #: This constant has a value of "DISCONNECTED"
    STATUS_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the status property of a ArcAgentNodes.
    #: This constant has a value of "UNKNOWN"
    STATUS_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new ArcAgentNodes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param host_name:
            The value to assign to the host_name property of this ArcAgentNodes.
        :type host_name: str

        :param host_id:
            The value to assign to the host_id property of this ArcAgentNodes.
        :type host_id: str

        :param current_arc_agent_version:
            The value to assign to the current_arc_agent_version property of this ArcAgentNodes.
        :type current_arc_agent_version: str

        :param status:
            The value to assign to the status property of this ArcAgentNodes.
            Allowed values for this property are: "CONNECTED", "DISCONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_last_checked:
            The value to assign to the time_last_checked property of this ArcAgentNodes.
        :type time_last_checked: datetime

        """
        self.swagger_types = {
            'host_name': 'str',
            'host_id': 'str',
            'current_arc_agent_version': 'str',
            'status': 'str',
            'time_last_checked': 'datetime'
        }
        self.attribute_map = {
            'host_name': 'hostName',
            'host_id': 'hostId',
            'current_arc_agent_version': 'currentArcAgentVersion',
            'status': 'status',
            'time_last_checked': 'timeLastChecked'
        }
        self._host_name = None
        self._host_id = None
        self._current_arc_agent_version = None
        self._status = None
        self._time_last_checked = None

    @property
    def host_name(self):
        """
        Gets the host_name of this ArcAgentNodes.
        Host Name or Azure Arc Agent Name.


        :return: The host_name of this ArcAgentNodes.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this ArcAgentNodes.
        Host Name or Azure Arc Agent Name.


        :param host_name: The host_name of this ArcAgentNodes.
        :type: str
        """
        self._host_name = host_name

    @property
    def host_id(self):
        """
        Gets the host_id of this ArcAgentNodes.
        Host ID.


        :return: The host_id of this ArcAgentNodes.
        :rtype: str
        """
        return self._host_id

    @host_id.setter
    def host_id(self, host_id):
        """
        Sets the host_id of this ArcAgentNodes.
        Host ID.


        :param host_id: The host_id of this ArcAgentNodes.
        :type: str
        """
        self._host_id = host_id

    @property
    def current_arc_agent_version(self):
        """
        Gets the current_arc_agent_version of this ArcAgentNodes.
        Current Arc Agent Version installed on this node of VM Cluster.


        :return: The current_arc_agent_version of this ArcAgentNodes.
        :rtype: str
        """
        return self._current_arc_agent_version

    @current_arc_agent_version.setter
    def current_arc_agent_version(self, current_arc_agent_version):
        """
        Sets the current_arc_agent_version of this ArcAgentNodes.
        Current Arc Agent Version installed on this node of VM Cluster.


        :param current_arc_agent_version: The current_arc_agent_version of this ArcAgentNodes.
        :type: str
        """
        self._current_arc_agent_version = current_arc_agent_version

    @property
    def status(self):
        """
        Gets the status of this ArcAgentNodes.
        The current status of the Azure Arc Agent Resource.

        Allowed values for this property are: "CONNECTED", "DISCONNECTED", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ArcAgentNodes.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ArcAgentNodes.
        The current status of the Azure Arc Agent Resource.


        :param status: The status of this ArcAgentNodes.
        :type: str
        """
        allowed_values = ["CONNECTED", "DISCONNECTED", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_last_checked(self):
        """
        Gets the time_last_checked of this ArcAgentNodes.
        time when the Azure Arc Agent's status was checked `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_checked of this ArcAgentNodes.
        :rtype: datetime
        """
        return self._time_last_checked

    @time_last_checked.setter
    def time_last_checked(self, time_last_checked):
        """
        Sets the time_last_checked of this ArcAgentNodes.
        time when the Azure Arc Agent's status was checked `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_checked: The time_last_checked of this ArcAgentNodes.
        :type: datetime
        """
        self._time_last_checked = time_last_checked

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
