# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOracleDbAzureVaultDetails(object):
    """
    This object is about to provide input params to create DB Azure Vault.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOracleDbAzureVaultDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOracleDbAzureVaultDetails.
        :type compartment_id: str

        :param oracle_db_connector_id:
            The value to assign to the oracle_db_connector_id property of this CreateOracleDbAzureVaultDetails.
        :type oracle_db_connector_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateOracleDbAzureVaultDetails.
        :type display_name: str

        :param oracle_db_azure_resource_group:
            The value to assign to the oracle_db_azure_resource_group property of this CreateOracleDbAzureVaultDetails.
        :type oracle_db_azure_resource_group: str

        :param azure_vault_id:
            The value to assign to the azure_vault_id property of this CreateOracleDbAzureVaultDetails.
        :type azure_vault_id: str

        :param type:
            The value to assign to the type property of this CreateOracleDbAzureVaultDetails.
        :type type: str

        :param location:
            The value to assign to the location property of this CreateOracleDbAzureVaultDetails.
        :type location: str

        :param properties:
            The value to assign to the properties property of this CreateOracleDbAzureVaultDetails.
        :type properties: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOracleDbAzureVaultDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOracleDbAzureVaultDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'oracle_db_connector_id': 'str',
            'display_name': 'str',
            'oracle_db_azure_resource_group': 'str',
            'azure_vault_id': 'str',
            'type': 'str',
            'location': 'str',
            'properties': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'oracle_db_connector_id': 'oracleDbConnectorId',
            'display_name': 'displayName',
            'oracle_db_azure_resource_group': 'oracleDbAzureResourceGroup',
            'azure_vault_id': 'azureVaultId',
            'type': 'type',
            'location': 'location',
            'properties': 'properties',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._oracle_db_connector_id = None
        self._display_name = None
        self._oracle_db_azure_resource_group = None
        self._azure_vault_id = None
        self._type = None
        self._location = None
        self._properties = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOracleDbAzureVaultDetails.
        The `OCID`__ of the compartment that contains DB Azure Vault Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOracleDbAzureVaultDetails.
        The `OCID`__ of the compartment that contains DB Azure Vault Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def oracle_db_connector_id(self):
        """
        **[Required]** Gets the oracle_db_connector_id of this CreateOracleDbAzureVaultDetails.
        The `OCID`__ of the DB Connector Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_connector_id of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._oracle_db_connector_id

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, oracle_db_connector_id):
        """
        Sets the oracle_db_connector_id of this CreateOracleDbAzureVaultDetails.
        The `OCID`__ of the DB Connector Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_connector_id: The oracle_db_connector_id of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._oracle_db_connector_id = oracle_db_connector_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOracleDbAzureVaultDetails.
        Display name of DB Azure Vault.


        :return: The display_name of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOracleDbAzureVaultDetails.
        Display name of DB Azure Vault.


        :param display_name: The display_name of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def oracle_db_azure_resource_group(self):
        """
        Gets the oracle_db_azure_resource_group of this CreateOracleDbAzureVaultDetails.
        Display name of Azure Resource Group.


        :return: The oracle_db_azure_resource_group of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._oracle_db_azure_resource_group

    @oracle_db_azure_resource_group.setter
    def oracle_db_azure_resource_group(self, oracle_db_azure_resource_group):
        """
        Sets the oracle_db_azure_resource_group of this CreateOracleDbAzureVaultDetails.
        Display name of Azure Resource Group.


        :param oracle_db_azure_resource_group: The oracle_db_azure_resource_group of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._oracle_db_azure_resource_group = oracle_db_azure_resource_group

    @property
    def azure_vault_id(self):
        """
        Gets the azure_vault_id of this CreateOracleDbAzureVaultDetails.
        Azure Vault Id.


        :return: The azure_vault_id of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._azure_vault_id

    @azure_vault_id.setter
    def azure_vault_id(self, azure_vault_id):
        """
        Sets the azure_vault_id of this CreateOracleDbAzureVaultDetails.
        Azure Vault Id.


        :param azure_vault_id: The azure_vault_id of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._azure_vault_id = azure_vault_id

    @property
    def type(self):
        """
        Gets the type of this CreateOracleDbAzureVaultDetails.
        Vault Resource Type.


        :return: The type of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateOracleDbAzureVaultDetails.
        Vault Resource Type.


        :param type: The type of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this CreateOracleDbAzureVaultDetails.
        Vault Resource Location.


        :return: The location of this CreateOracleDbAzureVaultDetails.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this CreateOracleDbAzureVaultDetails.
        Vault Resource Location.


        :param location: The location of this CreateOracleDbAzureVaultDetails.
        :type: str
        """
        self._location = location

    @property
    def properties(self):
        """
        Gets the properties of this CreateOracleDbAzureVaultDetails.
        Resource's properties.


        :return: The properties of this CreateOracleDbAzureVaultDetails.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CreateOracleDbAzureVaultDetails.
        Resource's properties.


        :param properties: The properties of this CreateOracleDbAzureVaultDetails.
        :type: dict(str, str)
        """
        self._properties = properties

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOracleDbAzureVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateOracleDbAzureVaultDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOracleDbAzureVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateOracleDbAzureVaultDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOracleDbAzureVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateOracleDbAzureVaultDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOracleDbAzureVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateOracleDbAzureVaultDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
