# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbAzureKeySummary(object):
    """
    Oracle DB Azure Key Resource Summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbAzureKeySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbAzureKeySummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbAzureKeySummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbAzureKeySummary.
        :type compartment_id: str

        :param azure_key_id:
            The value to assign to the azure_key_id property of this OracleDbAzureKeySummary.
        :type azure_key_id: str

        :param oracle_db_azure_vault_id:
            The value to assign to the oracle_db_azure_vault_id property of this OracleDbAzureKeySummary.
        :type oracle_db_azure_vault_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbAzureKeySummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbAzureKeySummary.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbAzureKeySummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbAzureKeySummary.
        :type time_updated: datetime

        :param last_modification:
            The value to assign to the last_modification property of this OracleDbAzureKeySummary.
        :type last_modification: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbAzureKeySummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbAzureKeySummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbAzureKeySummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'azure_key_id': 'str',
            'oracle_db_azure_vault_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'last_modification': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'azure_key_id': 'azureKeyId',
            'oracle_db_azure_vault_id': 'oracleDbAzureVaultId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'last_modification': 'lastModification',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._azure_key_id = None
        self._oracle_db_azure_vault_id = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._last_modification = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        Gets the id of this OracleDbAzureKeySummary.
        The `OCID`__ for the Oracle DB Azure Vault Key.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbAzureKeySummary.
        The `OCID`__ for the Oracle DB Azure Vault Key.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbAzureKeySummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbAzureKeySummary.
        Oracle DB Azure Vault Key resource name.


        :return: The display_name of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbAzureKeySummary.
        Oracle DB Azure Vault Key resource name.


        :param display_name: The display_name of this OracleDbAzureKeySummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this OracleDbAzureKeySummary.
        The `OCID`__ of the compartment contains Oracle DB Azure Vault Key Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbAzureKeySummary.
        The `OCID`__ of the compartment contains Oracle DB Azure Vault Key Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbAzureKeySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def azure_key_id(self):
        """
        Gets the azure_key_id of this OracleDbAzureKeySummary.
        The Azure ID of the Azure Key, Azure Key URL.


        :return: The azure_key_id of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._azure_key_id

    @azure_key_id.setter
    def azure_key_id(self, azure_key_id):
        """
        Sets the azure_key_id of this OracleDbAzureKeySummary.
        The Azure ID of the Azure Key, Azure Key URL.


        :param azure_key_id: The azure_key_id of this OracleDbAzureKeySummary.
        :type: str
        """
        self._azure_key_id = azure_key_id

    @property
    def oracle_db_azure_vault_id(self):
        """
        Gets the oracle_db_azure_vault_id of this OracleDbAzureKeySummary.
        The `OCID`__ of the Oracle DB Azure Vault Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_azure_vault_id of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._oracle_db_azure_vault_id

    @oracle_db_azure_vault_id.setter
    def oracle_db_azure_vault_id(self, oracle_db_azure_vault_id):
        """
        Sets the oracle_db_azure_vault_id of this OracleDbAzureKeySummary.
        The `OCID`__ of the Oracle DB Azure Vault Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_azure_vault_id: The oracle_db_azure_vault_id of this OracleDbAzureKeySummary.
        :type: str
        """
        self._oracle_db_azure_vault_id = oracle_db_azure_vault_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbAzureKeySummary.
        The current lifecycle state of the Oracle DB Azure Vault Key Resource.


        :return: The lifecycle_state of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbAzureKeySummary.
        The current lifecycle state of the Oracle DB Azure Vault Key Resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbAzureKeySummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbAzureKeySummary.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbAzureKeySummary.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbAzureKeySummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbAzureKeySummary.
        Time when the Oracle DB Azure Vault Key was created in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbAzureKeySummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbAzureKeySummary.
        Time when the Oracle DB Azure Vault Key was created in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbAzureKeySummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbAzureKeySummary.
        Time when the Oracle DB Azure Vault Key was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbAzureKeySummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbAzureKeySummary.
        Time when the Oracle DB Azure Vault Key was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbAzureKeySummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def last_modification(self):
        """
        Gets the last_modification of this OracleDbAzureKeySummary.
        Description of the latest modification of the Oracle DB Azure Vault Resource.


        :return: The last_modification of this OracleDbAzureKeySummary.
        :rtype: str
        """
        return self._last_modification

    @last_modification.setter
    def last_modification(self, last_modification):
        """
        Sets the last_modification of this OracleDbAzureKeySummary.
        Description of the latest modification of the Oracle DB Azure Vault Resource.


        :param last_modification: The last_modification of this OracleDbAzureKeySummary.
        :type: str
        """
        self._last_modification = last_modification

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbAzureKeySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbAzureKeySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbAzureKeySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbAzureKeySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbAzureKeySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbAzureKeySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbAzureKeySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbAzureKeySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbAzureKeySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbAzureKeySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbAzureKeySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbAzureKeySummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
