# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Resources(object):
    """
    Discovered Resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Resources object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Resources.
        :type id: str

        :param name:
            The value to assign to the name property of this Resources.
        :type name: str

        :param resource_group:
            The value to assign to the resource_group property of this Resources.
        :type resource_group: str

        :param type:
            The value to assign to the type property of this Resources.
        :type type: str

        :param location:
            The value to assign to the location property of this Resources.
        :type location: str

        :param properties:
            The value to assign to the properties property of this Resources.
        :type properties: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'resource_group': 'str',
            'type': 'str',
            'location': 'str',
            'properties': 'dict(str, str)'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'resource_group': 'resourceGroup',
            'type': 'type',
            'location': 'location',
            'properties': 'properties'
        }
        self._id = None
        self._name = None
        self._resource_group = None
        self._type = None
        self._location = None
        self._properties = None

    @property
    def id(self):
        """
        Gets the id of this Resources.
        The `OCID`__ of the Discovered Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this Resources.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Resources.
        The `OCID`__ of the Discovered Resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this Resources.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Resources.
        Discovered Resource Name.


        :return: The name of this Resources.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Resources.
        Discovered Resource Name.


        :param name: The name of this Resources.
        :type: str
        """
        self._name = name

    @property
    def resource_group(self):
        """
        Gets the resource_group of this Resources.
        Discovered Resource Group Name.


        :return: The resource_group of this Resources.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this Resources.
        Discovered Resource Group Name.


        :param resource_group: The resource_group of this Resources.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def type(self):
        """
        Gets the type of this Resources.
        Discovered Resource Type.


        :return: The type of this Resources.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Resources.
        Discovered Resource Type.


        :param type: The type of this Resources.
        :type: str
        """
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this Resources.
        Discovered Resource Location.


        :return: The location of this Resources.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this Resources.
        Discovered Resource Location.


        :param location: The location of this Resources.
        :type: str
        """
        self._location = location

    @property
    def properties(self):
        """
        Gets the properties of this Resources.
        Discovered Resource's properties.


        :return: The properties of this Resources.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this Resources.
        Discovered Resource's properties.


        :param properties: The properties of this Resources.
        :type: dict(str, str)
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
