# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOracleDbAzureBlobContainerDetails(object):
    """
    This object is about to provide input params to update Oracle DB Azure Blob Container.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOracleDbAzureBlobContainerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this UpdateOracleDbAzureBlobContainerDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UpdateOracleDbAzureBlobContainerDetails.
        :type display_name: str

        :param private_endpoint_ip_address:
            The value to assign to the private_endpoint_ip_address property of this UpdateOracleDbAzureBlobContainerDetails.
        :type private_endpoint_ip_address: str

        :param private_endpoint_dns_alias:
            The value to assign to the private_endpoint_dns_alias property of this UpdateOracleDbAzureBlobContainerDetails.
        :type private_endpoint_dns_alias: str

        :param azure_storage_account_name:
            The value to assign to the azure_storage_account_name property of this UpdateOracleDbAzureBlobContainerDetails.
        :type azure_storage_account_name: str

        :param azure_storage_container_name:
            The value to assign to the azure_storage_container_name property of this UpdateOracleDbAzureBlobContainerDetails.
        :type azure_storage_container_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOracleDbAzureBlobContainerDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOracleDbAzureBlobContainerDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'private_endpoint_ip_address': 'str',
            'private_endpoint_dns_alias': 'str',
            'azure_storage_account_name': 'str',
            'azure_storage_container_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'private_endpoint_ip_address': 'privateEndpointIpAddress',
            'private_endpoint_dns_alias': 'privateEndpointDnsAlias',
            'azure_storage_account_name': 'azureStorageAccountName',
            'azure_storage_container_name': 'azureStorageContainerName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._private_endpoint_ip_address = None
        self._private_endpoint_dns_alias = None
        self._azure_storage_account_name = None
        self._azure_storage_container_name = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this UpdateOracleDbAzureBlobContainerDetails.
        The OCID of the compartment that contains Oracle DB Azure Blob Container Resource.


        :return: The compartment_id of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UpdateOracleDbAzureBlobContainerDetails.
        The OCID of the compartment that contains Oracle DB Azure Blob Container Resource.


        :param compartment_id: The compartment_id of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOracleDbAzureBlobContainerDetails.
        Display name of Oracle DB Azure Blob Container Resource.


        :return: The display_name of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOracleDbAzureBlobContainerDetails.
        Display name of Oracle DB Azure Blob Container Resource.


        :param display_name: The display_name of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def private_endpoint_ip_address(self):
        """
        Gets the private_endpoint_ip_address of this UpdateOracleDbAzureBlobContainerDetails.
        Private endpoint IP.


        :return: The private_endpoint_ip_address of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._private_endpoint_ip_address

    @private_endpoint_ip_address.setter
    def private_endpoint_ip_address(self, private_endpoint_ip_address):
        """
        Sets the private_endpoint_ip_address of this UpdateOracleDbAzureBlobContainerDetails.
        Private endpoint IP.


        :param private_endpoint_ip_address: The private_endpoint_ip_address of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._private_endpoint_ip_address = private_endpoint_ip_address

    @property
    def private_endpoint_dns_alias(self):
        """
        Gets the private_endpoint_dns_alias of this UpdateOracleDbAzureBlobContainerDetails.
        Private endpoint DNS Alias.


        :return: The private_endpoint_dns_alias of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._private_endpoint_dns_alias

    @private_endpoint_dns_alias.setter
    def private_endpoint_dns_alias(self, private_endpoint_dns_alias):
        """
        Sets the private_endpoint_dns_alias of this UpdateOracleDbAzureBlobContainerDetails.
        Private endpoint DNS Alias.


        :param private_endpoint_dns_alias: The private_endpoint_dns_alias of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._private_endpoint_dns_alias = private_endpoint_dns_alias

    @property
    def azure_storage_account_name(self):
        """
        Gets the azure_storage_account_name of this UpdateOracleDbAzureBlobContainerDetails.
        Azure Storage Account Name.


        :return: The azure_storage_account_name of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._azure_storage_account_name

    @azure_storage_account_name.setter
    def azure_storage_account_name(self, azure_storage_account_name):
        """
        Sets the azure_storage_account_name of this UpdateOracleDbAzureBlobContainerDetails.
        Azure Storage Account Name.


        :param azure_storage_account_name: The azure_storage_account_name of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._azure_storage_account_name = azure_storage_account_name

    @property
    def azure_storage_container_name(self):
        """
        Gets the azure_storage_container_name of this UpdateOracleDbAzureBlobContainerDetails.
        Azure Storage Container Name.


        :return: The azure_storage_container_name of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: str
        """
        return self._azure_storage_container_name

    @azure_storage_container_name.setter
    def azure_storage_container_name(self, azure_storage_container_name):
        """
        Sets the azure_storage_container_name of this UpdateOracleDbAzureBlobContainerDetails.
        Azure Storage Container Name.


        :param azure_storage_container_name: The azure_storage_container_name of this UpdateOracleDbAzureBlobContainerDetails.
        :type: str
        """
        self._azure_storage_container_name = azure_storage_container_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOracleDbAzureBlobContainerDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOracleDbAzureBlobContainerDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateOracleDbAzureBlobContainerDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOracleDbAzureBlobContainerDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateOracleDbAzureBlobContainerDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOracleDbAzureBlobContainerDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateOracleDbAzureBlobContainerDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
