# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericArtifactLocationDetails(object):
    """
    Location where artifact is uploaded for user access.
    """

    #: A constant which can be used with the storage_type property of a GenericArtifactLocationDetails.
    #: This constant has a value of "OBJECT_STORAGE"
    STORAGE_TYPE_OBJECT_STORAGE = "OBJECT_STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new GenericArtifactLocationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.devops.models.ObjectStorageGenericArtifactLocationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this GenericArtifactLocationDetails.
            Allowed values for this property are: "OBJECT_STORAGE"
        :type storage_type: str

        """
        self.swagger_types = {
            'storage_type': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType'
        }
        self._storage_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['storageType']

        if type == 'OBJECT_STORAGE':
            return 'ObjectStorageGenericArtifactLocationDetails'
        else:
            return 'GenericArtifactLocationDetails'

    @property
    def storage_type(self):
        """
        **[Required]** Gets the storage_type of this GenericArtifactLocationDetails.
        Storage source like ObjectStorage, etc.

        Allowed values for this property are: "OBJECT_STORAGE"


        :return: The storage_type of this GenericArtifactLocationDetails.
        :rtype: str
        """
        return self._storage_type

    @storage_type.setter
    def storage_type(self, storage_type):
        """
        Sets the storage_type of this GenericArtifactLocationDetails.
        Storage source like ObjectStorage, etc.


        :param storage_type: The storage_type of this GenericArtifactLocationDetails.
        :type: str
        """
        allowed_values = ["OBJECT_STORAGE"]
        if not value_allowed_none_or_none_sentinel(storage_type, allowed_values):
            raise ValueError(
                f"Invalid value for `storage_type`, must be None or one of {allowed_values}"
            )
        self._storage_type = storage_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
