# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .generic_artifact_location_details import GenericArtifactLocationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageGenericArtifactLocationDetails(GenericArtifactLocationDetails):
    """
    ObjectStorage bucket details where artifact is located.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageGenericArtifactLocationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.ObjectStorageGenericArtifactLocationDetails.storage_type` attribute
        of this class is ``OBJECT_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this ObjectStorageGenericArtifactLocationDetails.
            Allowed values for this property are: "OBJECT_STORAGE"
        :type storage_type: str

        :param namespace:
            The value to assign to the namespace property of this ObjectStorageGenericArtifactLocationDetails.
        :type namespace: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorageGenericArtifactLocationDetails.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this ObjectStorageGenericArtifactLocationDetails.
        :type object_name: str

        :param region:
            The value to assign to the region property of this ObjectStorageGenericArtifactLocationDetails.
        :type region: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'namespace': 'str',
            'bucket_name': 'str',
            'object_name': 'str',
            'region': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType',
            'namespace': 'namespace',
            'bucket_name': 'bucketName',
            'object_name': 'objectName',
            'region': 'region'
        }
        self._storage_type = None
        self._namespace = None
        self._bucket_name = None
        self._object_name = None
        self._region = None
        self._storage_type = 'OBJECT_STORAGE'

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ObjectStorageGenericArtifactLocationDetails.
        Unique namespace in the tenancy which contains the bucket


        :return: The namespace of this ObjectStorageGenericArtifactLocationDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ObjectStorageGenericArtifactLocationDetails.
        Unique namespace in the tenancy which contains the bucket


        :param namespace: The namespace of this ObjectStorageGenericArtifactLocationDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ObjectStorageGenericArtifactLocationDetails.
        Specifies the Object Storage bucket.


        :return: The bucket_name of this ObjectStorageGenericArtifactLocationDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorageGenericArtifactLocationDetails.
        Specifies the Object Storage bucket.


        :param bucket_name: The bucket_name of this ObjectStorageGenericArtifactLocationDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this ObjectStorageGenericArtifactLocationDetails.
        Specifies the name of object inside the bucket.


        :return: The object_name of this ObjectStorageGenericArtifactLocationDetails.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this ObjectStorageGenericArtifactLocationDetails.
        Specifies the name of object inside the bucket.


        :param object_name: The object_name of this ObjectStorageGenericArtifactLocationDetails.
        :type: str
        """
        self._object_name = object_name

    @property
    def region(self):
        """
        **[Required]** Gets the region of this ObjectStorageGenericArtifactLocationDetails.
        Region identifier.


        :return: The region of this ObjectStorageGenericArtifactLocationDetails.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this ObjectStorageGenericArtifactLocationDetails.
        Region identifier.


        :param region: The region of this ObjectStorageGenericArtifactLocationDetails.
        :type: str
        """
        self._region = region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
