# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanStep(object):
    """
    Details of a step in a DR plan.
    """

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_STOP_PRECHECK"
    TYPE_COMPUTE_INSTANCE_STOP_PRECHECK = "COMPUTE_INSTANCE_STOP_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_LAUNCH_PRECHECK"
    TYPE_COMPUTE_INSTANCE_LAUNCH_PRECHECK = "COMPUTE_INSTANCE_LAUNCH_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_TERMINATE_PRECHECK"
    TYPE_COMPUTE_INSTANCE_TERMINATE_PRECHECK = "COMPUTE_INSTANCE_TERMINATE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_REMOVE_PRECHECK"
    TYPE_COMPUTE_INSTANCE_REMOVE_PRECHECK = "COMPUTE_INSTANCE_REMOVE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK"
    TYPE_VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK = "VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK"
    TYPE_VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK = "VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_SWITCHOVER_PRECHECK"
    TYPE_DATABASE_SWITCHOVER_PRECHECK = "DATABASE_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_FAILOVER_PRECHECK"
    TYPE_DATABASE_FAILOVER_PRECHECK = "DATABASE_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK = "AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_FAILOVER_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_FAILOVER_PRECHECK = "AUTONOMOUS_DATABASE_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK = "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK = "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK = "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK = "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER = "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_FAILOVER = "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY = "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"
    TYPE_AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY = "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK = "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK = "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK = "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK = "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY"
    TYPE_AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY = "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY"
    TYPE_AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY = "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"
    TYPE_AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY = "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"
    TYPE_AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY = "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"
    TYPE_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK = "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"
    TYPE_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK = "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"
    TYPE_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY = "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"
    TYPE_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY = "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "USER_DEFINED_PRECHECK"
    TYPE_USER_DEFINED_PRECHECK = "USER_DEFINED_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_LAUNCH"
    TYPE_COMPUTE_INSTANCE_LAUNCH = "COMPUTE_INSTANCE_LAUNCH"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_STOP"
    TYPE_COMPUTE_INSTANCE_STOP = "COMPUTE_INSTANCE_STOP"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_TERMINATE"
    TYPE_COMPUTE_INSTANCE_TERMINATE = "COMPUTE_INSTANCE_TERMINATE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_REMOVE"
    TYPE_COMPUTE_INSTANCE_REMOVE = "COMPUTE_INSTANCE_REMOVE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_SWITCHOVER"
    TYPE_DATABASE_SWITCHOVER = "DATABASE_SWITCHOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "DATABASE_FAILOVER"
    TYPE_DATABASE_FAILOVER = "DATABASE_FAILOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_SWITCHOVER"
    TYPE_AUTONOMOUS_DATABASE_SWITCHOVER = "AUTONOMOUS_DATABASE_SWITCHOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_FAILOVER"
    TYPE_AUTONOMOUS_DATABASE_FAILOVER = "AUTONOMOUS_DATABASE_FAILOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_SWITCHOVER"
    TYPE_VOLUME_GROUP_RESTORE_SWITCHOVER = "VOLUME_GROUP_RESTORE_SWITCHOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_FAILOVER"
    TYPE_VOLUME_GROUP_RESTORE_FAILOVER = "VOLUME_GROUP_RESTORE_FAILOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_REVERSE"
    TYPE_VOLUME_GROUP_REVERSE = "VOLUME_GROUP_REVERSE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_DELETE"
    TYPE_VOLUME_GROUP_DELETE = "VOLUME_GROUP_DELETE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_REMOVE"
    TYPE_VOLUME_GROUP_REMOVE = "VOLUME_GROUP_REMOVE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_TERMINATE"
    TYPE_VOLUME_GROUP_TERMINATE = "VOLUME_GROUP_TERMINATE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "USER_DEFINED"
    TYPE_USER_DEFINED = "USER_DEFINED"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "USER_DEFINED_CUSTOM_PRECHECK"
    TYPE_USER_DEFINED_CUSTOM_PRECHECK = "USER_DEFINED_CUSTOM_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK"
    TYPE_VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK = "VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_REMOVE_PRECHECK"
    TYPE_VOLUME_GROUP_REMOVE_PRECHECK = "VOLUME_GROUP_REMOVE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_TERMINATE_PRECHECK"
    TYPE_VOLUME_GROUP_TERMINATE_PRECHECK = "VOLUME_GROUP_TERMINATE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "VOLUME_GROUP_RESTORE_START_DRILL"
    TYPE_VOLUME_GROUP_RESTORE_START_DRILL = "VOLUME_GROUP_RESTORE_START_DRILL"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK = "AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK"
    TYPE_AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK = "AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK"
    TYPE_LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK = "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK"
    TYPE_LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK = "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_SWITCHOVER_PRECHECK"
    TYPE_FILE_SYSTEM_SWITCHOVER_PRECHECK = "FILE_SYSTEM_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_FAILOVER_PRECHECK"
    TYPE_FILE_SYSTEM_FAILOVER_PRECHECK = "FILE_SYSTEM_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_START_DRILL_PRECHECK"
    TYPE_FILE_SYSTEM_START_DRILL_PRECHECK = "FILE_SYSTEM_START_DRILL_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_STOP_DRILL_PRECHECK"
    TYPE_FILE_SYSTEM_STOP_DRILL_PRECHECK = "FILE_SYSTEM_STOP_DRILL_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_REMOVE_PRECHECK"
    TYPE_FILE_SYSTEM_REMOVE_PRECHECK = "FILE_SYSTEM_REMOVE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_TERMINATE_PRECHECK"
    TYPE_FILE_SYSTEM_TERMINATE_PRECHECK = "FILE_SYSTEM_TERMINATE_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_MOUNT_PRECHECK"
    TYPE_FILE_SYSTEM_MOUNT_PRECHECK = "FILE_SYSTEM_MOUNT_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_UNMOUNT_PRECHECK"
    TYPE_FILE_SYSTEM_UNMOUNT_PRECHECK = "FILE_SYSTEM_UNMOUNT_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_START_PRECHECK"
    TYPE_COMPUTE_INSTANCE_START_PRECHECK = "COMPUTE_INSTANCE_START_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK"
    TYPE_COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK = "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK"
    TYPE_COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK = "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK"
    TYPE_COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK = "COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK"
    TYPE_COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK = "COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK"
    TYPE_COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK = "COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK"
    TYPE_COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK = "COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_CREATE_CLONE"
    TYPE_AUTONOMOUS_DATABASE_CREATE_CLONE = "AUTONOMOUS_DATABASE_CREATE_CLONE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "AUTONOMOUS_DATABASE_DELETE_CLONE"
    TYPE_AUTONOMOUS_DATABASE_DELETE_CLONE = "AUTONOMOUS_DATABASE_DELETE_CLONE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET"
    TYPE_LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET = "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET"
    TYPE_LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET = "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_SWITCHOVER"
    TYPE_FILE_SYSTEM_SWITCHOVER = "FILE_SYSTEM_SWITCHOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_FAILOVER"
    TYPE_FILE_SYSTEM_FAILOVER = "FILE_SYSTEM_FAILOVER"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_REMOVE"
    TYPE_FILE_SYSTEM_REMOVE = "FILE_SYSTEM_REMOVE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_REVERSE"
    TYPE_FILE_SYSTEM_REVERSE = "FILE_SYSTEM_REVERSE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_TERMINATE"
    TYPE_FILE_SYSTEM_TERMINATE = "FILE_SYSTEM_TERMINATE"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_START_DRILL"
    TYPE_FILE_SYSTEM_START_DRILL = "FILE_SYSTEM_START_DRILL"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_STOP_DRILL"
    TYPE_FILE_SYSTEM_STOP_DRILL = "FILE_SYSTEM_STOP_DRILL"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_START"
    TYPE_COMPUTE_INSTANCE_START = "COMPUTE_INSTANCE_START"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES"
    TYPE_COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES = "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES"
    TYPE_COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES = "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_MOUNT"
    TYPE_FILE_SYSTEM_MOUNT = "FILE_SYSTEM_MOUNT"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "FILE_SYSTEM_UNMOUNT"
    TYPE_FILE_SYSTEM_UNMOUNT = "FILE_SYSTEM_UNMOUNT"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK"
    TYPE_COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK = "COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK"
    TYPE_COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK = "COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK"
    TYPE_COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK = "COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK"
    TYPE_COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK = "COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK"
    TYPE_OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK = "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK"
    TYPE_OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK = "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK"
    TYPE_OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK = "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK"
    TYPE_OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK = "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK"
    TYPE_OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK = "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY"
    TYPE_OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY = "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY"
    TYPE_OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY = "OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY"
    TYPE_OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY = "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY"
    TYPE_OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY = "OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY"
    TYPE_OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY = "OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY"
    TYPE_OKE_CLUSTER_FAILOVER_RESTORE_STANDBY = "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY"
    TYPE_OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY = "OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY"
    TYPE_OKE_CLUSTER_START_DRILL_RESTORE_STANDBY = "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY"
    TYPE_OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY = "OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY"
    TYPE_OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY = "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY"
    TYPE_OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY = "OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK"
    TYPE_OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK = "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK"
    TYPE_OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK = "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK"
    TYPE_OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK = "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK"
    TYPE_OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK = "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY"
    TYPE_OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY = "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY"
    TYPE_OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY = "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY"
    TYPE_OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY = "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY"

    #: A constant which can be used with the type property of a DrPlanStep.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY"
    TYPE_OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY = "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY"

    #: A constant which can be used with the refresh_status property of a DrPlanStep.
    #: This constant has a value of "STEP_ADDED"
    REFRESH_STATUS_STEP_ADDED = "STEP_ADDED"

    #: A constant which can be used with the refresh_status property of a DrPlanStep.
    #: This constant has a value of "STEP_DELETED"
    REFRESH_STATUS_STEP_DELETED = "STEP_DELETED"

    #: A constant which can be used with the error_mode property of a DrPlanStep.
    #: This constant has a value of "STOP_ON_ERROR"
    ERROR_MODE_STOP_ON_ERROR = "STOP_ON_ERROR"

    #: A constant which can be used with the error_mode property of a DrPlanStep.
    #: This constant has a value of "CONTINUE_ON_ERROR"
    ERROR_MODE_CONTINUE_ON_ERROR = "CONTINUE_ON_ERROR"

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanStep object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DrPlanStep.
        :type id: str

        :param group_id:
            The value to assign to the group_id property of this DrPlanStep.
        :type group_id: str

        :param member_id:
            The value to assign to the member_id property of this DrPlanStep.
        :type member_id: str

        :param type:
            The value to assign to the type property of this DrPlanStep.
            Allowed values for this property are: "COMPUTE_INSTANCE_STOP_PRECHECK", "COMPUTE_INSTANCE_LAUNCH_PRECHECK", "COMPUTE_INSTANCE_TERMINATE_PRECHECK", "COMPUTE_INSTANCE_REMOVE_PRECHECK", "VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK", "VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK", "DATABASE_SWITCHOVER_PRECHECK", "DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "USER_DEFINED_PRECHECK", "COMPUTE_INSTANCE_LAUNCH", "COMPUTE_INSTANCE_STOP", "COMPUTE_INSTANCE_TERMINATE", "COMPUTE_INSTANCE_REMOVE", "DATABASE_SWITCHOVER", "DATABASE_FAILOVER", "AUTONOMOUS_DATABASE_SWITCHOVER", "AUTONOMOUS_DATABASE_FAILOVER", "VOLUME_GROUP_RESTORE_SWITCHOVER", "VOLUME_GROUP_RESTORE_FAILOVER", "VOLUME_GROUP_REVERSE", "VOLUME_GROUP_DELETE", "VOLUME_GROUP_REMOVE", "VOLUME_GROUP_TERMINATE", "USER_DEFINED", "USER_DEFINED_CUSTOM_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK", "VOLUME_GROUP_REMOVE_PRECHECK", "VOLUME_GROUP_TERMINATE_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL", "AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK", "AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK", "FILE_SYSTEM_SWITCHOVER_PRECHECK", "FILE_SYSTEM_FAILOVER_PRECHECK", "FILE_SYSTEM_START_DRILL_PRECHECK", "FILE_SYSTEM_STOP_DRILL_PRECHECK", "FILE_SYSTEM_REMOVE_PRECHECK", "FILE_SYSTEM_TERMINATE_PRECHECK", "FILE_SYSTEM_MOUNT_PRECHECK", "FILE_SYSTEM_UNMOUNT_PRECHECK", "COMPUTE_INSTANCE_START_PRECHECK", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK", "AUTONOMOUS_DATABASE_CREATE_CLONE", "AUTONOMOUS_DATABASE_DELETE_CLONE", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET", "FILE_SYSTEM_SWITCHOVER", "FILE_SYSTEM_FAILOVER", "FILE_SYSTEM_REMOVE", "FILE_SYSTEM_REVERSE", "FILE_SYSTEM_TERMINATE", "FILE_SYSTEM_START_DRILL", "FILE_SYSTEM_STOP_DRILL", "COMPUTE_INSTANCE_START", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES", "FILE_SYSTEM_MOUNT", "FILE_SYSTEM_UNMOUNT", "COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY", "OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY", "OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY", "OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY", "OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY", "OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY", "OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param refresh_status:
            The value to assign to the refresh_status property of this DrPlanStep.
            Allowed values for this property are: "STEP_ADDED", "STEP_DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type refresh_status: str

        :param display_name:
            The value to assign to the display_name property of this DrPlanStep.
        :type display_name: str

        :param type_display_name:
            The value to assign to the type_display_name property of this DrPlanStep.
        :type type_display_name: str

        :param error_mode:
            The value to assign to the error_mode property of this DrPlanStep.
            Allowed values for this property are: "STOP_ON_ERROR", "CONTINUE_ON_ERROR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type error_mode: str

        :param timeout:
            The value to assign to the timeout property of this DrPlanStep.
        :type timeout: int

        :param is_enabled:
            The value to assign to the is_enabled property of this DrPlanStep.
        :type is_enabled: bool

        :param user_defined_step:
            The value to assign to the user_defined_step property of this DrPlanStep.
        :type user_defined_step: oci.disaster_recovery.models.DrPlanUserDefinedStep

        """
        self.swagger_types = {
            'id': 'str',
            'group_id': 'str',
            'member_id': 'str',
            'type': 'str',
            'refresh_status': 'str',
            'display_name': 'str',
            'type_display_name': 'str',
            'error_mode': 'str',
            'timeout': 'int',
            'is_enabled': 'bool',
            'user_defined_step': 'DrPlanUserDefinedStep'
        }
        self.attribute_map = {
            'id': 'id',
            'group_id': 'groupId',
            'member_id': 'memberId',
            'type': 'type',
            'refresh_status': 'refreshStatus',
            'display_name': 'displayName',
            'type_display_name': 'typeDisplayName',
            'error_mode': 'errorMode',
            'timeout': 'timeout',
            'is_enabled': 'isEnabled',
            'user_defined_step': 'userDefinedStep'
        }
        self._id = None
        self._group_id = None
        self._member_id = None
        self._type = None
        self._refresh_status = None
        self._display_name = None
        self._type_display_name = None
        self._error_mode = None
        self._timeout = None
        self._is_enabled = None
        self._user_defined_step = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DrPlanStep.
        The unique id of the step. Must not be modified by the user.

        Example: `sgid1.step..uniqueID`


        :return: The id of this DrPlanStep.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DrPlanStep.
        The unique id of the step. Must not be modified by the user.

        Example: `sgid1.step..uniqueID`


        :param id: The id of this DrPlanStep.
        :type: str
        """
        self._id = id

    @property
    def group_id(self):
        """
        **[Required]** Gets the group_id of this DrPlanStep.
        The unique id of the group to which this step belongs. Must not be modified by user.

        Example: `sgid1.group..uniqueID`


        :return: The group_id of this DrPlanStep.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this DrPlanStep.
        The unique id of the group to which this step belongs. Must not be modified by user.

        Example: `sgid1.group..uniqueID`


        :param group_id: The group_id of this DrPlanStep.
        :type: str
        """
        self._group_id = group_id

    @property
    def member_id(self):
        """
        Gets the member_id of this DrPlanStep.
        The OCID of the member associated with this step.

        Example: `ocid1.database.oc1..uniqueID`


        :return: The member_id of this DrPlanStep.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this DrPlanStep.
        The OCID of the member associated with this step.

        Example: `ocid1.database.oc1..uniqueID`


        :param member_id: The member_id of this DrPlanStep.
        :type: str
        """
        self._member_id = member_id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DrPlanStep.
        The plan step type.

        Allowed values for this property are: "COMPUTE_INSTANCE_STOP_PRECHECK", "COMPUTE_INSTANCE_LAUNCH_PRECHECK", "COMPUTE_INSTANCE_TERMINATE_PRECHECK", "COMPUTE_INSTANCE_REMOVE_PRECHECK", "VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK", "VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK", "DATABASE_SWITCHOVER_PRECHECK", "DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "USER_DEFINED_PRECHECK", "COMPUTE_INSTANCE_LAUNCH", "COMPUTE_INSTANCE_STOP", "COMPUTE_INSTANCE_TERMINATE", "COMPUTE_INSTANCE_REMOVE", "DATABASE_SWITCHOVER", "DATABASE_FAILOVER", "AUTONOMOUS_DATABASE_SWITCHOVER", "AUTONOMOUS_DATABASE_FAILOVER", "VOLUME_GROUP_RESTORE_SWITCHOVER", "VOLUME_GROUP_RESTORE_FAILOVER", "VOLUME_GROUP_REVERSE", "VOLUME_GROUP_DELETE", "VOLUME_GROUP_REMOVE", "VOLUME_GROUP_TERMINATE", "USER_DEFINED", "USER_DEFINED_CUSTOM_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK", "VOLUME_GROUP_REMOVE_PRECHECK", "VOLUME_GROUP_TERMINATE_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL", "AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK", "AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK", "FILE_SYSTEM_SWITCHOVER_PRECHECK", "FILE_SYSTEM_FAILOVER_PRECHECK", "FILE_SYSTEM_START_DRILL_PRECHECK", "FILE_SYSTEM_STOP_DRILL_PRECHECK", "FILE_SYSTEM_REMOVE_PRECHECK", "FILE_SYSTEM_TERMINATE_PRECHECK", "FILE_SYSTEM_MOUNT_PRECHECK", "FILE_SYSTEM_UNMOUNT_PRECHECK", "COMPUTE_INSTANCE_START_PRECHECK", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK", "AUTONOMOUS_DATABASE_CREATE_CLONE", "AUTONOMOUS_DATABASE_DELETE_CLONE", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET", "FILE_SYSTEM_SWITCHOVER", "FILE_SYSTEM_FAILOVER", "FILE_SYSTEM_REMOVE", "FILE_SYSTEM_REVERSE", "FILE_SYSTEM_TERMINATE", "FILE_SYSTEM_START_DRILL", "FILE_SYSTEM_STOP_DRILL", "COMPUTE_INSTANCE_START", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES", "FILE_SYSTEM_MOUNT", "FILE_SYSTEM_UNMOUNT", "COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY", "OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY", "OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY", "OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY", "OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY", "OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY", "OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this DrPlanStep.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DrPlanStep.
        The plan step type.


        :param type: The type of this DrPlanStep.
        :type: str
        """
        allowed_values = ["COMPUTE_INSTANCE_STOP_PRECHECK", "COMPUTE_INSTANCE_LAUNCH_PRECHECK", "COMPUTE_INSTANCE_TERMINATE_PRECHECK", "COMPUTE_INSTANCE_REMOVE_PRECHECK", "VOLUME_GROUP_RESTORE_SWITCHOVER_PRECHECK", "VOLUME_GROUP_RESTORE_FAILOVER_PRECHECK", "DATABASE_SWITCHOVER_PRECHECK", "DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_CONTAINER_DATABASE_SWITCHOVER", "AUTONOMOUS_CONTAINER_DATABASE_FAILOVER", "AUTONOMOUS_CONTAINER_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_CONTAINER_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "AUTONOMOUS_DATABASE_START_DRILL_CREATE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_DELETE_CLONE_STANDBY", "AUTONOMOUS_DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "AUTONOMOUS_DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY_PRECHECK", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY_PRECHECK", "DATABASE_START_DRILL_CONVERT_TO_SNAPSHOT_STANDBY", "DATABASE_STOP_DRILL_CONVERT_TO_PHYSICAL_STANDBY", "USER_DEFINED_PRECHECK", "COMPUTE_INSTANCE_LAUNCH", "COMPUTE_INSTANCE_STOP", "COMPUTE_INSTANCE_TERMINATE", "COMPUTE_INSTANCE_REMOVE", "DATABASE_SWITCHOVER", "DATABASE_FAILOVER", "AUTONOMOUS_DATABASE_SWITCHOVER", "AUTONOMOUS_DATABASE_FAILOVER", "VOLUME_GROUP_RESTORE_SWITCHOVER", "VOLUME_GROUP_RESTORE_FAILOVER", "VOLUME_GROUP_REVERSE", "VOLUME_GROUP_DELETE", "VOLUME_GROUP_REMOVE", "VOLUME_GROUP_TERMINATE", "USER_DEFINED", "USER_DEFINED_CUSTOM_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL_PRECHECK", "VOLUME_GROUP_REMOVE_PRECHECK", "VOLUME_GROUP_TERMINATE_PRECHECK", "VOLUME_GROUP_RESTORE_START_DRILL", "AUTONOMOUS_DATABASE_CREATE_CLONE_PRECHECK", "AUTONOMOUS_DATABASE_DELETE_CLONE_PRECHECK", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET_PRECHECK", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET_PRECHECK", "FILE_SYSTEM_SWITCHOVER_PRECHECK", "FILE_SYSTEM_FAILOVER_PRECHECK", "FILE_SYSTEM_START_DRILL_PRECHECK", "FILE_SYSTEM_STOP_DRILL_PRECHECK", "FILE_SYSTEM_REMOVE_PRECHECK", "FILE_SYSTEM_TERMINATE_PRECHECK", "FILE_SYSTEM_MOUNT_PRECHECK", "FILE_SYSTEM_UNMOUNT_PRECHECK", "COMPUTE_INSTANCE_START_PRECHECK", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_MOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_INSTANCE_UNMOUNT_BLOCK_VOLUMES_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_START_DRILL_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_START_DRILL_PRECHECK", "AUTONOMOUS_DATABASE_CREATE_CLONE", "AUTONOMOUS_DATABASE_DELETE_CLONE", "LOAD_BALANCER_UPDATE_PRIMARY_BACKEND_SET", "LOAD_BALANCER_UPDATE_STANDBY_BACKEND_SET", "FILE_SYSTEM_SWITCHOVER", "FILE_SYSTEM_FAILOVER", "FILE_SYSTEM_REMOVE", "FILE_SYSTEM_REVERSE", "FILE_SYSTEM_TERMINATE", "FILE_SYSTEM_START_DRILL", "FILE_SYSTEM_STOP_DRILL", "COMPUTE_INSTANCE_START", "COMPUTE_INSTANCE_ATTACH_BLOCK_VOLUMES", "COMPUTE_INSTANCE_DETACH_BLOCK_VOLUMES", "FILE_SYSTEM_MOUNT", "FILE_SYSTEM_UNMOUNT", "COMPUTE_CAPACITY_RESERVATION_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_RESERVATION_FAILOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_SWITCHOVER_PRECHECK", "COMPUTE_CAPACITY_AVAILABILITY_FAILOVER_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY_PRECHECK", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY_PRECHECK", "OKE_CLUSTER_SWITCHOVER_CLEANUP_PRIMARY", "OKE_CLUSTER_SWITCHOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_SWITCHOVER_RESTORE_STANDBY", "OKE_CLUSTER_SWITCHOVER_REVERSE_BACKUP_STANDBY", "OKE_CLUSTER_SWITCHOVER_SCALE_DOWN_PRIMARY", "OKE_CLUSTER_FAILOVER_RESTORE_STANDBY", "OKE_CLUSTER_FAILOVER_SCALE_UP_STANDBY", "OKE_CLUSTER_START_DRILL_RESTORE_STANDBY", "OKE_CLUSTER_START_DRILL_SCALE_UP_STANDBY", "OKE_CLUSTER_STOP_DRILL_CLEANUP_STANDBY", "OKE_CLUSTER_STOP_DRILL_SCALE_DOWN_STANDBY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY_PRECHECK", "OBJECT_STORAGE_BUCKET_SWITCHOVER_DELETE_REPLICATION_PRIMARY", "OBJECT_STORAGE_BUCKET_SWITCHOVER_SETUP_REVERSE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_DELETE_REPLICATION_STANDBY", "OBJECT_STORAGE_BUCKET_FAILOVER_SETUP_REVERSE_REPLICATION_STANDBY"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def refresh_status(self):
        """
        Gets the refresh_status of this DrPlanStep.
        The DR plan step refresh status.

        Example: `STEP_ADDED`

        Allowed values for this property are: "STEP_ADDED", "STEP_DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The refresh_status of this DrPlanStep.
        :rtype: str
        """
        return self._refresh_status

    @refresh_status.setter
    def refresh_status(self, refresh_status):
        """
        Sets the refresh_status of this DrPlanStep.
        The DR plan step refresh status.

        Example: `STEP_ADDED`


        :param refresh_status: The refresh_status of this DrPlanStep.
        :type: str
        """
        allowed_values = ["STEP_ADDED", "STEP_DELETED"]
        if not value_allowed_none_or_none_sentinel(refresh_status, allowed_values):
            refresh_status = 'UNKNOWN_ENUM_VALUE'
        self._refresh_status = refresh_status

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DrPlanStep.
        The display name of the group.

        Example: `DATABASE_SWITCHOVER`


        :return: The display_name of this DrPlanStep.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DrPlanStep.
        The display name of the group.

        Example: `DATABASE_SWITCHOVER`


        :param display_name: The display_name of this DrPlanStep.
        :type: str
        """
        self._display_name = display_name

    @property
    def type_display_name(self):
        """
        **[Required]** Gets the type_display_name of this DrPlanStep.
        The display name of the DR Plan step type.

        Example: `Database Switchover`


        :return: The type_display_name of this DrPlanStep.
        :rtype: str
        """
        return self._type_display_name

    @type_display_name.setter
    def type_display_name(self, type_display_name):
        """
        Sets the type_display_name of this DrPlanStep.
        The display name of the DR Plan step type.

        Example: `Database Switchover`


        :param type_display_name: The type_display_name of this DrPlanStep.
        :type: str
        """
        self._type_display_name = type_display_name

    @property
    def error_mode(self):
        """
        **[Required]** Gets the error_mode of this DrPlanStep.
        The error mode for this step.

        Allowed values for this property are: "STOP_ON_ERROR", "CONTINUE_ON_ERROR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The error_mode of this DrPlanStep.
        :rtype: str
        """
        return self._error_mode

    @error_mode.setter
    def error_mode(self, error_mode):
        """
        Sets the error_mode of this DrPlanStep.
        The error mode for this step.


        :param error_mode: The error_mode of this DrPlanStep.
        :type: str
        """
        allowed_values = ["STOP_ON_ERROR", "CONTINUE_ON_ERROR"]
        if not value_allowed_none_or_none_sentinel(error_mode, allowed_values):
            error_mode = 'UNKNOWN_ENUM_VALUE'
        self._error_mode = error_mode

    @property
    def timeout(self):
        """
        **[Required]** Gets the timeout of this DrPlanStep.
        The timeout in seconds for executing this step.

        Example: `600`


        :return: The timeout of this DrPlanStep.
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """
        Sets the timeout of this DrPlanStep.
        The timeout in seconds for executing this step.

        Example: `600`


        :param timeout: The timeout of this DrPlanStep.
        :type: int
        """
        self._timeout = timeout

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this DrPlanStep.
        A flag indicating whether this step should be enabled for execution.

        Example: `true`


        :return: The is_enabled of this DrPlanStep.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this DrPlanStep.
        A flag indicating whether this step should be enabled for execution.

        Example: `true`


        :param is_enabled: The is_enabled of this DrPlanStep.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def user_defined_step(self):
        """
        Gets the user_defined_step of this DrPlanStep.

        :return: The user_defined_step of this DrPlanStep.
        :rtype: oci.disaster_recovery.models.DrPlanUserDefinedStep
        """
        return self._user_defined_step

    @user_defined_step.setter
    def user_defined_step(self, user_defined_step):
        """
        Sets the user_defined_step of this DrPlanStep.

        :param user_defined_step: The user_defined_step of this DrPlanStep.
        :type: oci.disaster_recovery.models.DrPlanUserDefinedStep
        """
        self._user_defined_step = user_defined_step

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
