# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedAutonomousDatabaseGsmImage(object):
    """
    The Global service manager image details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedAutonomousDatabaseGsmImage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DistributedAutonomousDatabaseGsmImage.
        :type id: str

        :param version_number:
            The value to assign to the version_number property of this DistributedAutonomousDatabaseGsmImage.
        :type version_number: int

        """
        self.swagger_types = {
            'id': 'str',
            'version_number': 'int'
        }
        self.attribute_map = {
            'id': 'id',
            'version_number': 'versionNumber'
        }
        self._id = None
        self._version_number = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DistributedAutonomousDatabaseGsmImage.
        The `OCID`__ of the Global service manager software image.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DistributedAutonomousDatabaseGsmImage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DistributedAutonomousDatabaseGsmImage.
        The `OCID`__ of the Global service manager software image.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DistributedAutonomousDatabaseGsmImage.
        :type: str
        """
        self._id = id

    @property
    def version_number(self):
        """
        **[Required]** Gets the version_number of this DistributedAutonomousDatabaseGsmImage.
        The version number associated with the image identified by id.


        :return: The version_number of this DistributedAutonomousDatabaseGsmImage.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this DistributedAutonomousDatabaseGsmImage.
        The version number associated with the image identified by id.


        :param version_number: The version_number of this DistributedAutonomousDatabaseGsmImage.
        :type: int
        """
        self._version_number = version_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
