# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101

from .distributed_autonomous_database_shard import DistributedAutonomousDatabaseShard
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedAutonomousDatabaseShardWithDedicatedInfra(DistributedAutonomousDatabaseShard):
    """
    Globally distributed autonomous database shard with dedicated autonomous infrastructure.
    """

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "DELETING"
    STATUS_DELETING = "DELETING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "DELETED"
    STATUS_DELETED = "DELETED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "UPDATING"
    STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "CREATING"
    STATUS_CREATING = "CREATING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "CREATED"
    STATUS_CREATED = "CREATED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "READY_FOR_CONFIGURATION"
    STATUS_READY_FOR_CONFIGURATION = "READY_FOR_CONFIGURATION"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "CONFIGURED"
    STATUS_CONFIGURED = "CONFIGURED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseShardWithDedicatedInfra.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedAutonomousDatabaseShardWithDedicatedInfra object with values from keyword arguments. The default value of the :py:attr:`~oci.distributed_database.models.DistributedAutonomousDatabaseShardWithDedicatedInfra.source` attribute
        of this class is ``ADB_D`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
            Allowed values for this property are: "ADB_D", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source: str

        :param name:
            The value to assign to the name property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type name: str

        :param time_created:
            The value to assign to the time_created property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type time_updated: datetime

        :param compute_count:
            The value to assign to the compute_count property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type compute_count: float

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type data_storage_size_in_gbs: float

        :param is_auto_scaling_enabled:
            The value to assign to the is_auto_scaling_enabled property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type is_auto_scaling_enabled: bool

        :param shard_group:
            The value to assign to the shard_group property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type shard_group: str

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type cloud_autonomous_vm_cluster_id: str

        :param peer_cloud_autonomous_vm_cluster_ids:
            The value to assign to the peer_cloud_autonomous_vm_cluster_ids property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type peer_cloud_autonomous_vm_cluster_ids: list[str]

        :param shard_space:
            The value to assign to the shard_space property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type shard_space: str

        :param vault_id:
            The value to assign to the vault_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type vault_id: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type kms_key_version_id: str

        :param status:
            The value to assign to the status property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
            Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param supporting_resource_id:
            The value to assign to the supporting_resource_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type supporting_resource_id: str

        :param container_database_id:
            The value to assign to the container_database_id property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type container_database_id: str

        :param peer_details:
            The value to assign to the peer_details property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type peer_details: list[oci.distributed_database.models.ShardPeerWithDedicatedInfra]

        :param metadata:
            The value to assign to the metadata property of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type metadata: oci.distributed_database.models.DistributedAutonomousDbMetadata

        """
        self.swagger_types = {
            'source': 'str',
            'name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'compute_count': 'float',
            'data_storage_size_in_gbs': 'float',
            'is_auto_scaling_enabled': 'bool',
            'shard_group': 'str',
            'cloud_autonomous_vm_cluster_id': 'str',
            'peer_cloud_autonomous_vm_cluster_ids': 'list[str]',
            'shard_space': 'str',
            'vault_id': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'status': 'str',
            'supporting_resource_id': 'str',
            'container_database_id': 'str',
            'peer_details': 'list[ShardPeerWithDedicatedInfra]',
            'metadata': 'DistributedAutonomousDbMetadata'
        }
        self.attribute_map = {
            'source': 'source',
            'name': 'name',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'compute_count': 'computeCount',
            'data_storage_size_in_gbs': 'dataStorageSizeInGbs',
            'is_auto_scaling_enabled': 'isAutoScalingEnabled',
            'shard_group': 'shardGroup',
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'peer_cloud_autonomous_vm_cluster_ids': 'peerCloudAutonomousVmClusterIds',
            'shard_space': 'shardSpace',
            'vault_id': 'vaultId',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'status': 'status',
            'supporting_resource_id': 'supportingResourceId',
            'container_database_id': 'containerDatabaseId',
            'peer_details': 'peerDetails',
            'metadata': 'metadata'
        }
        self._source = None
        self._name = None
        self._time_created = None
        self._time_updated = None
        self._compute_count = None
        self._data_storage_size_in_gbs = None
        self._is_auto_scaling_enabled = None
        self._shard_group = None
        self._cloud_autonomous_vm_cluster_id = None
        self._peer_cloud_autonomous_vm_cluster_ids = None
        self._shard_space = None
        self._vault_id = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._status = None
        self._supporting_resource_id = None
        self._container_database_id = None
        self._peer_details = None
        self._metadata = None
        self._source = 'ADB_D'

    @property
    def compute_count(self):
        """
        **[Required]** Gets the compute_count of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The compute count for the shard database. It has to be in multiples of 2.


        :return: The compute_count of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: float
        """
        return self._compute_count

    @compute_count.setter
    def compute_count(self, compute_count):
        """
        Sets the compute_count of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The compute count for the shard database. It has to be in multiples of 2.


        :param compute_count: The compute_count of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: float
        """
        self._compute_count = compute_count

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The data disk group size to be allocated in GBs for the shard database.


        :return: The data_storage_size_in_gbs of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: float
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The data disk group size to be allocated in GBs for the shard database.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: float
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def is_auto_scaling_enabled(self):
        """
        **[Required]** Gets the is_auto_scaling_enabled of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Determines the auto-scaling mode for the shard database.


        :return: The is_auto_scaling_enabled of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, is_auto_scaling_enabled):
        """
        Sets the is_auto_scaling_enabled of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Determines the auto-scaling mode for the shard database.


        :param is_auto_scaling_enabled: The is_auto_scaling_enabled of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: bool
        """
        self._is_auto_scaling_enabled = is_auto_scaling_enabled

    @property
    def shard_group(self):
        """
        **[Required]** Gets the shard_group of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The name of the shardGroup for the shard.


        :return: The shard_group of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._shard_group

    @shard_group.setter
    def shard_group(self, shard_group):
        """
        Sets the shard_group of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The name of the shardGroup for the shard.


        :param shard_group: The shard_group of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._shard_group = shard_group

    @property
    def cloud_autonomous_vm_cluster_id(self):
        """
        **[Required]** Gets the cloud_autonomous_vm_cluster_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The `OCID`__ of the cloudAutonomousVmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_autonomous_vm_cluster_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._cloud_autonomous_vm_cluster_id

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, cloud_autonomous_vm_cluster_id):
        """
        Sets the cloud_autonomous_vm_cluster_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The `OCID`__ of the cloudAutonomousVmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_autonomous_vm_cluster_id: The cloud_autonomous_vm_cluster_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._cloud_autonomous_vm_cluster_id = cloud_autonomous_vm_cluster_id

    @property
    def peer_cloud_autonomous_vm_cluster_ids(self):
        """
        Gets the peer_cloud_autonomous_vm_cluster_ids of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The collection of `OCID`__ of the peer cloudAutonomousVmClusters.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The peer_cloud_autonomous_vm_cluster_ids of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: list[str]
        """
        return self._peer_cloud_autonomous_vm_cluster_ids

    @peer_cloud_autonomous_vm_cluster_ids.setter
    def peer_cloud_autonomous_vm_cluster_ids(self, peer_cloud_autonomous_vm_cluster_ids):
        """
        Sets the peer_cloud_autonomous_vm_cluster_ids of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The collection of `OCID`__ of the peer cloudAutonomousVmClusters.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param peer_cloud_autonomous_vm_cluster_ids: The peer_cloud_autonomous_vm_cluster_ids of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: list[str]
        """
        self._peer_cloud_autonomous_vm_cluster_ids = peer_cloud_autonomous_vm_cluster_ids

    @property
    def shard_space(self):
        """
        Gets the shard_space of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The shard space name for the Globally distributed autonomous database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :return: The shard_space of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._shard_space

    @shard_space.setter
    def shard_space(self, shard_space):
        """
        Sets the shard_space of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The shard space name for the Globally distributed autonomous database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :param shard_space: The shard_space of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._shard_space = shard_space

    @property
    def vault_id(self):
        """
        Gets the vault_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :return: The kms_key_version_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :param kms_key_version_id: The kms_key_version_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    @property
    def status(self):
        """
        **[Required]** Gets the status of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Status of shard with dedicated infrastructure for the Globally distributed autonomous database.

        Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Status of shard with dedicated infrastructure for the Globally distributed autonomous database.


        :param status: The status of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        allowed_values = ["FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def supporting_resource_id(self):
        """
        Gets the supporting_resource_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        the identifier of the underlying supporting resource.


        :return: The supporting_resource_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._supporting_resource_id

    @supporting_resource_id.setter
    def supporting_resource_id(self, supporting_resource_id):
        """
        Sets the supporting_resource_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        the identifier of the underlying supporting resource.


        :param supporting_resource_id: The supporting_resource_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._supporting_resource_id = supporting_resource_id

    @property
    def container_database_id(self):
        """
        Gets the container_database_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        the identifier of the container database for underlying supporting resource.


        :return: The container_database_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: str
        """
        return self._container_database_id

    @container_database_id.setter
    def container_database_id(self, container_database_id):
        """
        Sets the container_database_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        the identifier of the container database for underlying supporting resource.


        :param container_database_id: The container_database_id of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: str
        """
        self._container_database_id = container_database_id

    @property
    def peer_details(self):
        """
        Gets the peer_details of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Peer details for the shard with dedicated infrastructure.


        :return: The peer_details of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: list[oci.distributed_database.models.ShardPeerWithDedicatedInfra]
        """
        return self._peer_details

    @peer_details.setter
    def peer_details(self, peer_details):
        """
        Sets the peer_details of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        Peer details for the shard with dedicated infrastructure.


        :param peer_details: The peer_details of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: list[oci.distributed_database.models.ShardPeerWithDedicatedInfra]
        """
        self._peer_details = peer_details

    @property
    def metadata(self):
        """
        Gets the metadata of this DistributedAutonomousDatabaseShardWithDedicatedInfra.

        :return: The metadata of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :rtype: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this DistributedAutonomousDatabaseShardWithDedicatedInfra.

        :param metadata: The metadata of this DistributedAutonomousDatabaseShardWithDedicatedInfra.
        :type: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
