# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFleetDetails(object):
    """
    The information about new Fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFleetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateFleetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateFleetDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFleetDetails.
        :type compartment_id: str

        :param details:
            The value to assign to the details property of this CreateFleetDetails.
        :type details: oci.fleet_apps_management.models.FleetDetails

        :param products:
            The value to assign to the products property of this CreateFleetDetails.
        :type products: list[str]

        :param environment_type:
            The value to assign to the environment_type property of this CreateFleetDetails.
        :type environment_type: str

        :param resource_selection:
            The value to assign to the resource_selection property of this CreateFleetDetails.
        :type resource_selection: oci.fleet_apps_management.models.ResourceSelection

        :param notification_preferences:
            The value to assign to the notification_preferences property of this CreateFleetDetails.
        :type notification_preferences: list[oci.fleet_apps_management.models.NotificationPreference]

        :param resources:
            The value to assign to the resources property of this CreateFleetDetails.
        :type resources: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]

        :param credentials:
            The value to assign to the credentials property of this CreateFleetDetails.
        :type credentials: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]

        :param properties:
            The value to assign to the properties property of this CreateFleetDetails.
        :type properties: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]

        :param parent_fleet_id:
            The value to assign to the parent_fleet_id property of this CreateFleetDetails.
        :type parent_fleet_id: str

        :param is_target_auto_confirm:
            The value to assign to the is_target_auto_confirm property of this CreateFleetDetails.
        :type is_target_auto_confirm: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFleetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFleetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'details': 'FleetDetails',
            'products': 'list[str]',
            'environment_type': 'str',
            'resource_selection': 'ResourceSelection',
            'notification_preferences': 'list[NotificationPreference]',
            'resources': 'list[AssociatedFleetResourceDetails]',
            'credentials': 'list[AssociatedFleetCredentialDetails]',
            'properties': 'list[AssociatedFleetPropertyDetails]',
            'parent_fleet_id': 'str',
            'is_target_auto_confirm': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'details': 'details',
            'products': 'products',
            'environment_type': 'environmentType',
            'resource_selection': 'resourceSelection',
            'notification_preferences': 'notificationPreferences',
            'resources': 'resources',
            'credentials': 'credentials',
            'properties': 'properties',
            'parent_fleet_id': 'parentFleetId',
            'is_target_auto_confirm': 'isTargetAutoConfirm',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._details = None
        self._products = None
        self._environment_type = None
        self._resource_selection = None
        self._notification_preferences = None
        self._resources = None
        self._credentials = None
        self._properties = None
        self._parent_fleet_id = None
        self._is_target_auto_confirm = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this CreateFleetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFleetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this CreateFleetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this CreateFleetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateFleetDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this CreateFleetDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFleetDetails.
        compartment OCID


        :return: The compartment_id of this CreateFleetDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFleetDetails.
        compartment OCID


        :param compartment_id: The compartment_id of this CreateFleetDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def details(self):
        """
        Gets the details of this CreateFleetDetails.

        :return: The details of this CreateFleetDetails.
        :rtype: oci.fleet_apps_management.models.FleetDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this CreateFleetDetails.

        :param details: The details of this CreateFleetDetails.
        :type: oci.fleet_apps_management.models.FleetDetails
        """
        self._details = details

    @property
    def products(self):
        """
        Gets the products of this CreateFleetDetails.
        Products associated with the Fleet.


        :return: The products of this CreateFleetDetails.
        :rtype: list[str]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this CreateFleetDetails.
        Products associated with the Fleet.


        :param products: The products of this CreateFleetDetails.
        :type: list[str]
        """
        self._products = products

    @property
    def environment_type(self):
        """
        Gets the environment_type of this CreateFleetDetails.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :return: The environment_type of this CreateFleetDetails.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this CreateFleetDetails.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :param environment_type: The environment_type of this CreateFleetDetails.
        :type: str
        """
        self._environment_type = environment_type

    @property
    def resource_selection(self):
        """
        **[Required]** Gets the resource_selection of this CreateFleetDetails.

        :return: The resource_selection of this CreateFleetDetails.
        :rtype: oci.fleet_apps_management.models.ResourceSelection
        """
        return self._resource_selection

    @resource_selection.setter
    def resource_selection(self, resource_selection):
        """
        Sets the resource_selection of this CreateFleetDetails.

        :param resource_selection: The resource_selection of this CreateFleetDetails.
        :type: oci.fleet_apps_management.models.ResourceSelection
        """
        self._resource_selection = resource_selection

    @property
    def notification_preferences(self):
        """
        Gets the notification_preferences of this CreateFleetDetails.
        Notification Preferences associated with the Fleet.


        :return: The notification_preferences of this CreateFleetDetails.
        :rtype: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        return self._notification_preferences

    @notification_preferences.setter
    def notification_preferences(self, notification_preferences):
        """
        Sets the notification_preferences of this CreateFleetDetails.
        Notification Preferences associated with the Fleet.


        :param notification_preferences: The notification_preferences of this CreateFleetDetails.
        :type: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        self._notification_preferences = notification_preferences

    @property
    def resources(self):
        """
        Gets the resources of this CreateFleetDetails.
        Resources associated with the Fleet if resourceSelectionType is MANUAL.


        :return: The resources of this CreateFleetDetails.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this CreateFleetDetails.
        Resources associated with the Fleet if resourceSelectionType is MANUAL.


        :param resources: The resources of this CreateFleetDetails.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]
        """
        self._resources = resources

    @property
    def credentials(self):
        """
        Gets the credentials of this CreateFleetDetails.
        Credentials associated with the Fleet.


        :return: The credentials of this CreateFleetDetails.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """
        Sets the credentials of this CreateFleetDetails.
        Credentials associated with the Fleet.


        :param credentials: The credentials of this CreateFleetDetails.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]
        """
        self._credentials = credentials

    @property
    def properties(self):
        """
        Gets the properties of this CreateFleetDetails.
        Properties associated with the Fleet.


        :return: The properties of this CreateFleetDetails.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this CreateFleetDetails.
        Properties associated with the Fleet.


        :param properties: The properties of this CreateFleetDetails.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]
        """
        self._properties = properties

    @property
    def parent_fleet_id(self):
        """
        Gets the parent_fleet_id of this CreateFleetDetails.
        The `OCID`__ of the fleet that would be the parent for this fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The parent_fleet_id of this CreateFleetDetails.
        :rtype: str
        """
        return self._parent_fleet_id

    @parent_fleet_id.setter
    def parent_fleet_id(self, parent_fleet_id):
        """
        Sets the parent_fleet_id of this CreateFleetDetails.
        The `OCID`__ of the fleet that would be the parent for this fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param parent_fleet_id: The parent_fleet_id of this CreateFleetDetails.
        :type: str
        """
        self._parent_fleet_id = parent_fleet_id

    @property
    def is_target_auto_confirm(self):
        """
        Gets the is_target_auto_confirm of this CreateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :return: The is_target_auto_confirm of this CreateFleetDetails.
        :rtype: bool
        """
        return self._is_target_auto_confirm

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, is_target_auto_confirm):
        """
        Sets the is_target_auto_confirm of this CreateFleetDetails.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :param is_target_auto_confirm: The is_target_auto_confirm of this CreateFleetDetails.
        :type: bool
        """
        self._is_target_auto_confirm = is_target_auto_confirm

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateFleetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFleetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateFleetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateFleetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFleetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateFleetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
