# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProductStackSubCategoryDetails(object):
    """
    ProductStack Config Category Details.
    """

    #: A constant which can be used with the sub_category property of a ProductStackSubCategoryDetails.
    #: This constant has a value of "PRODUCT_STACK_GENERIC"
    SUB_CATEGORY_PRODUCT_STACK_GENERIC = "PRODUCT_STACK_GENERIC"

    #: A constant which can be used with the sub_category property of a ProductStackSubCategoryDetails.
    #: This constant has a value of "PRODUCT_STACK_AS_PRODUCT"
    SUB_CATEGORY_PRODUCT_STACK_AS_PRODUCT = "PRODUCT_STACK_AS_PRODUCT"

    def __init__(self, **kwargs):
        """
        Initializes a new ProductStackSubCategoryDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.ProductStackAsProductSubCategoryDetails`
        * :class:`~oci.fleet_apps_management.models.ProductStackGenericSubCategoryDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sub_category:
            The value to assign to the sub_category property of this ProductStackSubCategoryDetails.
            Allowed values for this property are: "PRODUCT_STACK_GENERIC", "PRODUCT_STACK_AS_PRODUCT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sub_category: str

        """
        self.swagger_types = {
            'sub_category': 'str'
        }
        self.attribute_map = {
            'sub_category': 'subCategory'
        }
        self._sub_category = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['subCategory']

        if type == 'PRODUCT_STACK_AS_PRODUCT':
            return 'ProductStackAsProductSubCategoryDetails'

        if type == 'PRODUCT_STACK_GENERIC':
            return 'ProductStackGenericSubCategoryDetails'
        else:
            return 'ProductStackSubCategoryDetails'

    @property
    def sub_category(self):
        """
        **[Required]** Gets the sub_category of this ProductStackSubCategoryDetails.
        SubCategory of Product Stack.

        Allowed values for this property are: "PRODUCT_STACK_GENERIC", "PRODUCT_STACK_AS_PRODUCT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sub_category of this ProductStackSubCategoryDetails.
        :rtype: str
        """
        return self._sub_category

    @sub_category.setter
    def sub_category(self, sub_category):
        """
        Sets the sub_category of this ProductStackSubCategoryDetails.
        SubCategory of Product Stack.


        :param sub_category: The sub_category of this ProductStackSubCategoryDetails.
        :type: str
        """
        allowed_values = ["PRODUCT_STACK_GENERIC", "PRODUCT_STACK_AS_PRODUCT"]
        if not value_allowed_none_or_none_sentinel(sub_category, allowed_values):
            sub_category = 'UNKNOWN_ENUM_VALUE'
        self._sub_category = sub_category

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
