# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchedulerExecutionSummary(object):
    """
    Summary of the Scheduler Executions.
    """

    #: A constant which can be used with the lifecycle_state property of a SchedulerExecutionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SchedulerExecutionSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a SchedulerExecutionSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a SchedulerExecutionSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new SchedulerExecutionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SchedulerExecutionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this SchedulerExecutionSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SchedulerExecutionSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this SchedulerExecutionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SchedulerExecutionSummary.
        :type time_updated: datetime

        :param time_scheduled:
            The value to assign to the time_scheduled property of this SchedulerExecutionSummary.
        :type time_scheduled: datetime

        :param activity_id:
            The value to assign to the activity_id property of this SchedulerExecutionSummary.
        :type activity_id: str

        :param resource_id:
            The value to assign to the resource_id property of this SchedulerExecutionSummary.
        :type resource_id: str

        :param scheduler_job_id:
            The value to assign to the scheduler_job_id property of this SchedulerExecutionSummary.
        :type scheduler_job_id: str

        :param resource_display_name:
            The value to assign to the resource_display_name property of this SchedulerExecutionSummary.
        :type resource_display_name: str

        :param runbook_id:
            The value to assign to the runbook_id property of this SchedulerExecutionSummary.
        :type runbook_id: str

        :param runbook_version_name:
            The value to assign to the runbook_version_name property of this SchedulerExecutionSummary.
        :type runbook_version_name: str

        :param runbook_display_name:
            The value to assign to the runbook_display_name property of this SchedulerExecutionSummary.
        :type runbook_display_name: str

        :param latest_runbook_version_name:
            The value to assign to the latest_runbook_version_name property of this SchedulerExecutionSummary.
        :type latest_runbook_version_name: str

        :param scheduler_definition:
            The value to assign to the scheduler_definition property of this SchedulerExecutionSummary.
        :type scheduler_definition: oci.fleet_apps_management.models.AssociatedSchedulerDefinition

        :param time_started:
            The value to assign to the time_started property of this SchedulerExecutionSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this SchedulerExecutionSummary.
        :type time_ended: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SchedulerExecutionSummary.
            Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this SchedulerExecutionSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SchedulerExecutionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SchedulerExecutionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this SchedulerExecutionSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_scheduled': 'datetime',
            'activity_id': 'str',
            'resource_id': 'str',
            'scheduler_job_id': 'str',
            'resource_display_name': 'str',
            'runbook_id': 'str',
            'runbook_version_name': 'str',
            'runbook_display_name': 'str',
            'latest_runbook_version_name': 'str',
            'scheduler_definition': 'AssociatedSchedulerDefinition',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_scheduled': 'timeScheduled',
            'activity_id': 'activityId',
            'resource_id': 'resourceId',
            'scheduler_job_id': 'schedulerJobId',
            'resource_display_name': 'resourceDisplayName',
            'runbook_id': 'runbookId',
            'runbook_version_name': 'runbookVersionName',
            'runbook_display_name': 'runbookDisplayName',
            'latest_runbook_version_name': 'latestRunbookVersionName',
            'scheduler_definition': 'schedulerDefinition',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._time_scheduled = None
        self._activity_id = None
        self._resource_id = None
        self._scheduler_job_id = None
        self._resource_display_name = None
        self._runbook_id = None
        self._runbook_version_name = None
        self._runbook_display_name = None
        self._latest_runbook_version_name = None
        self._scheduler_definition = None
        self._time_started = None
        self._time_ended = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SchedulerExecutionSummary.
        The OCID of the resource.


        :return: The id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SchedulerExecutionSummary.
        The OCID of the resource.


        :param id: The id of this SchedulerExecutionSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this SchedulerExecutionSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this SchedulerExecutionSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this SchedulerExecutionSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SchedulerExecutionSummary.
        Compartment OCID


        :return: The compartment_id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SchedulerExecutionSummary.
        Compartment OCID


        :param compartment_id: The compartment_id of this SchedulerExecutionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SchedulerExecutionSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this SchedulerExecutionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SchedulerExecutionSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this SchedulerExecutionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this SchedulerExecutionSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this SchedulerExecutionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SchedulerExecutionSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this SchedulerExecutionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_scheduled(self):
        """
        Gets the time_scheduled of this SchedulerExecutionSummary.
        The scheduled date and time for the Job.


        :return: The time_scheduled of this SchedulerExecutionSummary.
        :rtype: datetime
        """
        return self._time_scheduled

    @time_scheduled.setter
    def time_scheduled(self, time_scheduled):
        """
        Sets the time_scheduled of this SchedulerExecutionSummary.
        The scheduled date and time for the Job.


        :param time_scheduled: The time_scheduled of this SchedulerExecutionSummary.
        :type: datetime
        """
        self._time_scheduled = time_scheduled

    @property
    def activity_id(self):
        """
        Gets the activity_id of this SchedulerExecutionSummary.
        Action Group associated with the Schedule.


        :return: The activity_id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """
        Sets the activity_id of this SchedulerExecutionSummary.
        Action Group associated with the Schedule.


        :param activity_id: The activity_id of this SchedulerExecutionSummary.
        :type: str
        """
        self._activity_id = activity_id

    @property
    def resource_id(self):
        """
        Gets the resource_id of this SchedulerExecutionSummary.
        ResourceId associated with the Schedule.


        :return: The resource_id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this SchedulerExecutionSummary.
        ResourceId associated with the Schedule.


        :param resource_id: The resource_id of this SchedulerExecutionSummary.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def scheduler_job_id(self):
        """
        Gets the scheduler_job_id of this SchedulerExecutionSummary.
        jobId associated with the Schedule.


        :return: The scheduler_job_id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._scheduler_job_id

    @scheduler_job_id.setter
    def scheduler_job_id(self, scheduler_job_id):
        """
        Sets the scheduler_job_id of this SchedulerExecutionSummary.
        jobId associated with the Schedule.


        :param scheduler_job_id: The scheduler_job_id of this SchedulerExecutionSummary.
        :type: str
        """
        self._scheduler_job_id = scheduler_job_id

    @property
    def resource_display_name(self):
        """
        Gets the resource_display_name of this SchedulerExecutionSummary.
        Resource DsiplayName associated with the Schedule.


        :return: The resource_display_name of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._resource_display_name

    @resource_display_name.setter
    def resource_display_name(self, resource_display_name):
        """
        Sets the resource_display_name of this SchedulerExecutionSummary.
        Resource DsiplayName associated with the Schedule.


        :param resource_display_name: The resource_display_name of this SchedulerExecutionSummary.
        :type: str
        """
        self._resource_display_name = resource_display_name

    @property
    def runbook_id(self):
        """
        Gets the runbook_id of this SchedulerExecutionSummary.
        RunbookId associated with the Schedule.


        :return: The runbook_id of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this SchedulerExecutionSummary.
        RunbookId associated with the Schedule.


        :param runbook_id: The runbook_id of this SchedulerExecutionSummary.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def runbook_version_name(self):
        """
        Gets the runbook_version_name of this SchedulerExecutionSummary.
        Name of the Runbook version associated with the Schedule.


        :return: The runbook_version_name of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._runbook_version_name

    @runbook_version_name.setter
    def runbook_version_name(self, runbook_version_name):
        """
        Sets the runbook_version_name of this SchedulerExecutionSummary.
        Name of the Runbook version associated with the Schedule.


        :param runbook_version_name: The runbook_version_name of this SchedulerExecutionSummary.
        :type: str
        """
        self._runbook_version_name = runbook_version_name

    @property
    def runbook_display_name(self):
        """
        Gets the runbook_display_name of this SchedulerExecutionSummary.
        DsiplayName of Runbook associated with the Schedule.


        :return: The runbook_display_name of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._runbook_display_name

    @runbook_display_name.setter
    def runbook_display_name(self, runbook_display_name):
        """
        Sets the runbook_display_name of this SchedulerExecutionSummary.
        DsiplayName of Runbook associated with the Schedule.


        :param runbook_display_name: The runbook_display_name of this SchedulerExecutionSummary.
        :type: str
        """
        self._runbook_display_name = runbook_display_name

    @property
    def latest_runbook_version_name(self):
        """
        Gets the latest_runbook_version_name of this SchedulerExecutionSummary.
        Latest Runbook version available.


        :return: The latest_runbook_version_name of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._latest_runbook_version_name

    @latest_runbook_version_name.setter
    def latest_runbook_version_name(self, latest_runbook_version_name):
        """
        Sets the latest_runbook_version_name of this SchedulerExecutionSummary.
        Latest Runbook version available.


        :param latest_runbook_version_name: The latest_runbook_version_name of this SchedulerExecutionSummary.
        :type: str
        """
        self._latest_runbook_version_name = latest_runbook_version_name

    @property
    def scheduler_definition(self):
        """
        Gets the scheduler_definition of this SchedulerExecutionSummary.

        :return: The scheduler_definition of this SchedulerExecutionSummary.
        :rtype: oci.fleet_apps_management.models.AssociatedSchedulerDefinition
        """
        return self._scheduler_definition

    @scheduler_definition.setter
    def scheduler_definition(self, scheduler_definition):
        """
        Sets the scheduler_definition of this SchedulerExecutionSummary.

        :param scheduler_definition: The scheduler_definition of this SchedulerExecutionSummary.
        :type: oci.fleet_apps_management.models.AssociatedSchedulerDefinition
        """
        self._scheduler_definition = scheduler_definition

    @property
    def time_started(self):
        """
        Gets the time_started of this SchedulerExecutionSummary.
        Actual start date and time for the Execution.


        :return: The time_started of this SchedulerExecutionSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this SchedulerExecutionSummary.
        Actual start date and time for the Execution.


        :param time_started: The time_started of this SchedulerExecutionSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this SchedulerExecutionSummary.
        Actual end date and time for the Execution.


        :return: The time_ended of this SchedulerExecutionSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this SchedulerExecutionSummary.
        Actual end date and time for the Execution.


        :param time_ended: The time_ended of this SchedulerExecutionSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SchedulerExecutionSummary.
        The current state of the Scheduler Execution.

        Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SchedulerExecutionSummary.
        The current state of the Scheduler Execution.


        :param lifecycle_state: The lifecycle_state of this SchedulerExecutionSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED", "FAILED", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this SchedulerExecutionSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this SchedulerExecutionSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this SchedulerExecutionSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this SchedulerExecutionSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this SchedulerExecutionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this SchedulerExecutionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SchedulerExecutionSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this SchedulerExecutionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this SchedulerExecutionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this SchedulerExecutionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SchedulerExecutionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this SchedulerExecutionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this SchedulerExecutionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this SchedulerExecutionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this SchedulerExecutionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this SchedulerExecutionSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
