# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateRunbookDetails(object):
    """
    The information to be updated.
    """

    #: A constant which can be used with the os_type property of a UpdateRunbookDetails.
    #: This constant has a value of "WINDOWS"
    OS_TYPE_WINDOWS = "WINDOWS"

    #: A constant which can be used with the os_type property of a UpdateRunbookDetails.
    #: This constant has a value of "LINUX"
    OS_TYPE_LINUX = "LINUX"

    #: A constant which can be used with the os_type property of a UpdateRunbookDetails.
    #: This constant has a value of "GENERIC"
    OS_TYPE_GENERIC = "GENERIC"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateRunbookDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateRunbookDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateRunbookDetails.
        :type description: str

        :param is_sudo_access_needed:
            The value to assign to the is_sudo_access_needed property of this UpdateRunbookDetails.
        :type is_sudo_access_needed: bool

        :param operation:
            The value to assign to the operation property of this UpdateRunbookDetails.
        :type operation: str

        :param os_type:
            The value to assign to the os_type property of this UpdateRunbookDetails.
            Allowed values for this property are: "WINDOWS", "LINUX", "GENERIC"
        :type os_type: str

        :param platform:
            The value to assign to the platform property of this UpdateRunbookDetails.
        :type platform: str

        :param is_default:
            The value to assign to the is_default property of this UpdateRunbookDetails.
        :type is_default: bool

        :param estimated_time:
            The value to assign to the estimated_time property of this UpdateRunbookDetails.
        :type estimated_time: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateRunbookDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateRunbookDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'is_sudo_access_needed': 'bool',
            'operation': 'str',
            'os_type': 'str',
            'platform': 'str',
            'is_default': 'bool',
            'estimated_time': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'is_sudo_access_needed': 'isSudoAccessNeeded',
            'operation': 'operation',
            'os_type': 'osType',
            'platform': 'platform',
            'is_default': 'isDefault',
            'estimated_time': 'estimatedTime',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._is_sudo_access_needed = None
        self._operation = None
        self._os_type = None
        self._platform = None
        self._is_default = None
        self._estimated_time = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateRunbookDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateRunbookDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this UpdateRunbookDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateRunbookDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateRunbookDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this UpdateRunbookDetails.
        :type: str
        """
        self._description = description

    @property
    def is_sudo_access_needed(self):
        """
        Gets the is_sudo_access_needed of this UpdateRunbookDetails.
        Does this runbook need SUDO access to execute?


        :return: The is_sudo_access_needed of this UpdateRunbookDetails.
        :rtype: bool
        """
        return self._is_sudo_access_needed

    @is_sudo_access_needed.setter
    def is_sudo_access_needed(self, is_sudo_access_needed):
        """
        Sets the is_sudo_access_needed of this UpdateRunbookDetails.
        Does this runbook need SUDO access to execute?


        :param is_sudo_access_needed: The is_sudo_access_needed of this UpdateRunbookDetails.
        :type: bool
        """
        self._is_sudo_access_needed = is_sudo_access_needed

    @property
    def operation(self):
        """
        Gets the operation of this UpdateRunbookDetails.
        The lifecycle operation performed by the runbook.


        :return: The operation of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this UpdateRunbookDetails.
        The lifecycle operation performed by the runbook.


        :param operation: The operation of this UpdateRunbookDetails.
        :type: str
        """
        self._operation = operation

    @property
    def os_type(self):
        """
        Gets the os_type of this UpdateRunbookDetails.
        The OS type for the runbook.

        Allowed values for this property are: "WINDOWS", "LINUX", "GENERIC"


        :return: The os_type of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """
        Sets the os_type of this UpdateRunbookDetails.
        The OS type for the runbook.


        :param os_type: The os_type of this UpdateRunbookDetails.
        :type: str
        """
        allowed_values = ["WINDOWS", "LINUX", "GENERIC"]
        if not value_allowed_none_or_none_sentinel(os_type, allowed_values):
            raise ValueError(
                f"Invalid value for `os_type`, must be None or one of {allowed_values}"
            )
        self._os_type = os_type

    @property
    def platform(self):
        """
        Gets the platform of this UpdateRunbookDetails.
        The platform of the runbook.


        :return: The platform of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this UpdateRunbookDetails.
        The platform of the runbook.


        :param platform: The platform of this UpdateRunbookDetails.
        :type: str
        """
        self._platform = platform

    @property
    def is_default(self):
        """
        Gets the is_default of this UpdateRunbookDetails.
        Is the runbook default?


        :return: The is_default of this UpdateRunbookDetails.
        :rtype: bool
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """
        Sets the is_default of this UpdateRunbookDetails.
        Is the runbook default?


        :param is_default: The is_default of this UpdateRunbookDetails.
        :type: bool
        """
        self._is_default = is_default

    @property
    def estimated_time(self):
        """
        Gets the estimated_time of this UpdateRunbookDetails.
        Estimated time to successfully complete the runbook execution.


        :return: The estimated_time of this UpdateRunbookDetails.
        :rtype: str
        """
        return self._estimated_time

    @estimated_time.setter
    def estimated_time(self, estimated_time):
        """
        Sets the estimated_time of this UpdateRunbookDetails.
        Estimated time to successfully complete the runbook execution.


        :param estimated_time: The estimated_time of this UpdateRunbookDetails.
        :type: str
        """
        self._estimated_time = estimated_time

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateRunbookDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateRunbookDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateRunbookDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateRunbookDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateRunbookDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateRunbookDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateRunbookDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateRunbookDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
