# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .remove_fsu_collection_targets_details import RemoveFsuCollectionTargetsDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetIdsRemoveTargetsDetails(RemoveFsuCollectionTargetsDetails):
    """
    Remove a list of targets from a Exadata Fleet Update Collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetIdsRemoveTargetsDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.TargetIdsRemoveTargetsDetails.removal_strategy` attribute
        of this class is ``TARGET_IDS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param removal_strategy:
            The value to assign to the removal_strategy property of this TargetIdsRemoveTargetsDetails.
            Allowed values for this property are: "TARGET_IDS"
        :type removal_strategy: str

        :param targets:
            The value to assign to the targets property of this TargetIdsRemoveTargetsDetails.
        :type targets: list[oci.fleet_software_update.models.TargetEntry]

        """
        self.swagger_types = {
            'removal_strategy': 'str',
            'targets': 'list[TargetEntry]'
        }
        self.attribute_map = {
            'removal_strategy': 'removalStrategy',
            'targets': 'targets'
        }
        self._removal_strategy = None
        self._targets = None
        self._removal_strategy = 'TARGET_IDS'

    @property
    def targets(self):
        """
        **[Required]** Gets the targets of this TargetIdsRemoveTargetsDetails.
        List of target entries to remove from the Exadata Fleet Update Collection.


        :return: The targets of this TargetIdsRemoveTargetsDetails.
        :rtype: list[oci.fleet_software_update.models.TargetEntry]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this TargetIdsRemoveTargetsDetails.
        List of target entries to remove from the Exadata Fleet Update Collection.


        :param targets: The targets of this TargetIdsRemoveTargetsDetails.
        :type: list[oci.fleet_software_update.models.TargetEntry]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
