# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .update_fsu_cycle_details import UpdateFsuCycleDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateUpgradeFsuCycle(UpdateFsuCycleDetails):
    """
    Update Upgrade Exadata Fleet Update Cycle resource details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateUpgradeFsuCycle object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.UpdateUpgradeFsuCycle.type` attribute
        of this class is ``UPGRADE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateUpgradeFsuCycle.
        :type display_name: str

        :param type:
            The value to assign to the type property of this UpdateUpgradeFsuCycle.
            Allowed values for this property are: "PATCH", "UPGRADE"
        :type type: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this UpdateUpgradeFsuCycle.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this UpdateUpgradeFsuCycle.
        :type batching_strategy: oci.fleet_software_update.models.UpdateBatchingStrategyDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this UpdateUpgradeFsuCycle.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateUpgradeFsuCycle.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateUpgradeFsuCycle.
        :type defined_tags: dict(str, dict(str, object))

        :param upgrade_details:
            The value to assign to the upgrade_details property of this UpdateUpgradeFsuCycle.
        :type upgrade_details: oci.fleet_software_update.models.UpgradeDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'UpdateBatchingStrategyDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'upgrade_details': 'UpgradeDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'diagnostics_collection': 'diagnosticsCollection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'upgrade_details': 'upgradeDetails'
        }
        self._display_name = None
        self._type = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._diagnostics_collection = None
        self._freeform_tags = None
        self._defined_tags = None
        self._upgrade_details = None
        self._type = 'UPGRADE'

    @property
    def upgrade_details(self):
        """
        Gets the upgrade_details of this UpdateUpgradeFsuCycle.

        :return: The upgrade_details of this UpdateUpgradeFsuCycle.
        :rtype: oci.fleet_software_update.models.UpgradeDetails
        """
        return self._upgrade_details

    @upgrade_details.setter
    def upgrade_details(self, upgrade_details):
        """
        Sets the upgrade_details of this UpdateUpgradeFsuCycle.

        :param upgrade_details: The upgrade_details of this UpdateUpgradeFsuCycle.
        :type: oci.fleet_software_update.models.UpgradeDetails
        """
        self._upgrade_details = upgrade_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
