# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .upgrade_details import UpgradeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpgradeGiCollectionDetails(UpgradeDetails):
    """
    Details of supported upgrade options for GI collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpgradeGiCollectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.UpgradeGiCollectionDetails.collection_type` attribute
        of this class is ``GI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collection_type:
            The value to assign to the collection_type property of this UpgradeGiCollectionDetails.
            Allowed values for this property are: "DB", "GI"
        :type collection_type: str

        :param is_ignore_prerequisites:
            The value to assign to the is_ignore_prerequisites property of this UpgradeGiCollectionDetails.
        :type is_ignore_prerequisites: bool

        :param is_ignore_post_upgrade_errors:
            The value to assign to the is_ignore_post_upgrade_errors property of this UpgradeGiCollectionDetails.
        :type is_ignore_post_upgrade_errors: bool

        """
        self.swagger_types = {
            'collection_type': 'str',
            'is_ignore_prerequisites': 'bool',
            'is_ignore_post_upgrade_errors': 'bool'
        }
        self.attribute_map = {
            'collection_type': 'collectionType',
            'is_ignore_prerequisites': 'isIgnorePrerequisites',
            'is_ignore_post_upgrade_errors': 'isIgnorePostUpgradeErrors'
        }
        self._collection_type = None
        self._is_ignore_prerequisites = None
        self._is_ignore_post_upgrade_errors = None
        self._collection_type = 'GI'

    @property
    def is_ignore_prerequisites(self):
        """
        Gets the is_ignore_prerequisites of this UpgradeGiCollectionDetails.
        Ignore the Cluster Verification Utility (CVU) prerequisite checks.


        :return: The is_ignore_prerequisites of this UpgradeGiCollectionDetails.
        :rtype: bool
        """
        return self._is_ignore_prerequisites

    @is_ignore_prerequisites.setter
    def is_ignore_prerequisites(self, is_ignore_prerequisites):
        """
        Sets the is_ignore_prerequisites of this UpgradeGiCollectionDetails.
        Ignore the Cluster Verification Utility (CVU) prerequisite checks.


        :param is_ignore_prerequisites: The is_ignore_prerequisites of this UpgradeGiCollectionDetails.
        :type: bool
        """
        self._is_ignore_prerequisites = is_ignore_prerequisites

    @property
    def is_ignore_post_upgrade_errors(self):
        """
        Gets the is_ignore_post_upgrade_errors of this UpgradeGiCollectionDetails.
        Ignore errors during post Oracle Grid Infrastructure upgrade Cluster Verification Utility (CVU) check.


        :return: The is_ignore_post_upgrade_errors of this UpgradeGiCollectionDetails.
        :rtype: bool
        """
        return self._is_ignore_post_upgrade_errors

    @is_ignore_post_upgrade_errors.setter
    def is_ignore_post_upgrade_errors(self, is_ignore_post_upgrade_errors):
        """
        Sets the is_ignore_post_upgrade_errors of this UpgradeGiCollectionDetails.
        Ignore errors during post Oracle Grid Infrastructure upgrade Cluster Verification Utility (CVU) check.


        :param is_ignore_post_upgrade_errors: The is_ignore_post_upgrade_errors of this UpgradeGiCollectionDetails.
        :type: bool
        """
        self._is_ignore_post_upgrade_errors = is_ignore_post_upgrade_errors

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
