# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Usage(object):
    """
    Details of usage.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Usage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_details:
            The value to assign to the model_details property of this Usage.
        :type model_details: oci.generative_ai_agent_runtime.models.ModelDetails

        :param usage_details:
            The value to assign to the usage_details property of this Usage.
        :type usage_details: oci.generative_ai_agent_runtime.models.UsageDetails

        """
        self.swagger_types = {
            'model_details': 'ModelDetails',
            'usage_details': 'UsageDetails'
        }
        self.attribute_map = {
            'model_details': 'modelDetails',
            'usage_details': 'usageDetails'
        }
        self._model_details = None
        self._usage_details = None

    @property
    def model_details(self):
        """
        Gets the model_details of this Usage.

        :return: The model_details of this Usage.
        :rtype: oci.generative_ai_agent_runtime.models.ModelDetails
        """
        return self._model_details

    @model_details.setter
    def model_details(self, model_details):
        """
        Sets the model_details of this Usage.

        :param model_details: The model_details of this Usage.
        :type: oci.generative_ai_agent_runtime.models.ModelDetails
        """
        self._model_details = model_details

    @property
    def usage_details(self):
        """
        Gets the usage_details of this Usage.

        :return: The usage_details of this Usage.
        :rtype: oci.generative_ai_agent_runtime.models.UsageDetails
        """
        return self._usage_details

    @usage_details.setter
    def usage_details(self, usage_details):
        """
        Sets the usage_details of this Usage.

        :param usage_details: The usage_details of this Usage.
        :type: oci.generative_ai_agent_runtime.models.UsageDetails
        """
        self._usage_details = usage_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
