# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .base_chat_response import BaseChatResponse
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericChatResponse(BaseChatResponse):
    """
    The response for a chat conversation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenericChatResponse object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.GenericChatResponse.api_format` attribute
        of this class is ``GENERIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_format:
            The value to assign to the api_format property of this GenericChatResponse.
            Allowed values for this property are: "COHERE", "GENERIC"
        :type api_format: str

        :param time_created:
            The value to assign to the time_created property of this GenericChatResponse.
        :type time_created: datetime

        :param choices:
            The value to assign to the choices property of this GenericChatResponse.
        :type choices: list[oci.generative_ai_inference.models.ChatChoice]

        """
        self.swagger_types = {
            'api_format': 'str',
            'time_created': 'datetime',
            'choices': 'list[ChatChoice]'
        }
        self.attribute_map = {
            'api_format': 'apiFormat',
            'time_created': 'timeCreated',
            'choices': 'choices'
        }
        self._api_format = None
        self._time_created = None
        self._choices = None
        self._api_format = 'GENERIC'

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this GenericChatResponse.
        The Unix timestamp (in seconds) of when the response text was generated.


        :return: The time_created of this GenericChatResponse.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this GenericChatResponse.
        The Unix timestamp (in seconds) of when the response text was generated.


        :param time_created: The time_created of this GenericChatResponse.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def choices(self):
        """
        **[Required]** Gets the choices of this GenericChatResponse.
        A list of generated texts. Can be more than one if n is greater than 1.


        :return: The choices of this GenericChatResponse.
        :rtype: list[oci.generative_ai_inference.models.ChatChoice]
        """
        return self._choices

    @choices.setter
    def choices(self, choices):
        """
        Sets the choices of this GenericChatResponse.
        A list of generated texts. Can be more than one if n is greater than 1.


        :param choices: The choices of this GenericChatResponse.
        :type: list[oci.generative_ai_inference.models.ChatChoice]
        """
        self._choices = choices

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
