# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MappingRule(object):
    """
    Mapping rule for source and target schemas for the pipeline data replication.
    For example:
    \"{mappingType: INCLUDE, source: HR.*, target: HR.*}\" for rule \"Include HR.*\" which will include all the tables under HR schema.
    """

    #: A constant which can be used with the mapping_type property of a MappingRule.
    #: This constant has a value of "INCLUDE"
    MAPPING_TYPE_INCLUDE = "INCLUDE"

    #: A constant which can be used with the mapping_type property of a MappingRule.
    #: This constant has a value of "EXCLUDE"
    MAPPING_TYPE_EXCLUDE = "EXCLUDE"

    def __init__(self, **kwargs):
        """
        Initializes a new MappingRule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mapping_type:
            The value to assign to the mapping_type property of this MappingRule.
            Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mapping_type: str

        :param source:
            The value to assign to the source property of this MappingRule.
        :type source: str

        :param target:
            The value to assign to the target property of this MappingRule.
        :type target: str

        """
        self.swagger_types = {
            'mapping_type': 'str',
            'source': 'str',
            'target': 'str'
        }
        self.attribute_map = {
            'mapping_type': 'mappingType',
            'source': 'source',
            'target': 'target'
        }
        self._mapping_type = None
        self._source = None
        self._target = None

    @property
    def mapping_type(self):
        """
        **[Required]** Gets the mapping_type of this MappingRule.
        Defines the exclude/include rules of source and target schemas and tables when replicating from source to target. This option applies when creating and updating a pipeline.

        Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mapping_type of this MappingRule.
        :rtype: str
        """
        return self._mapping_type

    @mapping_type.setter
    def mapping_type(self, mapping_type):
        """
        Sets the mapping_type of this MappingRule.
        Defines the exclude/include rules of source and target schemas and tables when replicating from source to target. This option applies when creating and updating a pipeline.


        :param mapping_type: The mapping_type of this MappingRule.
        :type: str
        """
        allowed_values = ["INCLUDE", "EXCLUDE"]
        if not value_allowed_none_or_none_sentinel(mapping_type, allowed_values):
            mapping_type = 'UNKNOWN_ENUM_VALUE'
        self._mapping_type = mapping_type

    @property
    def source(self):
        """
        **[Required]** Gets the source of this MappingRule.
        The source schema/table combination for replication to target.


        :return: The source of this MappingRule.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this MappingRule.
        The source schema/table combination for replication to target.


        :param source: The source of this MappingRule.
        :type: str
        """
        self._source = source

    @property
    def target(self):
        """
        Gets the target of this MappingRule.
        The target schema/table combination for replication from the source.


        :return: The target of this MappingRule.
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this MappingRule.
        The target schema/table combination for replication from the source.


        :param target: The target of this MappingRule.
        :type: str
        """
        self._target = target

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
