# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Agent(object):
    """
    Information about the agent.
    """

    #: A constant which can be used with the type property of a Agent.
    #: This constant has a value of "OMA"
    TYPE_OMA = "OMA"

    #: A constant which can be used with the type property of a Agent.
    #: This constant has a value of "OCA"
    TYPE_OCA = "OCA"

    #: A constant which can be used with the java_security_status property of a Agent.
    #: This constant has a value of "EARLY_ACCESS"
    JAVA_SECURITY_STATUS_EARLY_ACCESS = "EARLY_ACCESS"

    #: A constant which can be used with the java_security_status property of a Agent.
    #: This constant has a value of "UNKNOWN"
    JAVA_SECURITY_STATUS_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the java_security_status property of a Agent.
    #: This constant has a value of "UP_TO_DATE"
    JAVA_SECURITY_STATUS_UP_TO_DATE = "UP_TO_DATE"

    #: A constant which can be used with the java_security_status property of a Agent.
    #: This constant has a value of "UPDATE_REQUIRED"
    JAVA_SECURITY_STATUS_UPDATE_REQUIRED = "UPDATE_REQUIRED"

    #: A constant which can be used with the java_security_status property of a Agent.
    #: This constant has a value of "UPGRADE_REQUIRED"
    JAVA_SECURITY_STATUS_UPGRADE_REQUIRED = "UPGRADE_REQUIRED"

    def __init__(self, **kwargs):
        """
        Initializes a new Agent object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this Agent.
        :type display_name: str

        :param type:
            The value to assign to the type property of this Agent.
            Allowed values for this property are: "OMA", "OCA", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param java_version:
            The value to assign to the java_version property of this Agent.
        :type java_version: str

        :param java_security_status:
            The value to assign to the java_security_status property of this Agent.
            Allowed values for this property are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type java_security_status: str

        :param plugins:
            The value to assign to the plugins property of this Agent.
        :type plugins: list[oci.jms.models.Plugin]

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'java_version': 'str',
            'java_security_status': 'str',
            'plugins': 'list[Plugin]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'java_version': 'javaVersion',
            'java_security_status': 'javaSecurityStatus',
            'plugins': 'plugins'
        }
        self._display_name = None
        self._type = None
        self._java_version = None
        self._java_security_status = None
        self._plugins = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Agent.
        The name of the agent.


        :return: The display_name of this Agent.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Agent.
        The name of the agent.


        :param display_name: The display_name of this Agent.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this Agent.
        The agent type.

        Allowed values for this property are: "OMA", "OCA", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this Agent.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Agent.
        The agent type.


        :param type: The type of this Agent.
        :type: str
        """
        allowed_values = ["OMA", "OCA"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def java_version(self):
        """
        **[Required]** Gets the java_version of this Agent.
        The java version.


        :return: The java_version of this Agent.
        :rtype: str
        """
        return self._java_version

    @java_version.setter
    def java_version(self, java_version):
        """
        Sets the java_version of this Agent.
        The java version.


        :param java_version: The java_version of this Agent.
        :type: str
        """
        self._java_version = java_version

    @property
    def java_security_status(self):
        """
        **[Required]** Gets the java_security_status of this Agent.
        The security status of the Java Runtime.

        Allowed values for this property are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The java_security_status of this Agent.
        :rtype: str
        """
        return self._java_security_status

    @java_security_status.setter
    def java_security_status(self, java_security_status):
        """
        Sets the java_security_status of this Agent.
        The security status of the Java Runtime.


        :param java_security_status: The java_security_status of this Agent.
        :type: str
        """
        allowed_values = ["EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED"]
        if not value_allowed_none_or_none_sentinel(java_security_status, allowed_values):
            java_security_status = 'UNKNOWN_ENUM_VALUE'
        self._java_security_status = java_security_status

    @property
    def plugins(self):
        """
        **[Required]** Gets the plugins of this Agent.
        A list of plugins installed on this agent.


        :return: The plugins of this Agent.
        :rtype: list[oci.jms.models.Plugin]
        """
        return self._plugins

    @plugins.setter
    def plugins(self, plugins):
        """
        Sets the plugins of this Agent.
        A list of plugins installed on this agent.


        :param plugins: The plugins of this Agent.
        :type: list[oci.jms.models.Plugin]
        """
        self._plugins = plugins

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
