# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PluginErrorSummary(object):
    """
    Entity that represents an error identified in a plugin.
    """

    #: A constant which can be used with the agent_type property of a PluginErrorSummary.
    #: This constant has a value of "OMA"
    AGENT_TYPE_OMA = "OMA"

    #: A constant which can be used with the agent_type property of a PluginErrorSummary.
    #: This constant has a value of "OCA"
    AGENT_TYPE_OCA = "OCA"

    def __init__(self, **kwargs):
        """
        Initializes a new PluginErrorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param managed_instance_id:
            The value to assign to the managed_instance_id property of this PluginErrorSummary.
        :type managed_instance_id: str

        :param agent_type:
            The value to assign to the agent_type property of this PluginErrorSummary.
            Allowed values for this property are: "OMA", "OCA", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type agent_type: str

        :param host_name:
            The value to assign to the host_name property of this PluginErrorSummary.
        :type host_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PluginErrorSummary.
        :type compartment_id: str

        :param errors:
            The value to assign to the errors property of this PluginErrorSummary.
        :type errors: list[oci.jms.models.PluginErrorDetails]

        :param time_last_seen:
            The value to assign to the time_last_seen property of this PluginErrorSummary.
        :type time_last_seen: datetime

        :param time_first_seen:
            The value to assign to the time_first_seen property of this PluginErrorSummary.
        :type time_first_seen: datetime

        """
        self.swagger_types = {
            'managed_instance_id': 'str',
            'agent_type': 'str',
            'host_name': 'str',
            'compartment_id': 'str',
            'errors': 'list[PluginErrorDetails]',
            'time_last_seen': 'datetime',
            'time_first_seen': 'datetime'
        }
        self.attribute_map = {
            'managed_instance_id': 'managedInstanceId',
            'agent_type': 'agentType',
            'host_name': 'hostName',
            'compartment_id': 'compartmentId',
            'errors': 'errors',
            'time_last_seen': 'timeLastSeen',
            'time_first_seen': 'timeFirstSeen'
        }
        self._managed_instance_id = None
        self._agent_type = None
        self._host_name = None
        self._compartment_id = None
        self._errors = None
        self._time_last_seen = None
        self._time_first_seen = None

    @property
    def managed_instance_id(self):
        """
        **[Required]** Gets the managed_instance_id of this PluginErrorSummary.
        The `OCID`__ of the Managed Instance running the plugin.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_id of this PluginErrorSummary.
        :rtype: str
        """
        return self._managed_instance_id

    @managed_instance_id.setter
    def managed_instance_id(self, managed_instance_id):
        """
        Sets the managed_instance_id of this PluginErrorSummary.
        The `OCID`__ of the Managed Instance running the plugin.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param managed_instance_id: The managed_instance_id of this PluginErrorSummary.
        :type: str
        """
        self._managed_instance_id = managed_instance_id

    @property
    def agent_type(self):
        """
        Gets the agent_type of this PluginErrorSummary.
        The agent type.

        Allowed values for this property are: "OMA", "OCA", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The agent_type of this PluginErrorSummary.
        :rtype: str
        """
        return self._agent_type

    @agent_type.setter
    def agent_type(self, agent_type):
        """
        Sets the agent_type of this PluginErrorSummary.
        The agent type.


        :param agent_type: The agent_type of this PluginErrorSummary.
        :type: str
        """
        allowed_values = ["OMA", "OCA"]
        if not value_allowed_none_or_none_sentinel(agent_type, allowed_values):
            agent_type = 'UNKNOWN_ENUM_VALUE'
        self._agent_type = agent_type

    @property
    def host_name(self):
        """
        Gets the host_name of this PluginErrorSummary.
        The HostName or Compute Instance name of the Managed Instance running the plugin.


        :return: The host_name of this PluginErrorSummary.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this PluginErrorSummary.
        The HostName or Compute Instance name of the Managed Instance running the plugin.


        :param host_name: The host_name of this PluginErrorSummary.
        :type: str
        """
        self._host_name = host_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PluginErrorSummary.
        The compartment `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PluginErrorSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PluginErrorSummary.
        The compartment `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PluginErrorSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def errors(self):
        """
        **[Required]** Gets the errors of this PluginErrorSummary.
        List of plugin error details.


        :return: The errors of this PluginErrorSummary.
        :rtype: list[oci.jms.models.PluginErrorDetails]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this PluginErrorSummary.
        List of plugin error details.


        :param errors: The errors of this PluginErrorSummary.
        :type: list[oci.jms.models.PluginErrorDetails]
        """
        self._errors = errors

    @property
    def time_last_seen(self):
        """
        **[Required]** Gets the time_last_seen of this PluginErrorSummary.
        The timestamp of the last time an error was detected.


        :return: The time_last_seen of this PluginErrorSummary.
        :rtype: datetime
        """
        return self._time_last_seen

    @time_last_seen.setter
    def time_last_seen(self, time_last_seen):
        """
        Sets the time_last_seen of this PluginErrorSummary.
        The timestamp of the last time an error was detected.


        :param time_last_seen: The time_last_seen of this PluginErrorSummary.
        :type: datetime
        """
        self._time_last_seen = time_last_seen

    @property
    def time_first_seen(self):
        """
        **[Required]** Gets the time_first_seen of this PluginErrorSummary.
        The timestamp of the first time an error was detected.


        :return: The time_first_seen of this PluginErrorSummary.
        :rtype: datetime
        """
        return self._time_first_seen

    @time_first_seen.setter
    def time_first_seen(self, time_first_seen):
        """
        Sets the time_first_seen of this PluginErrorSummary.
        The timestamp of the first time an error was detected.


        :param time_first_seen: The time_first_seen of this PluginErrorSummary.
        :type: datetime
        """
        self._time_first_seen = time_first_seen

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
