# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EffectivePropertySummary(object):
    """
    A property and its effective value details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EffectivePropertySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this EffectivePropertySummary.
        :type name: str

        :param value:
            The value to assign to the value property of this EffectivePropertySummary.
        :type value: str

        :param effective_level:
            The value to assign to the effective_level property of this EffectivePropertySummary.
        :type effective_level: str

        :param patterns:
            The value to assign to the patterns property of this EffectivePropertySummary.
        :type patterns: list[oci.log_analytics.models.PatternOverride]

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'effective_level': 'str',
            'patterns': 'list[PatternOverride]'
        }
        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'effective_level': 'effectiveLevel',
            'patterns': 'patterns'
        }
        self._name = None
        self._value = None
        self._effective_level = None
        self._patterns = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this EffectivePropertySummary.
        The property name.


        :return: The name of this EffectivePropertySummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EffectivePropertySummary.
        The property name.


        :param name: The name of this EffectivePropertySummary.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this EffectivePropertySummary.
        The effective value of the property. This is determined by considering the value set at the most effective level.


        :return: The value of this EffectivePropertySummary.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this EffectivePropertySummary.
        The effective value of the property. This is determined by considering the value set at the most effective level.


        :param value: The value of this EffectivePropertySummary.
        :type: str
        """
        self._value = value

    @property
    def effective_level(self):
        """
        Gets the effective_level of this EffectivePropertySummary.
        The level from which the effective value was determined.


        :return: The effective_level of this EffectivePropertySummary.
        :rtype: str
        """
        return self._effective_level

    @effective_level.setter
    def effective_level(self, effective_level):
        """
        Sets the effective_level of this EffectivePropertySummary.
        The level from which the effective value was determined.


        :param effective_level: The effective_level of this EffectivePropertySummary.
        :type: str
        """
        self._effective_level = effective_level

    @property
    def patterns(self):
        """
        Gets the patterns of this EffectivePropertySummary.
        A list of pattern level override values for the property.


        :return: The patterns of this EffectivePropertySummary.
        :rtype: list[oci.log_analytics.models.PatternOverride]
        """
        return self._patterns

    @patterns.setter
    def patterns(self, patterns):
        """
        Sets the patterns of this EffectivePropertySummary.
        A list of pattern level override values for the property.


        :param patterns: The patterns of this EffectivePropertySummary.
        :type: list[oci.log_analytics.models.PatternOverride]
        """
        self._patterns = patterns

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
