# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatternOverride(object):
    """
    Details of pattern level override for a property.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatternOverride object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PatternOverride.
        :type id: str

        :param value:
            The value to assign to the value property of this PatternOverride.
        :type value: str

        :param effective_level:
            The value to assign to the effective_level property of this PatternOverride.
        :type effective_level: str

        """
        self.swagger_types = {
            'id': 'str',
            'value': 'str',
            'effective_level': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'value': 'value',
            'effective_level': 'effectiveLevel'
        }
        self._id = None
        self._value = None
        self._effective_level = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PatternOverride.
        The pattern id.


        :return: The id of this PatternOverride.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PatternOverride.
        The pattern id.


        :param id: The id of this PatternOverride.
        :type: str
        """
        self._id = id

    @property
    def value(self):
        """
        **[Required]** Gets the value of this PatternOverride.
        The value of the property.


        :return: The value of this PatternOverride.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this PatternOverride.
        The value of the property.


        :param value: The value of this PatternOverride.
        :type: str
        """
        self._value = value

    @property
    def effective_level(self):
        """
        Gets the effective_level of this PatternOverride.
        The effective level of the property value.


        :return: The effective_level of this PatternOverride.
        :rtype: str
        """
        return self._effective_level

    @effective_level.setter
    def effective_level(self, effective_level):
        """
        Sets the effective_level of this PatternOverride.
        The effective level of the property value.


        :param effective_level: The effective_level of this PatternOverride.
        :type: str
        """
        self._effective_level = effective_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
