# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NamedCredentialSummary(object):
    """
    A representation of a named credential in the Management Agent.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NamedCredentialSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NamedCredentialSummary.
        :type id: str

        :param name:
            The value to assign to the name property of this NamedCredentialSummary.
        :type name: str

        :param type:
            The value to assign to the type property of this NamedCredentialSummary.
        :type type: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this NamedCredentialSummary.
        :type management_agent_id: str

        :param description:
            The value to assign to the description property of this NamedCredentialSummary.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this NamedCredentialSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this NamedCredentialSummary.
        :type time_updated: datetime

        :param properties:
            The value to assign to the properties property of this NamedCredentialSummary.
        :type properties: list[oci.management_agent.models.NamedCredentialProperty]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this NamedCredentialSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this NamedCredentialSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this NamedCredentialSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this NamedCredentialSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'management_agent_id': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'properties': 'list[NamedCredentialProperty]',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'management_agent_id': 'managementAgentId',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'properties': 'properties',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._type = None
        self._management_agent_id = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._properties = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NamedCredentialSummary.
        Identifier for Named Credential. This is the NamedCredential resource OCID.


        :return: The id of this NamedCredentialSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NamedCredentialSummary.
        Identifier for Named Credential. This is the NamedCredential resource OCID.


        :param id: The id of this NamedCredentialSummary.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this NamedCredentialSummary.
        Name for Named Credential. This is unique for the Management Agent.


        :return: The name of this NamedCredentialSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NamedCredentialSummary.
        Name for Named Credential. This is unique for the Management Agent.


        :param name: The name of this NamedCredentialSummary.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this NamedCredentialSummary.
        Type of the Named Credential


        :return: The type of this NamedCredentialSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this NamedCredentialSummary.
        Type of the Named Credential


        :param type: The type of this NamedCredentialSummary.
        :type: str
        """
        self._type = type

    @property
    def management_agent_id(self):
        """
        **[Required]** Gets the management_agent_id of this NamedCredentialSummary.
        The Management Agent this named credential is associated with. This is the ManagementAgent resource OCID.


        :return: The management_agent_id of this NamedCredentialSummary.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this NamedCredentialSummary.
        The Management Agent this named credential is associated with. This is the ManagementAgent resource OCID.


        :param management_agent_id: The management_agent_id of this NamedCredentialSummary.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def description(self):
        """
        Gets the description of this NamedCredentialSummary.
        Description of the Named Credential.


        :return: The description of this NamedCredentialSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NamedCredentialSummary.
        Description of the Named Credential.


        :param description: The description of this NamedCredentialSummary.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NamedCredentialSummary.
        The time the Named Credential was created. An RFC3339 formatted datetime string


        :return: The time_created of this NamedCredentialSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NamedCredentialSummary.
        The time the Named Credential was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this NamedCredentialSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this NamedCredentialSummary.
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this NamedCredentialSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this NamedCredentialSummary.
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this NamedCredentialSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def properties(self):
        """
        **[Required]** Gets the properties of this NamedCredentialSummary.
        Properties for the named credential


        :return: The properties of this NamedCredentialSummary.
        :rtype: list[oci.management_agent.models.NamedCredentialProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this NamedCredentialSummary.
        Properties for the named credential


        :param properties: The properties of this NamedCredentialSummary.
        :type: list[oci.management_agent.models.NamedCredentialProperty]
        """
        self._properties = properties

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this NamedCredentialSummary.
        The current state of the named credential


        :return: The lifecycle_state of this NamedCredentialSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this NamedCredentialSummary.
        The current state of the named credential


        :param lifecycle_state: The lifecycle_state of this NamedCredentialSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this NamedCredentialSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this NamedCredentialSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this NamedCredentialSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this NamedCredentialSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this NamedCredentialSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this NamedCredentialSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this NamedCredentialSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this NamedCredentialSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this NamedCredentialSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :return: The system_tags of this NamedCredentialSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this NamedCredentialSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :param system_tags: The system_tags of this NamedCredentialSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
