# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .listing_revision import ListingRevision
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LeadGenListingRevision(ListingRevision):
    """
    Listing revision details for lead gen listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LeadGenListingRevision object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.LeadGenListingRevision.listing_type` attribute
        of this class is ``LEAD_GENERATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LeadGenListingRevision.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this LeadGenListingRevision.
        :type listing_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LeadGenListingRevision.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this LeadGenListingRevision.
        :type display_name: str

        :param revision_number:
            The value to assign to the revision_number property of this LeadGenListingRevision.
        :type revision_number: str

        :param headline:
            The value to assign to the headline property of this LeadGenListingRevision.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this LeadGenListingRevision.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this LeadGenListingRevision.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this LeadGenListingRevision.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this LeadGenListingRevision.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this LeadGenListingRevision.
        :type long_description: str

        :param time_created:
            The value to assign to the time_created property of this LeadGenListingRevision.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this LeadGenListingRevision.
        :type time_updated: datetime

        :param content_language:
            The value to assign to the content_language property of this LeadGenListingRevision.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this LeadGenListingRevision.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this LeadGenListingRevision.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this LeadGenListingRevision.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param icon:
            The value to assign to the icon property of this LeadGenListingRevision.
        :type icon: oci.marketplace_publisher.models.ListingRevisionIconAttachment

        :param status:
            The value to assign to the status property of this LeadGenListingRevision.
            Allowed values for this property are: "NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED"
        :type status: str

        :param status_notes:
            The value to assign to the status_notes property of this LeadGenListingRevision.
        :type status_notes: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LeadGenListingRevision.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param package_type:
            The value to assign to the package_type property of this LeadGenListingRevision.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"
        :type package_type: str

        :param listing_type:
            The value to assign to the listing_type property of this LeadGenListingRevision.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this LeadGenListingRevision.
        :type extended_metadata: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LeadGenListingRevision.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LeadGenListingRevision.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this LeadGenListingRevision.
        :type system_tags: dict(str, dict(str, object))

        :param version_details:
            The value to assign to the version_details property of this LeadGenListingRevision.
        :type version_details: oci.marketplace_publisher.models.VersionDetails

        :param system_requirements:
            The value to assign to the system_requirements property of this LeadGenListingRevision.
        :type system_requirements: str

        :param pricing_type:
            The value to assign to the pricing_type property of this LeadGenListingRevision.
        :type pricing_type: str

        :param demo_url:
            The value to assign to the demo_url property of this LeadGenListingRevision.
        :type demo_url: str

        :param self_paced_training_url:
            The value to assign to the self_paced_training_url property of this LeadGenListingRevision.
        :type self_paced_training_url: str

        :param recommended_service_provider_listing_ids:
            The value to assign to the recommended_service_provider_listing_ids property of this LeadGenListingRevision.
        :type recommended_service_provider_listing_ids: list[str]

        :param vanity_url:
            The value to assign to the vanity_url property of this LeadGenListingRevision.
        :type vanity_url: str

        :param download_info:
            The value to assign to the download_info property of this LeadGenListingRevision.
        :type download_info: oci.marketplace_publisher.models.DownloadInfo

        :param pricing_plans:
            The value to assign to the pricing_plans property of this LeadGenListingRevision.
        :type pricing_plans: str

        :param products:
            The value to assign to the products property of this LeadGenListingRevision.
        :type products: list[oci.marketplace_publisher.models.ListingProduct]

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'revision_number': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'icon': 'ListingRevisionIconAttachment',
            'status': 'str',
            'status_notes': 'str',
            'lifecycle_state': 'str',
            'package_type': 'str',
            'listing_type': 'str',
            'extended_metadata': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'version_details': 'VersionDetails',
            'system_requirements': 'str',
            'pricing_type': 'str',
            'demo_url': 'str',
            'self_paced_training_url': 'str',
            'recommended_service_provider_listing_ids': 'list[str]',
            'vanity_url': 'str',
            'download_info': 'DownloadInfo',
            'pricing_plans': 'str',
            'products': 'list[ListingProduct]'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'revision_number': 'revisionNumber',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'icon': 'icon',
            'status': 'status',
            'status_notes': 'statusNotes',
            'lifecycle_state': 'lifecycleState',
            'package_type': 'packageType',
            'listing_type': 'listingType',
            'extended_metadata': 'extendedMetadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'version_details': 'versionDetails',
            'system_requirements': 'systemRequirements',
            'pricing_type': 'pricingType',
            'demo_url': 'demoUrl',
            'self_paced_training_url': 'selfPacedTrainingUrl',
            'recommended_service_provider_listing_ids': 'recommendedServiceProviderListingIds',
            'vanity_url': 'vanityUrl',
            'download_info': 'downloadInfo',
            'pricing_plans': 'pricingPlans',
            'products': 'products'
        }
        self._id = None
        self._listing_id = None
        self._compartment_id = None
        self._display_name = None
        self._revision_number = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._time_created = None
        self._time_updated = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._icon = None
        self._status = None
        self._status_notes = None
        self._lifecycle_state = None
        self._package_type = None
        self._listing_type = None
        self._extended_metadata = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._version_details = None
        self._system_requirements = None
        self._pricing_type = None
        self._demo_url = None
        self._self_paced_training_url = None
        self._recommended_service_provider_listing_ids = None
        self._vanity_url = None
        self._download_info = None
        self._pricing_plans = None
        self._products = None
        self._listing_type = 'LEAD_GENERATION'

    @property
    def version_details(self):
        """
        Gets the version_details of this LeadGenListingRevision.

        :return: The version_details of this LeadGenListingRevision.
        :rtype: oci.marketplace_publisher.models.VersionDetails
        """
        return self._version_details

    @version_details.setter
    def version_details(self, version_details):
        """
        Sets the version_details of this LeadGenListingRevision.

        :param version_details: The version_details of this LeadGenListingRevision.
        :type: oci.marketplace_publisher.models.VersionDetails
        """
        self._version_details = version_details

    @property
    def system_requirements(self):
        """
        Gets the system_requirements of this LeadGenListingRevision.
        System requirements for the listing revision.


        :return: The system_requirements of this LeadGenListingRevision.
        :rtype: str
        """
        return self._system_requirements

    @system_requirements.setter
    def system_requirements(self, system_requirements):
        """
        Sets the system_requirements of this LeadGenListingRevision.
        System requirements for the listing revision.


        :param system_requirements: The system_requirements of this LeadGenListingRevision.
        :type: str
        """
        self._system_requirements = system_requirements

    @property
    def pricing_type(self):
        """
        **[Required]** Gets the pricing_type of this LeadGenListingRevision.
        The pricing model for the listing revision.


        :return: The pricing_type of this LeadGenListingRevision.
        :rtype: str
        """
        return self._pricing_type

    @pricing_type.setter
    def pricing_type(self, pricing_type):
        """
        Sets the pricing_type of this LeadGenListingRevision.
        The pricing model for the listing revision.


        :param pricing_type: The pricing_type of this LeadGenListingRevision.
        :type: str
        """
        self._pricing_type = pricing_type

    @property
    def demo_url(self):
        """
        Gets the demo_url of this LeadGenListingRevision.
        Url to demo of the listing


        :return: The demo_url of this LeadGenListingRevision.
        :rtype: str
        """
        return self._demo_url

    @demo_url.setter
    def demo_url(self, demo_url):
        """
        Sets the demo_url of this LeadGenListingRevision.
        Url to demo of the listing


        :param demo_url: The demo_url of this LeadGenListingRevision.
        :type: str
        """
        self._demo_url = demo_url

    @property
    def self_paced_training_url(self):
        """
        Gets the self_paced_training_url of this LeadGenListingRevision.
        Url to training resources of the listing


        :return: The self_paced_training_url of this LeadGenListingRevision.
        :rtype: str
        """
        return self._self_paced_training_url

    @self_paced_training_url.setter
    def self_paced_training_url(self, self_paced_training_url):
        """
        Sets the self_paced_training_url of this LeadGenListingRevision.
        Url to training resources of the listing


        :param self_paced_training_url: The self_paced_training_url of this LeadGenListingRevision.
        :type: str
        """
        self._self_paced_training_url = self_paced_training_url

    @property
    def recommended_service_provider_listing_ids(self):
        """
        Gets the recommended_service_provider_listing_ids of this LeadGenListingRevision.
        OCIDs of service listings attached to lead gen listing


        :return: The recommended_service_provider_listing_ids of this LeadGenListingRevision.
        :rtype: list[str]
        """
        return self._recommended_service_provider_listing_ids

    @recommended_service_provider_listing_ids.setter
    def recommended_service_provider_listing_ids(self, recommended_service_provider_listing_ids):
        """
        Sets the recommended_service_provider_listing_ids of this LeadGenListingRevision.
        OCIDs of service listings attached to lead gen listing


        :param recommended_service_provider_listing_ids: The recommended_service_provider_listing_ids of this LeadGenListingRevision.
        :type: list[str]
        """
        self._recommended_service_provider_listing_ids = recommended_service_provider_listing_ids

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this LeadGenListingRevision.
        Custom link to the listing


        :return: The vanity_url of this LeadGenListingRevision.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this LeadGenListingRevision.
        Custom link to the listing


        :param vanity_url: The vanity_url of this LeadGenListingRevision.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def download_info(self):
        """
        Gets the download_info of this LeadGenListingRevision.

        :return: The download_info of this LeadGenListingRevision.
        :rtype: oci.marketplace_publisher.models.DownloadInfo
        """
        return self._download_info

    @download_info.setter
    def download_info(self, download_info):
        """
        Sets the download_info of this LeadGenListingRevision.

        :param download_info: The download_info of this LeadGenListingRevision.
        :type: oci.marketplace_publisher.models.DownloadInfo
        """
        self._download_info = download_info

    @property
    def pricing_plans(self):
        """
        Gets the pricing_plans of this LeadGenListingRevision.
        Pricing details for lead gen listing


        :return: The pricing_plans of this LeadGenListingRevision.
        :rtype: str
        """
        return self._pricing_plans

    @pricing_plans.setter
    def pricing_plans(self, pricing_plans):
        """
        Sets the pricing_plans of this LeadGenListingRevision.
        Pricing details for lead gen listing


        :param pricing_plans: The pricing_plans of this LeadGenListingRevision.
        :type: str
        """
        self._pricing_plans = pricing_plans

    @property
    def products(self):
        """
        **[Required]** Gets the products of this LeadGenListingRevision.
        List of Products subscribed by listing.


        :return: The products of this LeadGenListingRevision.
        :rtype: list[oci.marketplace_publisher.models.ListingProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this LeadGenListingRevision.
        List of Products subscribed by listing.


        :param products: The products of this LeadGenListingRevision.
        :type: list[oci.marketplace_publisher.models.ListingProduct]
        """
        self._products = products

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
