# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedCurrencySummary(object):
    """
    The model for the currencies supported by the Marketplace Publisher Service.
    """

    #: A constant which can be used with the lifecycle_state property of a SupportedCurrencySummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SupportedCurrencySummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedCurrencySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param currency_code:
            The value to assign to the currency_code property of this SupportedCurrencySummary.
        :type currency_code: str

        :param exchange_rate:
            The value to assign to the exchange_rate property of this SupportedCurrencySummary.
        :type exchange_rate: float

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SupportedCurrencySummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'currency_code': 'str',
            'exchange_rate': 'float',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'currency_code': 'currencyCode',
            'exchange_rate': 'exchangeRate',
            'lifecycle_state': 'lifecycleState'
        }
        self._currency_code = None
        self._exchange_rate = None
        self._lifecycle_state = None

    @property
    def currency_code(self):
        """
        **[Required]** Gets the currency_code of this SupportedCurrencySummary.
        The currency code, in the format specified by ISO-4217.


        :return: The currency_code of this SupportedCurrencySummary.
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """
        Sets the currency_code of this SupportedCurrencySummary.
        The currency code, in the format specified by ISO-4217.


        :param currency_code: The currency_code of this SupportedCurrencySummary.
        :type: str
        """
        self._currency_code = currency_code

    @property
    def exchange_rate(self):
        """
        **[Required]** Gets the exchange_rate of this SupportedCurrencySummary.
        Oracle exchange rate for the currency in USD.


        :return: The exchange_rate of this SupportedCurrencySummary.
        :rtype: float
        """
        return self._exchange_rate

    @exchange_rate.setter
    def exchange_rate(self, exchange_rate):
        """
        Sets the exchange_rate of this SupportedCurrencySummary.
        Oracle exchange rate for the currency in USD.


        :param exchange_rate: The exchange_rate of this SupportedCurrencySummary.
        :type: float
        """
        self._exchange_rate = exchange_rate

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SupportedCurrencySummary.
        The current state for the currency.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SupportedCurrencySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SupportedCurrencySummary.
        The current state for the currency.


        :param lifecycle_state: The lifecycle_state of this SupportedCurrencySummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
